/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.VirtualAttributeCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.VirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualAttributeConfigManager
implements ConfigurationChangeListener<VirtualAttributeCfg>,
ConfigurationAddListener<VirtualAttributeCfg>,
ConfigurationDeleteListener<VirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConcurrentHashMap<DN, VirtualAttributeRule> rules = new ConcurrentHashMap();

    public void initializeVirtualAttributes() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addVirtualAttributeAddListener(this);
        rootConfiguration.addVirtualAttributeDeleteListener(this);
        for (String providerName : rootConfiguration.listVirtualAttributes()) {
            VirtualAttributeCfg cfg = rootConfiguration.getVirtualAttribute(providerName);
            cfg.addChangeListener(this);
            if (!cfg.isEnabled()) continue;
            String className = cfg.getProviderClass();
            try {
                VirtualAttributeProvider<? extends VirtualAttributeCfg> provider = this.loadProvider(className, cfg, true);
                LinkedHashSet<SearchFilter> filters = new LinkedHashSet<SearchFilter>();
                for (String filterString : cfg.getFilter()) {
                    try {
                        filters.add(SearchFilter.createFilterFromString(filterString));
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        int msgID = 3408521;
                        String message = MessageHandler.getMessage(msgID, filterString, String.valueOf(cfg.dn()), de.getErrorMessage());
                        throw new ConfigException(msgID, message, de);
                    }
                }
                if (cfg.getAttributeType().isSingleValue()) {
                    String message;
                    if (provider.isMultiValued()) {
                        int msgID = 3408523;
                        message = MessageHandler.getMessage(msgID, String.valueOf(cfg.dn()), cfg.getAttributeType().getNameOrOID(), className);
                        throw new ConfigException(msgID, message);
                    }
                    if (cfg.getConflictBehavior() == VirtualAttributeCfgDefn.ConflictBehavior.MERGE_REAL_AND_VIRTUAL) {
                        int msgID = 3408524;
                        message = MessageHandler.getMessage(msgID, String.valueOf(cfg.dn()), cfg.getAttributeType().getNameOrOID());
                        throw new ConfigException(msgID, message);
                    }
                }
                VirtualAttributeRule rule = new VirtualAttributeRule(cfg.getAttributeType(), provider, cfg.getBaseDN(), cfg.getGroupDN(), filters, cfg.getConflictBehavior());
                this.rules.put(cfg.dn(), rule);
                DirectoryServer.registerVirtualAttribute(rule);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, ie.getMessage(), ie.getMessageID());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(VirtualAttributeCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getProviderClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        }
        for (String filterString : configuration.getFilter()) {
            try {
                SearchFilter.createFilterFromString(filterString);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                int msgID = 3408521;
                String message = MessageHandler.getMessage(msgID, filterString, String.valueOf(configuration.dn()), de.getErrorMessage());
                unacceptableReasons.add(message);
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(VirtualAttributeCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        LinkedHashSet<SearchFilter> filters = new LinkedHashSet<SearchFilter>();
        for (String filterString : configuration.getFilter()) {
            try {
                filters.add(SearchFilter.createFilterFromString(filterString));
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                }
                int msgID = 3408521;
                String message = MessageHandler.getMessage(msgID, filterString, String.valueOf(configuration.dn()), de.getErrorMessage());
                messages.add(message);
            }
        }
        VirtualAttributeProvider<? extends VirtualAttributeCfg> provider = null;
        if (resultCode == ResultCode.SUCCESS) {
            String className = configuration.getProviderClass();
            try {
                provider = this.loadProvider(className, configuration, true);
            }
            catch (InitializationException ie) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ie.getMessage());
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            VirtualAttributeRule rule = new VirtualAttributeRule(configuration.getAttributeType(), provider, configuration.getBaseDN(), configuration.getGroupDN(), filters, configuration.getConflictBehavior());
            this.rules.put(configuration.dn(), rule);
            DirectoryServer.registerVirtualAttribute(rule);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(VirtualAttributeCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(VirtualAttributeCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        VirtualAttributeRule rule = this.rules.remove(configuration.dn());
        if (rule != null) {
            DirectoryServer.deregisterVirtualAttribute(rule);
            rule.getProvider().finalizeVirtualAttributeProvider();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(VirtualAttributeCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getProviderClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        }
        for (String filterString : configuration.getFilter()) {
            try {
                SearchFilter.createFilterFromString(filterString);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                int msgID = 3408521;
                String message = MessageHandler.getMessage(msgID, filterString, String.valueOf(configuration.dn()), de.getErrorMessage());
                unacceptableReasons.add(message);
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(VirtualAttributeCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        VirtualAttributeRule existingRule = this.rules.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingRule != null) {
                DirectoryServer.deregisterVirtualAttribute(existingRule);
                existingRule.getProvider().finalizeVirtualAttributeProvider();
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        LinkedHashSet<SearchFilter> filters = new LinkedHashSet<SearchFilter>();
        for (String filterString : configuration.getFilter()) {
            try {
                filters.add(SearchFilter.createFilterFromString(filterString));
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                }
                int msgID = 3408521;
                String message = MessageHandler.getMessage(msgID, filterString, String.valueOf(configuration.dn()), de.getErrorMessage());
                messages.add(message);
            }
        }
        VirtualAttributeProvider<? extends VirtualAttributeCfg> provider = null;
        if (resultCode == ResultCode.SUCCESS) {
            String className = configuration.getProviderClass();
            try {
                provider = this.loadProvider(className, configuration, true);
            }
            catch (InitializationException ie) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ie.getMessage());
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            VirtualAttributeRule rule = new VirtualAttributeRule(configuration.getAttributeType(), provider, configuration.getBaseDN(), configuration.getGroupDN(), filters, configuration.getConflictBehavior());
            this.rules.put(configuration.dn(), rule);
            if (existingRule == null) {
                DirectoryServer.registerVirtualAttribute(rule);
            } else {
                DirectoryServer.replaceVirtualAttribute(existingRule, rule);
                existingRule.getProvider().finalizeVirtualAttributeProvider();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private VirtualAttributeProvider<? extends VirtualAttributeCfg> loadProvider(String className, VirtualAttributeCfg configuration, boolean initialize) throws InitializationException {
        try {
            VirtualAttributeCfgDefn definition = VirtualAttributeCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getProviderClassPropertyDefinition();
            Class<VirtualAttributeProvider> providerClass = propertyDefinition.loadClass(className, VirtualAttributeProvider.class);
            VirtualAttributeProvider provider = providerClass.newInstance();
            if (initialize) {
                Method method = provider.getClass().getMethod("initializeVirtualAttributeProvider", configuration.definition().getServerConfigurationClass());
                method.invoke((Object)provider, configuration);
            } else {
                Method method = provider.getClass().getMethod("isConfigurationAcceptable", VirtualAttributeCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)provider, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((String)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((String)iterator.next());
                        }
                    }
                    int msgID = 3343030;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(msgID, message);
                }
            }
            return provider;
        }
        catch (Exception e) {
            int msgID = 3408522;
            String message = MessageHandler.getMessage(msgID, className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(msgID, message, e);
        }
    }
}

