/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import org.opends.server.types.ResultCode;

public class WorkflowResultCode {
    private ResultCode resultCode = ResultCode.UNDEFINED;
    private StringBuilder errorMessage = new StringBuilder("");

    public WorkflowResultCode() {
    }

    public WorkflowResultCode(ResultCode resultCode, StringBuilder errorMessage) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
    }

    public boolean elaborateGlobalResultCode(ResultCode newResultCode, StringBuilder newErrorMessage) {
        boolean sendReferenceEntry = false;
        if (this.resultCode == ResultCode.UNDEFINED) {
            this.resultCode = newResultCode;
            this.errorMessage = new StringBuilder(newErrorMessage);
        } else {
            block0 : switch (newResultCode) {
                case SUCCESS: {
                    switch (this.resultCode) {
                        case NO_SUCH_OBJECT: {
                            this.resultCode = ResultCode.SUCCESS;
                            this.errorMessage = new StringBuilder("");
                            break block0;
                        }
                        case REFERRAL: {
                            this.resultCode = ResultCode.SUCCESS;
                            this.errorMessage = new StringBuilder("");
                            sendReferenceEntry = true;
                            break block0;
                        }
                    }
                    break;
                }
                case NO_SUCH_OBJECT: {
                    break;
                }
                case REFERRAL: {
                    switch (this.resultCode) {
                        case REFERRAL: {
                            this.resultCode = ResultCode.SUCCESS;
                            this.errorMessage = new StringBuilder("");
                            sendReferenceEntry = true;
                            break block0;
                        }
                        case NO_SUCH_OBJECT: {
                            this.resultCode = ResultCode.REFERRAL;
                            this.errorMessage = new StringBuilder(newErrorMessage);
                            break block0;
                        }
                    }
                    sendReferenceEntry = true;
                    break;
                }
                default: {
                    switch (this.resultCode) {
                        case REFERRAL: {
                            this.resultCode = newResultCode;
                            this.errorMessage = new StringBuilder(newErrorMessage);
                            sendReferenceEntry = true;
                            break block0;
                        }
                        case SUCCESS: {
                            this.resultCode = newResultCode;
                            this.errorMessage = new StringBuilder(newErrorMessage);
                            break block0;
                        }
                        case NO_SUCH_OBJECT: {
                            this.resultCode = newResultCode;
                            this.errorMessage = new StringBuilder(newErrorMessage);
                            break block0;
                        }
                    }
                    if (this.errorMessage == null) {
                        this.errorMessage = new StringBuilder(newErrorMessage);
                        break;
                    }
                    this.errorMessage.append((CharSequence)newErrorMessage);
                }
            }
        }
        return sendReferenceEntry;
    }

    public ResultCode resultCode() {
        return this.resultCode;
    }

    public StringBuilder errorMessage() {
        return this.errorMessage;
    }
}

