/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnonymousSASLMechanismHandler
extends SASLMechanismHandler<SASLMechanismHandlerCfg> {
    @Override
    public void initializeSASLMechanismHandler(SASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        DirectoryServer.registerSASLMechanismHandler("ANONYMOUS", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        DirectoryServer.deregisterSASLMechanismHandler("ANONYMOUS");
    }

    @Override
    public void processSASLBind(BindOperation bindOperation) {
        String credString;
        ASN1OctetString saslCredentials = bindOperation.getSASLCredentials();
        if (saslCredentials != null && (credString = saslCredentials.stringValue()).length() > 0) {
            bindOperation.appendAdditionalLogMessage("trace='");
            bindOperation.appendAdditionalLogMessage(credString);
            bindOperation.appendAdditionalLogMessage("'");
            ErrorLogger.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.INFORMATIONAL, 1048741, bindOperation.getConnectionID(), bindOperation.getOperationID(), credString);
        }
        AuthenticationInfo authInfo = new AuthenticationInfo();
        bindOperation.setAuthenticationInfo(authInfo);
        bindOperation.setResultCode(ResultCode.SUCCESS);
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return false;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return false;
    }
}

