/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base64PasswordStorageScheme
extends PasswordStorageScheme<PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializePasswordStorageScheme(PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getStorageSchemeName() {
        return "BASE64";
    }

    @Override
    public ByteString encodePassword(ByteString plaintext) throws DirectoryException {
        return ByteStringFactory.create(Base64.encode(plaintext.value()));
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteString plaintext) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("BASE64");
        buffer.append('}');
        buffer.append(Base64.encode(plaintext.value()));
        return ByteStringFactory.create(buffer.toString());
    }

    @Override
    public boolean passwordMatches(ByteString plaintextPassword, ByteString storedPassword) {
        String userString = Base64.encode(plaintextPassword.value());
        String storedString = storedPassword.stringValue();
        return userString.equals(storedString);
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public ByteString getPlaintextValue(ByteString storedPassword) throws DirectoryException {
        try {
            return ByteStringFactory.create(Base64.decode(storedPassword.stringValue()));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245186;
            String message = MessageHandler.getMessage(msgID, storedPassword.stringValue(), String.valueOf(e));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID, e);
        }
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    @Override
    public ByteString encodeAuthPassword(ByteString plaintext) throws DirectoryException {
        int msgID = 1245514;
        String message = MessageHandler.getMessage(msgID, this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean authPasswordMatches(ByteString plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        int msgID = 1245514;
        String message = MessageHandler.getMessage(msgID, this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return false;
    }
}

