/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CramMD5SASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRAMMD5SASLMechanismHandler
extends SASLMechanismHandler<CramMD5SASLMechanismHandlerCfg>
implements ConfigurationChangeListener<CramMD5SASLMechanismHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private byte[] iPad;
    private byte[] oPad;
    private CramMD5SASLMechanismHandlerCfg currentConfig;
    private DN configEntryDN;
    private IdentityMapper identityMapper;
    private MessageDigest md5Digest;
    private ReentrantLock digestLock;
    private SecureRandom randomGenerator;

    @Override
    public void initializeSASLMechanismHandler(CramMD5SASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        configuration.addCramMD5ChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        this.digestLock = new ReentrantLock();
        this.randomGenerator = new SecureRandom();
        try {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1310886;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new InitializationException(msgID, message, e);
        }
        this.iPad = new byte[64];
        this.oPad = new byte[64];
        Arrays.fill(this.iPad, (byte)54);
        Arrays.fill(this.oPad, (byte)92);
        DN identityMapperDN = configuration.getIdentityMapperDN();
        this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (this.identityMapper == null) {
            int msgID = 1245495;
            String message = MessageHandler.getMessage(msgID, String.valueOf(identityMapperDN), String.valueOf(this.configEntryDN));
            throw new ConfigException(msgID, message);
        }
        DirectoryServer.registerSASLMechanismHandler("CRAM-MD5", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.currentConfig.removeCramMD5ChangeListener(this);
        DirectoryServer.deregisterSASLMechanismHandler("CRAM-MD5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSASLBind(BindOperation bindOperation) {
        List<ByteString> clearPasswords;
        byte[] digestBytes;
        ASN1OctetString clientCredentials = bindOperation.getSASLCredentials();
        ClientConnection clientConnection = bindOperation.getClientConnection();
        if (clientCredentials == null) {
            byte[] challengeBytes = new byte[16];
            this.randomGenerator.nextBytes(challengeBytes);
            StringBuilder challengeString = new StringBuilder(18);
            challengeString.append('<');
            for (byte b : challengeBytes) {
                challengeString.append(StaticUtils.byteToLowerHex(b));
            }
            challengeString.append('>');
            ASN1OctetString challenge = new ASN1OctetString(challengeString.toString());
            clientConnection.setSASLAuthStateInfo(challenge);
            bindOperation.setServerSASLCredentials(challenge);
            bindOperation.setResultCode(ResultCode.SASL_BIND_IN_PROGRESS);
            return;
        }
        Object saslStateInfo = clientConnection.getSASLAuthStateInfo();
        if (saslStateInfo == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245356;
            String message = MessageHandler.getMessage(msgID);
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        if (!(saslStateInfo instanceof ASN1OctetString)) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245357;
            String message = MessageHandler.getMessage(msgID);
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        ASN1OctetString challenge = (ASN1OctetString)saslStateInfo;
        clientConnection.setSASLAuthStateInfo(null);
        String credString = clientCredentials.stringValue();
        int spacePos = credString.lastIndexOf(32);
        if (spacePos < 0) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245358;
            String message = MessageHandler.getMessage(msgID);
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        String userName = credString.substring(0, spacePos);
        String digest = credString.substring(spacePos + 1);
        if (digest.length() != 32) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245359;
            String message = MessageHandler.getMessage(msgID, digest.length(), 32);
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        try {
            digestBytes = StaticUtils.hexStringToByteArray(digest);
        }
        catch (ParseException pe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, pe);
            }
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245360;
            String message = MessageHandler.getMessage(msgID, pe.getMessage());
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        Entry userEntry = null;
        String lowerUserName = StaticUtils.toLowerCase(userName);
        if (lowerUserName.startsWith("dn:")) {
            DN userDN;
            try {
                userDN = DN.decode(userName.substring(3));
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int msgID = 1245361;
                String message = MessageHandler.getMessage(msgID, userName, de.getErrorMessage());
                bindOperation.setAuthFailureReason(msgID, message);
                return;
            }
            if (userDN.isNullDN()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int msgID = 1245362;
                String message = MessageHandler.getMessage(msgID);
                bindOperation.setAuthFailureReason(msgID, message);
                return;
            }
            DN rootDN = DirectoryServer.getActualRootBindDN(userDN);
            if (rootDN != null) {
                userDN = rootDN;
            }
            Lock readLock = null;
            for (int i = 0; i < 3 && (readLock = LockManager.lockRead(userDN)) == null; ++i) {
            }
            if (readLock == null) {
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                int msgID = 1048755;
                String message = MessageHandler.getMessage(msgID, String.valueOf(userDN));
                bindOperation.setAuthFailureReason(msgID, message);
                return;
            }
            try {
                userEntry = DirectoryServer.getEntry(userDN);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int msgID = 1245364;
                String message = MessageHandler.getMessage(msgID, String.valueOf(userDN), de.getErrorMessage());
                bindOperation.setAuthFailureReason(msgID, message);
                return;
            }
            finally {
                LockManager.unlock(userDN, readLock);
            }
        }
        if (lowerUserName.startsWith("u:")) {
            userName = userName.substring(2);
        }
        try {
            userEntry = this.identityMapper.getEntryForID(userName);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245497;
            String message = MessageHandler.getMessage(msgID, String.valueOf(userName), de.getErrorMessage());
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        if (userEntry == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245368;
            String message = MessageHandler.getMessage(msgID, userName);
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        bindOperation.setSASLAuthUserEntry(userEntry);
        try {
            PasswordPolicyState pwPolicyState = new PasswordPolicyState(userEntry, false, false);
            clearPasswords = pwPolicyState.getClearPasswords();
            if (clearPasswords == null || clearPasswords.isEmpty()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int msgID = 1245373;
                String message = MessageHandler.getMessage(msgID, String.valueOf(userEntry.getDN()));
                bindOperation.setAuthFailureReason(msgID, message);
                return;
            }
        }
        catch (Exception e) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245561;
            String message = MessageHandler.getMessage(msgID, String.valueOf(userEntry.getDN()), String.valueOf(e));
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        boolean matchFound = false;
        for (ByteString clearPassword : clearPasswords) {
            byte[] generatedDigest = this.generateDigest(clearPassword, challenge);
            if (!Arrays.equals(digestBytes, generatedDigest)) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245372;
            String message = MessageHandler.getMessage(msgID);
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        bindOperation.setResultCode(ResultCode.SUCCESS);
        AuthenticationInfo authInfo = new AuthenticationInfo(userEntry, "CRAM-MD5", DirectoryServer.isRootDN(userEntry.getDN()));
        bindOperation.setAuthenticationInfo(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateDigest(ByteString password, ByteString challenge) {
        byte[] p = password.value();
        byte[] c = challenge.value();
        this.digestLock.lock();
        try {
            if (p.length > 64) {
                p = this.md5Digest.digest(p);
            }
            byte[] iPadAndData = new byte[64 + c.length];
            System.arraycopy(this.iPad, 0, iPadAndData, 0, 64);
            System.arraycopy(c, 0, iPadAndData, 64, c.length);
            byte[] oPadAndHash = new byte[80];
            System.arraycopy(this.oPad, 0, oPadAndHash, 0, 64);
            for (int i = 0; i < p.length; ++i) {
                int n = i;
                iPadAndData[n] = (byte)(iPadAndData[n] ^ p[i]);
                int n2 = i;
                oPadAndHash[n2] = (byte)(oPadAndHash[n2] ^ p[i]);
            }
            System.arraycopy(this.md5Digest.digest(iPadAndData), 0, oPadAndHash, 64, 16);
            byte[] byArray = this.md5Digest.digest(oPadAndHash);
            return byArray;
        }
        finally {
            this.digestLock.unlock();
        }
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return true;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        CramMD5SASLMechanismHandlerCfg config = (CramMD5SASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(CramMD5SASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        IdentityMapper newIdentityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (newIdentityMapper == null) {
            int msgID = 1245495;
            unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(identityMapperDN), String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(CramMD5SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        IdentityMapper newIdentityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        if (newIdentityMapper == null) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            int msgID = 1245495;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(identityMapperDN), String.valueOf(this.configEntryDN)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.identityMapper = newIdentityMapper;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

