/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.admin.std.server.ExtendedOperationHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelExtendedOperation
extends ExtendedOperationHandler<ExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeExtendedOperationHandler(ExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        DirectoryServer.registerSupportedExtension("1.3.6.1.1.8", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.1.8");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        int idToCancel;
        ASN1OctetString requestValue = operation.getRequestValue();
        if (requestValue == null) {
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
            int msgID = 1245511;
            operation.appendErrorMessage(MessageHandler.getMessage(msgID));
            return;
        }
        try {
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(requestValue.value());
            idToCancel = valueSequence.elements().get(0).decodeAsInteger().intValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
            int msgID = 1245512;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            operation.appendErrorMessage(message);
            return;
        }
        String cancelReason = MessageHandler.getMessage(1048905, operation.getMessageID());
        StringBuilder cancelResultMessage = new StringBuilder();
        CancelRequest cancelRequest = new CancelRequest(true, cancelReason, cancelResultMessage);
        ClientConnection clientConnection = operation.getClientConnection();
        CancelResult cancelResult = clientConnection.cancelOperation(idToCancel, cancelRequest);
        operation.setResultCode(cancelResult.getResultCode());
        operation.setErrorMessage(cancelResultMessage);
    }
}

