/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import org.opends.server.admin.Configuration;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.tools.LDIFModify;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.Modification;
import org.opends.server.types.Privilege;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFileHandler
extends ConfigHandler
implements AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.ConfigFileHandler";
    private static final Privilege[] CONFIG_READ_AND_WRITE = new Privilege[]{Privilege.CONFIG_READ, Privilege.CONFIG_WRITE};
    private byte[] configurationDigest;
    private ConcurrentHashMap<DN, ConfigEntry> configEntries;
    private ConfigEntry configRootEntry;
    private DN[] baseDNs;
    private ReentrantLock configLock;
    private String configFile;
    private String serverRoot;

    @Override
    public void initializeConfigHandler(String configFile, boolean checkSchema) throws InitializationException {
        String rootDirStr;
        String message;
        Entry entry;
        LDIFReader reader;
        this.configLock = new ReentrantLock();
        this.configFile = configFile;
        File f = new File(configFile);
        try {
            if (!f.exists()) {
                int msgID = 3473434;
                String message2 = MessageHandler.getMessage(msgID, configFile);
                throw new InitializationException(msgID, message2);
            }
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            throw ie;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3473435;
            String message3 = MessageHandler.getMessage(msgID, configFile, String.valueOf(e));
            throw new InitializationException(msgID, message3);
        }
        try {
            this.configurationDigest = this.calculateConfigDigest();
        }
        catch (DirectoryException de) {
            throw new InitializationException(de.getMessageID(), de.getErrorMessage(), de.getCause());
        }
        File archiveDirectory = new File(f.getParent(), "archived-configs");
        if (archiveDirectory.exists()) {
            try {
                byte[] lastDigest = this.getLastConfigDigest(archiveDirectory);
                if (!Arrays.equals(this.configurationDigest, lastDigest)) {
                    this.writeConfigArchive();
                }
            }
            catch (Exception e) {}
        } else {
            this.writeConfigArchive();
        }
        File changesFile = new File(f.getParent(), "config-changes.ldif");
        try {
            if (changesFile.exists()) {
                this.applyChangesFile(f, changesFile);
                this.configurationDigest = this.calculateConfigDigest();
                this.writeConfigArchive();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3473971;
            String message4 = MessageHandler.getMessage(msgID, changesFile.getAbsolutePath(), String.valueOf(e));
            throw new InitializationException(msgID, message4, e);
        }
        try {
            LDIFImportConfig importConfig = new LDIFImportConfig(configFile);
            reader = new LDIFReader(importConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3473436;
            String message5 = MessageHandler.getMessage(msgID, configFile, String.valueOf(e));
            throw new InitializationException(msgID, message5, e);
        }
        try {
            entry = reader.readEntry(checkSchema);
        }
        catch (LDIFException le) {
            block86: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, le);
                }
                try {
                    reader.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block86;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            int msgID = 3473439;
            String message6 = MessageHandler.getMessage(msgID, le.getLineNumber(), configFile, String.valueOf(le));
            throw new InitializationException(msgID, message6, le);
        }
        catch (Exception e) {
            block87: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                try {
                    reader.close();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) break block87;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
            int msgID = 3473437;
            String message7 = MessageHandler.getMessage(msgID, configFile, String.valueOf(e));
            throw new InitializationException(msgID, message7, e);
        }
        if (entry == null) {
            block88: {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block88;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            int msgID = 3473440;
            String message8 = MessageHandler.getMessage(msgID, configFile);
            throw new InitializationException(msgID, message8);
        }
        try {
            DN configRootDN = DN.decode("cn=config");
            if (!entry.getDN().equals(configRootDN)) {
                int msgID = 3473441;
                String message9 = MessageHandler.getMessage(msgID, configFile, entry.getDN().toString(), "cn=config");
                throw new InitializationException(msgID, message9);
            }
        }
        catch (InitializationException ie) {
            block89: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                }
                try {
                    reader.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block89;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            throw ie;
        }
        catch (Exception e) {
            block90: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                try {
                    reader.close();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) break block90;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
            int msgID = 3473442;
            String message10 = MessageHandler.getMessage(msgID, configFile, String.valueOf(e));
            throw new InitializationException(msgID, message10, e);
        }
        this.configEntries = new ConcurrentHashMap();
        this.configRootEntry = new ConfigEntry(entry, null);
        this.configEntries.put(entry.getDN(), this.configRootEntry);
        while (true) {
            String message11;
            try {
                entry = reader.readEntry(checkSchema);
            }
            catch (LDIFException le) {
                block91: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                    }
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block91;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                int msgID = 3473439;
                message11 = MessageHandler.getMessage(msgID, le.getLineNumber(), configFile, String.valueOf(le));
                throw new InitializationException(msgID, message11, le);
            }
            catch (Exception e) {
                block92: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    try {
                        reader.close();
                    }
                    catch (Exception e2) {
                        if (!DebugLogger.debugEnabled()) break block92;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                }
                int msgID = 3473437;
                message11 = MessageHandler.getMessage(msgID, configFile, String.valueOf(e));
                throw new InitializationException(msgID, message11, e);
            }
            if (entry == null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                break;
            }
            DN entryDN = entry.getDN();
            if (this.configEntries.containsKey(entryDN)) {
                block93: {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block93;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                int msgID = 3473443;
                message11 = MessageHandler.getMessage(msgID, entryDN.toString(), reader.getLastEntryLineNumber(), configFile);
                throw new InitializationException(msgID, message11);
            }
            DN parentDN = entryDN.getParent();
            if (parentDN == null) {
                block94: {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block94;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                int msgID = 3473445;
                message = MessageHandler.getMessage(msgID, entryDN.toString(), reader.getLastEntryLineNumber(), configFile);
                throw new InitializationException(msgID, message);
            }
            ConfigEntry parentEntry = this.configEntries.get(parentDN);
            if (parentEntry == null) {
                block95: {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block95;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                int msgID = 3473444;
                String message12 = MessageHandler.getMessage(msgID, entryDN.toString(), reader.getLastEntryLineNumber(), configFile, parentDN.toString());
                throw new InitializationException(msgID, message12);
            }
            try {
                ConfigEntry configEntry = new ConfigEntry(entry, parentEntry);
                parentEntry.addChild(configEntry);
                this.configEntries.put(entryDN, configEntry);
            }
            catch (Exception e) {
                block96: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    try {
                        reader.close();
                    }
                    catch (Exception e2) {
                        if (!DebugLogger.debugEnabled()) break block96;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                }
                int msgID = 3473442;
                String message13 = MessageHandler.getMessage(msgID, configFile, String.valueOf(e));
                throw new InitializationException(msgID, message13, e);
            }
        }
        if ((rootDirStr = System.getProperty("org.opends.server.ServerRoot")) == null) {
            rootDirStr = System.getenv("INSTANCE_ROOT");
        }
        if (rootDirStr != null) {
            try {
                File serverRootFile = new File(rootDirStr);
                this.serverRoot = serverRootFile.getAbsolutePath();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3473446;
                message = MessageHandler.getMessage(msgID, "INSTANCE_ROOT");
                throw new InitializationException(msgID, message);
            }
        }
        if (this.serverRoot == null) {
            try {
                File configDirFile = new File(configFile).getParentFile();
                if (configDirFile != null && configDirFile.getName().equals("config")) {
                    this.serverRoot = configDirFile.getParentFile().getAbsolutePath();
                }
                if (this.serverRoot == null) {
                    int msgID = 3473446;
                    message = MessageHandler.getMessage(msgID, "INSTANCE_ROOT");
                    throw new InitializationException(msgID, message);
                }
            }
            catch (InitializationException ie) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                }
                throw ie;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3473446;
                message = MessageHandler.getMessage(msgID, "INSTANCE_ROOT");
                throw new InitializationException(msgID, message);
            }
        }
        DirectoryServer.registerAlertGenerator(this);
        this.baseDNs = new DN[]{this.configRootEntry.getDN()};
        try {
            DirectoryServer.registerBaseDN(this.configRootEntry.getDN(), this, true, false);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3473511;
            message = MessageHandler.getMessage(msgID, this.configRootEntry.getDN(), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(msgID, message, e);
        }
    }

    private byte[] calculateConfigDigest() throws DirectoryException {
        InputStream inputStream = null;
        try {
            int bytesRead22;
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
            inputStream = new FileInputStream(this.configFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead22 = inputStream.read(buffer)) >= 0) {
                sha1Digest.update(buffer, 0, bytesRead22);
            }
            byte[] bytesRead22 = sha1Digest.digest();
            return bytesRead22;
        }
        catch (Exception e) {
            int msgID = 3474062;
            String message = MessageHandler.getMessage(msgID, this.configFile, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private byte[] getLastConfigDigest(File archiveDirectory) throws DirectoryException {
        int latestCounter = 0;
        long latestTimestamp = -1L;
        String latestFileName = null;
        for (String name : archiveDirectory.list()) {
            long timestamp;
            ASN1OctetString ts;
            int dotPos;
            if (!name.startsWith("config-") || (dotPos = name.indexOf(46, 7)) < 0) continue;
            int dashPos = name.indexOf(45, 7);
            if (dashPos < 0) {
                try {
                    ts = new ASN1OctetString(name.substring(7, dotPos));
                    timestamp = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(ts);
                    if (timestamp <= latestTimestamp) continue;
                    latestFileName = name;
                    latestTimestamp = timestamp;
                    latestCounter = 0;
                }
                catch (Exception e) {}
                continue;
            }
            try {
                ts = new ASN1OctetString(name.substring(7, dashPos));
                timestamp = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(ts);
                int counter = Integer.parseInt(name.substring(dashPos + 1, dotPos));
                if (timestamp > latestTimestamp) {
                    latestFileName = name;
                    latestTimestamp = timestamp;
                    latestCounter = counter;
                    continue;
                }
                if (timestamp != latestTimestamp || counter <= latestCounter) continue;
                latestFileName = name;
                latestTimestamp = timestamp;
                latestCounter = counter;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (latestFileName == null) {
            return null;
        }
        File latestFile = new File(archiveDirectory, latestFileName);
        try {
            int bytesRead;
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
            GZIPInputStream inputStream = new GZIPInputStream(new FileInputStream(latestFile));
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) >= 0) {
                sha1Digest.update(buffer, 0, bytesRead);
            }
            return sha1Digest.digest();
        }
        catch (Exception e) {
            int msgID = 3474062;
            String message = MessageHandler.getMessage(msgID, latestFile.getAbsolutePath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
    }

    private void applyChangesFile(File sourceFile, File changesFile) throws IOException, LDIFException {
        LDIFImportConfig importConfig = new LDIFImportConfig(sourceFile.getAbsolutePath());
        importConfig.setValidateSchema(false);
        LDIFReader sourceReader = new LDIFReader(importConfig);
        importConfig = new LDIFImportConfig(changesFile.getAbsolutePath());
        importConfig.setValidateSchema(false);
        LDIFReader changesReader = new LDIFReader(importConfig);
        String tempFile = changesFile.getAbsolutePath() + ".tmp";
        LDIFExportConfig exportConfig = new LDIFExportConfig(tempFile, ExistingFileBehavior.OVERWRITE);
        LDIFWriter targetWriter = new LDIFWriter(exportConfig);
        LinkedList<String> errorList = new LinkedList<String>();
        boolean successful = LDIFModify.modifyLDIF(sourceReader, changesReader, targetWriter, errorList);
        try {
            sourceReader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            changesReader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            targetWriter.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!successful) {
            for (String s : errorList) {
                int msgID = 3473972;
                String message = MessageHandler.getMessage(msgID, s);
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, msgID, message);
            }
            int msgID = 3473973;
            String message = MessageHandler.getMessage(msgID);
            throw new LDIFException(msgID, message);
        }
        File oldSource = new File(sourceFile.getAbsolutePath() + ".prechanges");
        if (oldSource.exists()) {
            oldSource.delete();
        }
        sourceFile.renameTo(oldSource);
        new File(tempFile).renameTo(sourceFile);
        File newChanges = new File(changesFile.getAbsolutePath() + ".applied");
        if (newChanges.exists()) {
            newChanges.delete();
        }
        changesFile.renameTo(newChanges);
    }

    @Override
    public void finalizeConfigHandler() {
        block2: {
            try {
                DirectoryServer.deregisterBaseDN(this.configRootEntry.getDN(), false);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public void finalizeBackend() {
    }

    @Override
    public ConfigEntry getConfigRootEntry() throws ConfigException {
        return this.configRootEntry;
    }

    @Override
    public ConfigEntry getConfigEntry(DN entryDN) throws ConfigException {
        return this.configEntries.get(entryDN);
    }

    @Override
    public String getServerRoot() {
        return this.serverRoot;
    }

    @Override
    public void configureBackend(Configuration cfg) throws ConfigException {
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        return this.configEntries.size();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        ConfigEntry configEntry = this.configEntries.get(entryDN);
        if (configEntry == null) {
            return null;
        }
        return configEntry.getEntry().duplicate(true);
    }

    @Override
    public boolean entryExists(DN entryDN) throws DirectoryException {
        return this.configEntries.containsKey(entryDN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        ClientConnection clientConnection;
        Entry e = entry.duplicate(false);
        if (addOperation != null && !(clientConnection = addOperation.getClientConnection()).hasAllPrivileges(CONFIG_READ_AND_WRITE, addOperation)) {
            int msgID = 3342934;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
        }
        this.configLock.lock();
        try {
            DN entryDN = e.getDN();
            if (this.configEntries.containsKey(entryDN)) {
                int msgID = 3342616;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            DN parentDN = entryDN.getParent();
            if (parentDN == null) {
                int msgID = 3342617;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
            }
            ConfigEntry parentEntry = this.configEntries.get(parentDN);
            if (parentEntry == null) {
                int msgID = 3342618;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(parentDN));
                DN matchedDN = null;
                for (parentDN = parentDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
                    if (!this.configEntries.containsKey(parentDN)) continue;
                    matchedDN = parentDN;
                    break;
                }
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, matchedDN, null);
            }
            ConfigEntry newEntry = new ConfigEntry(e, parentEntry);
            CopyOnWriteArrayList<ConfigAddListener> addListeners = parentEntry.getAddListeners();
            StringBuilder unacceptableReason = new StringBuilder();
            for (ConfigAddListener l : addListeners) {
                if (l.configAddIsAcceptable(newEntry, unacceptableReason)) continue;
                int msgID = 3342619;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(parentDN), String.valueOf(unacceptableReason));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            try {
                parentEntry.addChild(newEntry);
                this.configEntries.put(entryDN, newEntry);
                this.writeUpdatedConfig();
            }
            catch (ConfigException ce) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ce);
                }
                int msgID = 3342620;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(parentDN), StaticUtils.getExceptionMessage(ce));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
            }
            ResultCode resultCode = ResultCode.SUCCESS;
            LinkedList<String> messages = new LinkedList<String>();
            for (ConfigAddListener l : addListeners) {
                ConfigChangeResult result = l.applyConfigurationAdd(newEntry);
                if (result.getResultCode() != ResultCode.SUCCESS) {
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = result.getResultCode();
                    }
                    messages.addAll(result.getMessages());
                }
                this.handleConfigChangeResult(result, newEntry.getDN(), l.getClass().getName(), "applyConfigurationAdd");
            }
            if (resultCode != ResultCode.SUCCESS) {
                StringBuilder buffer = new StringBuilder();
                if (!messages.isEmpty()) {
                    Iterator iterator = messages.iterator();
                    buffer.append((String)iterator.next());
                    while (iterator.hasNext()) {
                        buffer.append(".  ");
                        buffer.append((String)iterator.next());
                    }
                }
                int msgID = 3408548;
                String message = MessageHandler.getMessage(msgID, String.valueOf(buffer));
                throw new DirectoryException(resultCode, message, msgID);
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        ClientConnection clientConnection;
        if (deleteOperation != null && !(clientConnection = deleteOperation.getClientConnection()).hasAllPrivileges(CONFIG_READ_AND_WRITE, deleteOperation)) {
            int msgID = 3342935;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
        }
        this.configLock.lock();
        try {
            ConfigEntry entry = this.configEntries.get(entryDN);
            if (entry == null) {
                DN matchedDN = null;
                if (entryDN.isDescendantOf(this.configRootEntry.getDN())) {
                    for (DN parentDN = entryDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
                        if (!this.configEntries.containsKey(parentDN)) continue;
                        matchedDN = parentDN;
                        break;
                    }
                }
                int msgID = 3342621;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, matchedDN, null);
            }
            if (entry.hasChildren()) {
                int msgID = 3342622;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, message, msgID);
            }
            ConfigEntry parentEntry = entry.getParent();
            if (parentEntry == null) {
                int msgID = 3342623;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            CopyOnWriteArrayList<ConfigDeleteListener> deleteListeners = parentEntry.getDeleteListeners();
            StringBuilder unacceptableReason = new StringBuilder();
            for (ConfigDeleteListener l : deleteListeners) {
                if (l.configDeleteIsAcceptable(entry, unacceptableReason)) continue;
                int msgID = 3342624;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(parentEntry.getDN()), String.valueOf(unacceptableReason));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            try {
                parentEntry.removeChild(entryDN);
                this.configEntries.remove(entryDN);
                this.writeUpdatedConfig();
            }
            catch (ConfigException ce) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ce);
                }
                int msgID = 3342625;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(parentEntry.getDN()), StaticUtils.getExceptionMessage(ce));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
            }
            ResultCode resultCode = ResultCode.SUCCESS;
            LinkedList<String> messages = new LinkedList<String>();
            for (ConfigDeleteListener l : deleteListeners) {
                ConfigChangeResult result = l.applyConfigurationDelete(entry);
                if (result.getResultCode() != ResultCode.SUCCESS) {
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = result.getResultCode();
                    }
                    messages.addAll(result.getMessages());
                }
                this.handleConfigChangeResult(result, entry.getDN(), l.getClass().getName(), "applyConfigurationDelete");
            }
            if (resultCode != ResultCode.SUCCESS) {
                StringBuilder buffer = new StringBuilder();
                if (!messages.isEmpty()) {
                    Iterator iterator = messages.iterator();
                    buffer.append((String)iterator.next());
                    while (iterator.hasNext()) {
                        buffer.append(".  ");
                        buffer.append((String)iterator.next());
                    }
                }
                int msgID = 3408549;
                String message = MessageHandler.getMessage(msgID, String.valueOf(buffer));
                throw new DirectoryException(resultCode, message, msgID);
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        Entry e = entry.duplicate(false);
        if (modifyOperation != null) {
            ClientConnection clientConnection = modifyOperation.getClientConnection();
            if (!clientConnection.hasAllPrivileges(CONFIG_READ_AND_WRITE, modifyOperation)) {
                int msgID = 3342936;
                String message = MessageHandler.getMessage(msgID);
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
            }
            AttributeType privType = DirectoryServer.getAttributeType("ds-cfg-default-root-privilege-name", true);
            for (Modification m : modifyOperation.getModifications()) {
                if (!m.getAttribute().getAttributeType().equals(privType)) continue;
                if (clientConnection.hasPrivilege(Privilege.PRIVILEGE_CHANGE, modifyOperation)) break;
                int msgID = 3342939;
                String message = MessageHandler.getMessage(msgID);
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
            }
        }
        this.configLock.lock();
        try {
            DN entryDN = e.getDN();
            ConfigEntry currentEntry = this.configEntries.get(entryDN);
            if (currentEntry == null) {
                DN matchedDN = null;
                if (entryDN.isDescendantOf(this.configRootEntry.getDN())) {
                    for (DN parentDN = entryDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
                        if (!this.configEntries.containsKey(parentDN)) continue;
                        matchedDN = parentDN;
                        break;
                    }
                }
                int msgID = 3342626;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, matchedDN, null);
            }
            if (!currentEntry.getEntry().getStructuralObjectClass().equals(entry.getStructuralObjectClass())) {
                int msgID = 3342989;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
            }
            ConfigEntry newEntry = new ConfigEntry(e, currentEntry.getParent());
            CopyOnWriteArrayList<ConfigChangeListener> changeListeners = currentEntry.getChangeListeners();
            StringBuilder unacceptableReason = new StringBuilder();
            for (ConfigChangeListener l : changeListeners) {
                if (l.configChangeIsAcceptable(newEntry, unacceptableReason)) continue;
                int msgID = 3342627;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(unacceptableReason));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            currentEntry.setEntry(e);
            this.writeUpdatedConfig();
            ResultCode resultCode = ResultCode.SUCCESS;
            LinkedList<String> messages = new LinkedList<String>();
            for (ConfigChangeListener l : changeListeners) {
                ConfigChangeResult result = l.applyConfigurationChange(newEntry);
                if (result.getResultCode() != ResultCode.SUCCESS) {
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = result.getResultCode();
                    }
                    messages.addAll(result.getMessages());
                }
                this.handleConfigChangeResult(result, newEntry.getDN(), l.getClass().getName(), "applyConfigurationChange");
            }
            if (resultCode != ResultCode.SUCCESS) {
                StringBuilder buffer = new StringBuilder();
                if (!messages.isEmpty()) {
                    Iterator iterator = messages.iterator();
                    buffer.append((String)iterator.next());
                    while (iterator.hasNext()) {
                        buffer.append(".  ");
                        buffer.append((String)iterator.next());
                    }
                }
                int msgID = 3408550;
                String message = MessageHandler.getMessage(msgID, String.valueOf(buffer));
                throw new DirectoryException(resultCode, message, msgID);
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        ClientConnection clientConnection;
        if (modifyDNOperation != null && !(clientConnection = modifyDNOperation.getClientConnection()).hasAllPrivileges(CONFIG_READ_AND_WRITE, modifyDNOperation)) {
            int msgID = 3342937;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
        }
        int msgID = 3342638;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        ClientConnection clientConnection = searchOperation.getClientConnection();
        if (!clientConnection.hasPrivilege(Privilege.CONFIG_READ, searchOperation)) {
            int msgID = 3342938;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
        }
        DN baseDN = searchOperation.getBaseDN();
        ConfigEntry baseEntry = this.configEntries.get(baseDN);
        if (baseEntry == null) {
            int msgID = 3342629;
            String message = MessageHandler.getMessage(msgID, String.valueOf(baseDN));
            DN matchedDN = null;
            if (baseDN.isDescendantOf(this.configRootEntry.getDN())) {
                for (DN parentDN = baseDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
                    if (!this.configEntries.containsKey(parentDN)) continue;
                    matchedDN = parentDN;
                    break;
                }
            }
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, matchedDN, null);
        }
        SearchScope scope = searchOperation.getScope();
        SearchFilter filter = searchOperation.getFilter();
        switch (scope) {
            case BASE_OBJECT: {
                Entry e = baseEntry.getEntry().duplicate(true);
                if (!filter.matchesEntry(e)) break;
                searchOperation.returnEntry(e, null);
                break;
            }
            case SINGLE_LEVEL: {
                ConfigEntry child;
                Entry e;
                Iterator<ConfigEntry> i$ = baseEntry.getChildren().values().iterator();
                while (i$.hasNext() && (!filter.matchesEntry(e = (child = i$.next()).getEntry().duplicate(true)) || searchOperation.returnEntry(e, null))) {
                }
                break;
            }
            case WHOLE_SUBTREE: {
                this.searchSubtree(baseEntry, filter, searchOperation);
                break;
            }
            case SUBORDINATE_SUBTREE: {
                for (ConfigEntry child : baseEntry.getChildren().values()) {
                    if (!this.searchSubtree(child, filter, searchOperation)) break;
                }
                break;
            }
            default: {
                int msgID = 3342630;
                String message = MessageHandler.getMessage(msgID, String.valueOf((Object)scope));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
            }
        }
    }

    private boolean searchSubtree(ConfigEntry baseEntry, SearchFilter filter, SearchOperation searchOperation) throws DirectoryException {
        Entry e = baseEntry.getEntry().duplicate(true);
        if (filter.matchesEntry(e) && !searchOperation.returnEntry(e, null)) {
            return false;
        }
        for (ConfigEntry child : baseEntry.getChildren().values()) {
            if (this.searchSubtree(child, filter, searchOperation)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeUpdatedConfig() throws DirectoryException {
        try {
            byte[] currentDigest = this.calculateConfigDigest();
            if (!Arrays.equals(this.configurationDigest, currentDigest)) {
                int bytesRead;
                File existingCfg = new File(this.configFile);
                File newConfigFile = new File(existingCfg.getParent(), "config.manualedit-" + TimeThread.getGMTTime() + ".ldif");
                int counter = 2;
                while (newConfigFile.exists()) {
                    newConfigFile = new File(newConfigFile.getAbsolutePath() + "." + counter++);
                }
                FileInputStream inputStream = new FileInputStream(existingCfg);
                FileOutputStream outputStream = new FileOutputStream(newConfigFile);
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                inputStream.close();
                outputStream.close();
                int msgID = 3277455;
                String message = MessageHandler.getMessage(msgID, this.configFile, newConfigFile.getAbsolutePath());
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.ManualConfigEditHandled", msgID, message);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3408528;
            String message = MessageHandler.getMessage(msgID, this.configFile, StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.ManualConfigEditHandled", msgID, message);
        }
        String tempConfig = this.configFile + ".tmp";
        try {
            LDIFExportConfig exportConfig = new LDIFExportConfig(tempConfig, ExistingFileBehavior.OVERWRITE);
            this.writeLDIF(exportConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3342636;
            String message = MessageHandler.getMessage(msgID, String.valueOf(tempConfig), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", msgID, message);
            return;
        }
        try {
            File actualConfig = new File(this.configFile);
            File tmpConfig = new File(tempConfig);
            StaticUtils.renameFile(tmpConfig, actualConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3342637;
            String message = MessageHandler.getMessage(msgID, String.valueOf(tempConfig), String.valueOf(this.configFile), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", msgID, message);
            return;
        }
        this.configurationDigest = this.calculateConfigDigest();
        this.writeConfigArchive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigArchive() {
        File archiveFile;
        File configDirectory = new File(this.configFile).getParentFile();
        File archiveDirectory = new File(configDirectory, "archived-configs");
        if (!archiveDirectory.exists()) {
            try {
                if (!archiveDirectory.mkdirs()) {
                    int msgID = 3408445;
                    String message = MessageHandler.getMessage(msgID, archiveDirectory.getAbsolutePath());
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", msgID, message);
                    return;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3408446;
                String message = MessageHandler.getMessage(msgID, archiveDirectory.getAbsolutePath(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", msgID, message);
                return;
            }
        }
        try {
            String timestamp = TimeThread.getGMTTime();
            archiveFile = new File(archiveDirectory, "config-" + timestamp + ".gz");
            if (archiveFile.exists()) {
                int counter = 2;
                archiveFile = new File(archiveDirectory, "config-" + timestamp + "-" + counter + ".gz");
                while (archiveFile.exists()) {
                    archiveFile = new File(archiveDirectory, "config-" + timestamp + "-" + ++counter + ".gz");
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3408447;
            String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", msgID, message);
            return;
        }
        byte[] buffer = new byte[8192];
        FileInputStream inputStream = null;
        DeflaterOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(this.configFile);
            outputStream = new GZIPOutputStream(new FileOutputStream(archiveFile));
            int bytesRead = inputStream.read(buffer);
            while (bytesRead > 0) {
                ((GZIPOutputStream)outputStream).write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3408447;
            String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", msgID, message);
            return;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {}
            try {
                outputStream.close();
            }
            catch (Exception e) {}
        }
    }

    public HashSet<String> getSupportedControls() {
        return null;
    }

    public HashSet<String> getSupportedFeatures() {
        return null;
    }

    @Override
    public boolean supportsLDIFExport() {
        return false;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        this.writeLDIF(exportConfig);
    }

    private void writeLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        LDIFWriter writer;
        try {
            writer = new LDIFWriter(exportConfig);
            writer.writeComment(MessageHandler.getMessage(3146152), 80);
            this.writeEntryAndChildren(writer, this.configRootEntry);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407956;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407912;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
    }

    private void writeEntryAndChildren(LDIFWriter writer, ConfigEntry configEntry) throws DirectoryException {
        try {
            writer.writeEntry(configEntry.getEntry());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407911;
            String message = MessageHandler.getMessage(msgID, configEntry.getDN().toString(), String.valueOf(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        TreeMap<DN, ConfigEntry> childMap = new TreeMap<DN, ConfigEntry>(configEntry.getChildren());
        for (ConfigEntry childEntry : childMap.values()) {
            this.writeEntryAndChildren(writer, childEntry);
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        int msgID = 3407913;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean supportsBackup() {
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return true;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        OutputStream outputStream;
        String backupID = backupConfig.getBackupID();
        BackupDirectory backupDirectory = backupConfig.getBackupDirectory();
        boolean compress = backupConfig.compressData();
        boolean encrypt = backupConfig.encryptData();
        boolean hash = backupConfig.hashData();
        boolean signHash = backupConfig.signHash();
        HashMap<String, String> backupProperties = new HashMap<String, String>();
        CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
        Mac mac = null;
        MessageDigest digest = null;
        String digestAlgorithm = null;
        String macAlgorithm = null;
        if (hash) {
            if (signHash) {
                macAlgorithm = cryptoManager.getPreferredMACAlgorithm();
                backupProperties.put("mac_algorithm", macAlgorithm);
                try {
                    mac = cryptoManager.getPreferredMACProvider();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    int msgID = 3408258;
                    String message = MessageHandler.getMessage(msgID, macAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
                }
            }
            digestAlgorithm = cryptoManager.getPreferredMessageDigestAlgorithm();
            backupProperties.put("digest_algorithm", digestAlgorithm);
            try {
                digest = cryptoManager.getPreferredMessageDigest();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3408259;
                String message = MessageHandler.getMessage(msgID, digestAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
            }
        }
        String filename = null;
        try {
            filename = "config-backup-" + backupID;
            File archiveFile = new File(backupDirectory.getPath() + File.separator + filename);
            if (archiveFile.exists()) {
                int i = 1;
                while ((archiveFile = new File(backupDirectory.getPath() + File.separator + filename + "." + i)).exists()) {
                    ++i;
                }
                filename = filename + "." + i;
            }
            outputStream = new FileOutputStream(archiveFile, false);
            backupProperties.put("archive_file", filename);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3408260;
            String message = MessageHandler.getMessage(msgID, String.valueOf(filename), backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        if (encrypt) {
            Cipher cipher;
            String cipherAlgorithm = cryptoManager.getPreferredCipherAlgorithm();
            backupProperties.put("cipher_algorithm", cipherAlgorithm);
            try {
                cipher = cryptoManager.getPreferredCipher(1);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3408261;
                String message = MessageHandler.getMessage(msgID, cipherAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
            }
            outputStream = new CipherOutputStream(outputStream, cipher);
        }
        ZipOutputStream zipStream = new ZipOutputStream(outputStream);
        int msgID = 3408262;
        String message = MessageHandler.getMessage(msgID, "OpenDS Directory Server", backupID);
        zipStream.setComment(message);
        if (compress) {
            zipStream.setLevel(-1);
        } else {
            zipStream.setLevel(0);
        }
        String configFile = null;
        try {
            configFile = ((ConfigFileHandler)DirectoryServer.getConfigHandler()).configFile;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            msgID = 3408263;
            message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        byte[] buffer = new byte[8192];
        FileInputStream inputStream = null;
        try {
            int bytesRead;
            File f = new File(configFile);
            ZipEntry zipEntry = new ZipEntry(f.getName());
            zipStream.putNextEntry(zipEntry);
            inputStream = new FileInputStream(f);
            while ((bytesRead = inputStream.read(buffer)) >= 0) {
                if (hash) {
                    if (signHash) {
                        mac.update(buffer, 0, bytesRead);
                    } else {
                        digest.update(buffer, 0, bytesRead);
                    }
                }
                zipStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            zipStream.closeEntry();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            try {
                inputStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                zipStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            msgID = 3408264;
            message = MessageHandler.getMessage(msgID, configFile, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        try {
            File archiveDirectory = new File(new File(configFile).getParent(), "archived-configs");
            if (archiveDirectory.exists()) {
                for (File archiveFile : archiveDirectory.listFiles()) {
                    int bytesRead;
                    ZipEntry zipEntry = new ZipEntry("archived-configs" + File.separator + archiveFile.getName());
                    zipStream.putNextEntry(zipEntry);
                    inputStream = new FileInputStream(archiveFile);
                    while ((bytesRead = inputStream.read(buffer)) >= 0) {
                        if (hash) {
                            if (signHash) {
                                mac.update(buffer, 0, bytesRead);
                            } else {
                                digest.update(buffer, 0, bytesRead);
                            }
                        }
                        zipStream.write(buffer, 0, bytesRead);
                    }
                    inputStream.close();
                    zipStream.closeEntry();
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            try {
                inputStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                zipStream.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            msgID = 3408265;
            message = MessageHandler.getMessage(msgID, configFile, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        try {
            zipStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            msgID = 3408266;
            message = MessageHandler.getMessage(msgID, filename, backupDirectory.getPath(), StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        byte[] digestBytes = null;
        byte[] macBytes = null;
        if (hash) {
            if (signHash) {
                macBytes = mac.doFinal();
            } else {
                digestBytes = digest.digest();
            }
        }
        BackupInfo backupInfo = new BackupInfo(backupDirectory, backupID, new Date(), false, compress, encrypt, digestBytes, macBytes, null, backupProperties);
        try {
            backupDirectory.addBackup(backupInfo);
            backupDirectory.writeBackupDirectoryDescriptor();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            msgID = 3408267;
            message = MessageHandler.getMessage(msgID, backupDirectory.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
    }

    @Override
    public boolean supportsRestore() {
        return true;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        String message;
        InputStream inputStream;
        BackupDirectory backupDirectory = restoreConfig.getBackupDirectory();
        String backupPath = backupDirectory.getPath();
        String backupID = restoreConfig.getBackupID();
        BackupInfo backupInfo = backupDirectory.getBackupInfo(backupID);
        if (backupInfo == null) {
            int msgID = 3408268;
            String message2 = MessageHandler.getMessage(msgID, backupID, backupPath);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message2, msgID);
        }
        String backupFilename = backupInfo.getBackupProperty("archive_file");
        if (backupFilename == null) {
            int msgID = 3408269;
            String message3 = MessageHandler.getMessage(msgID, backupID, backupPath);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message3, msgID);
        }
        File backupFile = new File(backupPath + File.separator + backupFilename);
        try {
            if (!backupFile.exists()) {
                int msgID = 3408270;
                String message4 = MessageHandler.getMessage(msgID, backupID, backupFile.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message4, msgID);
            }
        }
        catch (DirectoryException de) {
            throw de;
        }
        catch (Exception e) {
            int msgID = 3408271;
            String message5 = MessageHandler.getMessage(msgID, backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message5, msgID, e);
        }
        byte[] unsignedHash = backupInfo.getUnsignedHash();
        MessageDigest digest = null;
        if (unsignedHash != null) {
            String digestAlgorithm = backupInfo.getBackupProperty("digest_algorithm");
            if (digestAlgorithm == null) {
                int msgID = 3408272;
                String message6 = MessageHandler.getMessage(msgID, backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message6, msgID);
            }
            try {
                digest = DirectoryServer.getCryptoManager().getMessageDigest(digestAlgorithm);
            }
            catch (Exception e) {
                int msgID = 3408273;
                String message7 = MessageHandler.getMessage(msgID, backupID, digestAlgorithm);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message7, msgID, e);
            }
        }
        byte[] signedHash = backupInfo.getSignedHash();
        Mac mac = null;
        if (signedHash != null) {
            String macAlgorithm = backupInfo.getBackupProperty("mac_algorithm");
            if (macAlgorithm == null) {
                int msgID = 3408274;
                String message8 = MessageHandler.getMessage(msgID, backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message8, msgID);
            }
            try {
                mac = DirectoryServer.getCryptoManager().getMACProvider(macAlgorithm);
            }
            catch (Exception e) {
                int msgID = 3408275;
                String message9 = MessageHandler.getMessage(msgID, backupID, macAlgorithm, backupFile.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message9, msgID, e);
            }
        }
        try {
            inputStream = new FileInputStream(backupFile);
        }
        catch (Exception e) {
            int msgID = 3408276;
            String message10 = MessageHandler.getMessage(msgID, backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message10, msgID, e);
        }
        if (backupInfo.isEncrypted()) {
            Cipher cipher;
            String cipherAlgorithm = backupInfo.getBackupProperty("cipher_algorithm");
            if (cipherAlgorithm == null) {
                int msgID = 3408277;
                String message11 = MessageHandler.getMessage(msgID, backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message11, msgID);
            }
            try {
                cipher = DirectoryServer.getCryptoManager().getCipher(cipherAlgorithm, 2);
            }
            catch (Exception e) {
                int msgID = 3408278;
                String message12 = MessageHandler.getMessage(msgID, cipherAlgorithm, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message12, msgID, e);
            }
            inputStream = new CipherInputStream(inputStream, cipher);
        }
        ZipInputStream zipStream = new ZipInputStream(inputStream);
        String configFilePath = ((ConfigFileHandler)DirectoryServer.getConfigHandler()).configFile;
        File configFile = new File(configFilePath);
        File configDir = configFile.getParentFile();
        String configDirPath = configDir.getPath();
        String backupDirPath = null;
        File configBackupDir = null;
        boolean verifyOnly = restoreConfig.verifyOnly();
        if (!verifyOnly) {
            try {
                if (configDir.exists()) {
                    String configBackupDirPath = configDirPath + ".save";
                    backupDirPath = configBackupDirPath;
                    configBackupDir = new File(backupDirPath);
                    if (configBackupDir.exists()) {
                        int i = 2;
                        while ((configBackupDir = new File(backupDirPath = configBackupDirPath + i)).exists()) {
                            ++i;
                        }
                    }
                    configBackupDir.mkdirs();
                    StaticUtils.moveFile(configFile, configBackupDir);
                    File archiveDirectory = new File(configDir, "archived-configs");
                    if (archiveDirectory.exists()) {
                        File archiveBackupPath = new File(configBackupDir, "archived-configs");
                        archiveDirectory.renameTo(archiveBackupPath);
                    }
                }
            }
            catch (Exception e) {
                int msgID = 3408279;
                String message13 = MessageHandler.getMessage(msgID, backupID, configDirPath, String.valueOf(backupDirPath), StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message13, msgID, e);
            }
            try {
                configDir.mkdirs();
            }
            catch (Exception e) {
                if (configBackupDir != null) {
                    try {
                        configBackupDir.renameTo(configDir);
                        int msgID = 3604888;
                        String message14 = MessageHandler.getMessage(msgID, configDirPath);
                        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message14, msgID);
                    }
                    catch (Exception e2) {
                        int msgID = 3408281;
                        String message15 = MessageHandler.getMessage(msgID, configBackupDir.getPath());
                        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message15, msgID);
                    }
                }
                int msgID = 3408282;
                String message16 = MessageHandler.getMessage(msgID, backupID, configDirPath, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message16, msgID, e);
            }
        }
        byte[] buffer = new byte[8192];
        while (true) {
            ZipEntry zipEntry;
            try {
                zipEntry = zipStream.getNextEntry();
            }
            catch (Exception e) {
                String message17;
                if (configBackupDir != null) {
                    int msgID = 3408283;
                    message17 = MessageHandler.getMessage(msgID, configBackupDir.getPath());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message17, msgID);
                }
                int msgID = 3408284;
                message17 = MessageHandler.getMessage(msgID, backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message17, msgID, e);
            }
            if (zipEntry == null) break;
            String fileName = zipEntry.getName();
            if (digest != null) {
                digest.update(StaticUtils.getBytes(fileName));
            }
            if (mac != null) {
                mac.update(StaticUtils.getBytes(fileName));
            }
            OutputStream outputStream = null;
            if (!verifyOnly) {
                File restoreFile = new File(configDirPath + File.separator + fileName);
                File parentDir = restoreFile.getParentFile();
                try {
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    outputStream = new FileOutputStream(restoreFile);
                }
                catch (Exception e) {
                    String message18;
                    int msgID;
                    if (configBackupDir != null) {
                        msgID = 3408283;
                        message18 = MessageHandler.getMessage(msgID, configBackupDir.getPath());
                        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message18, msgID);
                    }
                    msgID = 3408285;
                    message18 = MessageHandler.getMessage(msgID, backupID, restoreFile.getAbsolutePath(), StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message18, msgID, e);
                }
            }
            try {
                int bytesRead;
                while ((bytesRead = zipStream.read(buffer)) >= 0) {
                    if (digest != null) {
                        digest.update(buffer, 0, bytesRead);
                    }
                    if (mac != null) {
                        mac.update(buffer, 0, bytesRead);
                    }
                    if (outputStream == null) continue;
                    outputStream.write(buffer, 0, bytesRead);
                }
                if (outputStream == null) continue;
                outputStream.close();
            }
            catch (Exception e) {
                String message19;
                if (configBackupDir != null) {
                    int msgID = 3408283;
                    message19 = MessageHandler.getMessage(msgID, configBackupDir.getPath());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message19, msgID);
                }
                int msgID = 3408286;
                message19 = MessageHandler.getMessage(msgID, backupID, fileName, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message19, msgID, e);
            }
        }
        try {
            zipStream.close();
        }
        catch (Exception e) {
            int msgID = 3408287;
            message = MessageHandler.getMessage(msgID, backupID, backupFile.getPath(), StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        if (digest != null) {
            byte[] calculatedHash = digest.digest();
            if (Arrays.equals(calculatedHash, unsignedHash)) {
                int msgID = 3604896;
                message = MessageHandler.getMessage(msgID);
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
            } else {
                if (configBackupDir != null) {
                    int msgID = 3408283;
                    message = MessageHandler.getMessage(msgID, configBackupDir.getPath());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
                }
                int msgID = 3408289;
                message = MessageHandler.getMessage(msgID, backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
            }
        }
        if (mac != null) {
            byte[] calculatedSignature = mac.doFinal();
            if (Arrays.equals(calculatedSignature, signedHash)) {
                int msgID = 3604898;
                message = MessageHandler.getMessage(msgID);
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
            } else {
                if (configBackupDir != null) {
                    int msgID = 3408283;
                    message = MessageHandler.getMessage(msgID, configBackupDir.getPath());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
                }
                int msgID = 3408291;
                message = MessageHandler.getMessage(msgID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
            }
        }
        if (verifyOnly) {
            int msgID = 3604900;
            String message20 = MessageHandler.getMessage(msgID, backupID, backupPath);
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message20, msgID);
            return;
        }
        if (configBackupDir != null) {
            StaticUtils.recursiveDelete(configBackupDir);
        }
        int msgID = 3604901;
        String message21 = MessageHandler.getMessage(msgID, backupID, backupPath);
        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message21, msgID);
    }

    @Override
    public DN getComponentEntryDN() {
        return this.configRootEntry.getDN();
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.CannotWriteConfig", "This alert type will be used to notify administrators if the Directory Server is unable to write its updated configuration for some reason and therefore the server may not exhibit the new configuration if it is restarted.");
        alerts.put("org.opends.server.ManualConfigEditHandled", "This alert type will be used to notify administrators if the Directory Server detects that its configuration has been manually edited with the server online and those changes were overwritten by another change made through the server.  The manually-edited configuration will be copied off to another location.");
        alerts.put("org.opends.server.ManualConfigEditLost", "This alert type will be used to notify administrators if the Directory Server detects that its configuration has been manually edited with the server online and those changes were overwritten by another change made through the server.  The manually-edited configuration could not be preserved due to an unexpected error.");
        return alerts;
    }

    public void handleConfigChangeResult(ConfigChangeResult result, DN entryDN, String className, String methodName) {
        String message;
        if (result == null) {
            int msgID = 3408517;
            String message2 = MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(methodName), String.valueOf(entryDN));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
            return;
        }
        ResultCode resultCode = result.getResultCode();
        boolean adminActionRequired = result.adminActionRequired();
        List<String> messages = result.getMessages();
        StringBuilder messageBuffer = new StringBuilder();
        if (messages != null) {
            for (String s : messages) {
                if (messageBuffer.length() > 0) {
                    messageBuffer.append("  ");
                }
                messageBuffer.append(s);
            }
        }
        if (resultCode != ResultCode.SUCCESS) {
            int msgID = 3408518;
            message = MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(methodName), String.valueOf(entryDN), String.valueOf((Object)resultCode), adminActionRequired, messageBuffer.toString());
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
        } else if (adminActionRequired) {
            int msgID = 3277447;
            message = MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(methodName), String.valueOf(entryDN), messageBuffer.toString());
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
        } else if (messageBuffer.length() > 0) {
            int msgID = 3146376;
            message = MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(methodName), String.valueOf(entryDN), messageBuffer.toString());
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.INFORMATIONAL, message, msgID);
        }
    }
}

