/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.DictionaryPasswordValidatorCfg;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryPasswordValidator
extends PasswordValidator<DictionaryPasswordValidatorCfg>
implements ConfigurationChangeListener<DictionaryPasswordValidatorCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DictionaryPasswordValidatorCfg currentConfig;
    private HashSet<String> dictionary;

    @Override
    public void initializePasswordValidator(DictionaryPasswordValidatorCfg configuration) throws ConfigException, InitializationException {
        configuration.addDictionaryChangeListener(this);
        this.currentConfig = configuration;
        this.dictionary = this.loadDictionary(configuration);
    }

    @Override
    public void finalizePasswordValidator() {
        this.currentConfig.removeDictionaryChangeListener(this);
    }

    @Override
    public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, StringBuilder invalidReason) {
        DictionaryPasswordValidatorCfg config = this.currentConfig;
        HashSet<String> dictionary = this.dictionary;
        String password = newPassword.stringValue();
        if (!config.isCaseSensitiveValidation()) {
            password = StaticUtils.toLowerCase(password);
        }
        if (dictionary.contains(password)) {
            int msgID = 1245644;
            invalidReason.append(MessageHandler.getMessage(msgID));
            return false;
        }
        if (config.isTestReversedPassword() && dictionary.contains(new StringBuilder(password).reverse().toString())) {
            int msgID = 1245644;
            invalidReason.append(MessageHandler.getMessage(msgID));
            return false;
        }
        return true;
    }

    private HashSet<String> loadDictionary(DictionaryPasswordValidatorCfg configuration) throws ConfigException, InitializationException {
        File dictionaryFile = StaticUtils.getFileForPath(configuration.getDictionaryFile());
        if (!dictionaryFile.exists()) {
            int msgID = 1245645;
            String message = MessageHandler.getMessage(msgID, configuration.getDictionaryFile());
            throw new ConfigException(msgID, message);
        }
        BufferedReader reader = null;
        HashSet<String> dictionary = new HashSet<String>();
        try {
            reader = new BufferedReader(new FileReader(dictionaryFile));
            String line = reader.readLine();
            while (line != null) {
                if (!configuration.isCaseSensitiveValidation()) {
                    line = line.toLowerCase();
                }
                dictionary.add(line);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245646;
            String message = MessageHandler.getMessage(msgID, configuration.getDictionaryFile(), String.valueOf(e));
            throw new InitializationException(msgID, message);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return dictionary;
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordValidatorCfg configuration, List<String> unacceptableReasons) {
        DictionaryPasswordValidatorCfg config = (DictionaryPasswordValidatorCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(DictionaryPasswordValidatorCfg configuration, List<String> unacceptableReasons) {
        try {
            this.loadDictionary(configuration);
        }
        catch (ConfigException ce) {
            unacceptableReasons.add(ce.getMessage());
            return false;
        }
        catch (InitializationException ie) {
            unacceptableReasons.add(ie.getMessage());
            return false;
        }
        catch (Exception e) {
            unacceptableReasons.add(StaticUtils.getExceptionMessage(e));
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(DictionaryPasswordValidatorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        try {
            this.dictionary = this.loadDictionary(configuration);
            this.currentConfig = configuration;
        }
        catch (Exception e) {
            resultCode = DirectoryConfig.getServerErrorResultCode();
            messages.add(StaticUtils.getExceptionMessage(e));
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

