/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryCacheCommon {
    public static HashSet<SearchFilter> getFilters(SortedSet<String> filters, int decodeErrorMsgId, int noFilterMsgId, ConfigErrorHandler errorHandler, DN configEntryDN) {
        HashSet<SearchFilter> searchFilters = new HashSet<SearchFilter>();
        if (filters != null && !filters.isEmpty()) {
            for (String curFilter : filters) {
                try {
                    searchFilters.add(SearchFilter.createFilterFromString(curFilter));
                }
                catch (DirectoryException de) {
                    errorHandler.reportError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, decodeErrorMsgId, String.valueOf(configEntryDN), curFilter, StaticUtils.stackTraceToSingleLineString(de), false, ResultCode.INVALID_ATTRIBUTE_SYNTAX);
                }
            }
            if (errorHandler.getConfigPhase() == ConfigPhase.PHASE_INIT && searchFilters.isEmpty()) {
                errorHandler.reportError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, noFilterMsgId, null, null, null, false, null);
            }
        }
        return searchFilters;
    }

    public static ConfigErrorHandler getConfigErrorHandler(ConfigPhase configPhase, List<String> unacceptableReasons, ArrayList<String> errorMessages) {
        EntryCacheCommon ec;
        ConfigErrorHandler errorHandler = null;
        EntryCacheCommon entryCacheCommon = ec = new EntryCacheCommon();
        entryCacheCommon.getClass();
        errorHandler = entryCacheCommon.new ConfigErrorHandler(configPhase, unacceptableReasons, errorMessages);
        return errorHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigErrorHandler {
        private ConfigPhase _configPhase;
        private List<String> _unacceptableReasons;
        private ArrayList<String> _errorMessages;
        private ResultCode _resultCode;
        private boolean _isAcceptable;

        public ConfigErrorHandler(ConfigPhase configPhase, List<String> unacceptableReasons, ArrayList<String> errorMessages) {
            this._configPhase = configPhase;
            this._unacceptableReasons = unacceptableReasons;
            this._errorMessages = errorMessages;
            this._resultCode = ResultCode.SUCCESS;
            this._isAcceptable = true;
        }

        public void reportError(ErrorLogCategory category, ErrorLogSeverity severity, int errorID, String arg1, String arg2, String arg3, boolean isAcceptable, ResultCode resultCode) {
            switch (this._configPhase) {
                case PHASE_INIT: {
                    ErrorLogger.logError(category, severity, errorID, arg1, arg2, arg3);
                    break;
                }
                case PHASE_ACCEPTABLE: {
                    String message = MessageHandler.getMessage(errorID, arg1, arg2, arg3);
                    this._unacceptableReasons.add(message);
                    this._isAcceptable = isAcceptable;
                    break;
                }
                case PHASE_APPLY: {
                    String message = MessageHandler.getMessage(errorID, arg1, arg2, arg3);
                    this._errorMessages.add(message);
                    this._isAcceptable = isAcceptable;
                    if (this._resultCode != ResultCode.SUCCESS) break;
                    this._resultCode = resultCode;
                    break;
                }
            }
        }

        public ResultCode getResultCode() {
            return this._resultCode;
        }

        public boolean getIsAcceptable() {
            return this._isAcceptable;
        }

        public List<String> getUnacceptableReasons() {
            return this._unacceptableReasons;
        }

        public ArrayList<String> getErrorMessages() {
            return this._errorMessages;
        }

        public ConfigPhase getConfigPhase() {
            return this._configPhase;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigPhase {
        PHASE_INIT,
        PHASE_ACCEPTABLE,
        PHASE_APPLY;

    }
}

