/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ExternalSASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.CertificateMapper;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.CertificateValidationPolicy;
import org.opends.server.extensions.TLSConnectionSecurityProvider;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalSASLMechanismHandler
extends SASLMechanismHandler<ExternalSASLMechanismHandlerCfg>
implements ConfigurationChangeListener<ExternalSASLMechanismHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType certificateAttributeType;
    private CertificateValidationPolicy validationPolicy;
    private DN configEntryDN;
    private ExternalSASLMechanismHandlerCfg currentConfig;

    @Override
    public void initializeSASLMechanismHandler(ExternalSASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        configuration.addExternalChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        switch (configuration.getCertificateValidationPolicy()) {
            case NEVER: {
                this.validationPolicy = CertificateValidationPolicy.NEVER;
                break;
            }
            case IFPRESENT: {
                this.validationPolicy = CertificateValidationPolicy.IFPRESENT;
                break;
            }
            case ALWAYS: {
                this.validationPolicy = CertificateValidationPolicy.ALWAYS;
            }
        }
        String attrTypeName = configuration.getCertificateAttribute();
        if (attrTypeName == null) {
            attrTypeName = "usercertificate";
        }
        this.certificateAttributeType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(attrTypeName), false);
        if (this.certificateAttributeType == null) {
            int msgID = 1310856;
            String message = MessageHandler.getMessage(msgID, String.valueOf(attrTypeName), String.valueOf(this.configEntryDN));
            throw new ConfigException(msgID, message);
        }
        CertificateMapper certificateMapper = DirectoryServer.getCertificateMapper(configuration.getCertificateMapperDN());
        if (certificateMapper == null) {
            int msgID = 1245592;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), String.valueOf(configuration.getCertificateMapperDN()));
            throw new ConfigException(msgID, message);
        }
        DirectoryServer.registerSASLMechanismHandler("EXTERNAL", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.currentConfig.removeExternalChangeListener(this);
        DirectoryServer.deregisterSASLMechanismHandler("EXTERNAL");
    }

    @Override
    public void processSASLBind(BindOperation bindOperation) {
        Entry userEntry;
        ExternalSASLMechanismHandlerCfg config = this.currentConfig;
        AttributeType certificateAttributeType = this.certificateAttributeType;
        CertificateValidationPolicy validationPolicy = this.validationPolicy;
        ClientConnection clientConnection = bindOperation.getClientConnection();
        if (clientConnection == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245307;
            String message = MessageHandler.getMessage(msgID);
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        ConnectionSecurityProvider securityProvider = clientConnection.getConnectionSecurityProvider();
        if (securityProvider == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245308;
            String message = MessageHandler.getMessage(msgID);
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        if (!(securityProvider instanceof TLSConnectionSecurityProvider)) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245309;
            String message = MessageHandler.getMessage(msgID, securityProvider.getSecurityMechanismName());
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        TLSConnectionSecurityProvider tlsSecurityProvider = (TLSConnectionSecurityProvider)securityProvider;
        Certificate[] clientCertChain = tlsSecurityProvider.getClientCertificateChain();
        if (clientCertChain == null || clientCertChain.length == 0) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245310;
            String message = MessageHandler.getMessage(msgID);
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        DN certificateMapperDN = config.getCertificateMapperDN();
        CertificateMapper certificateMapper = DirectoryServer.getCertificateMapper(certificateMapperDN);
        if (certificateMapper == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245592;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), String.valueOf(certificateMapperDN));
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        try {
            userEntry = certificateMapper.mapCertificateToUser(clientCertChain);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            bindOperation.setResponseData(de);
            return;
        }
        if (userEntry == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int msgID = 1245311;
            String message = MessageHandler.getMessage(msgID);
            bindOperation.setAuthFailureReason(msgID, message);
            return;
        }
        bindOperation.setSASLAuthUserEntry(userEntry);
        List<Attribute> certAttrList = userEntry.getAttribute(certificateAttributeType);
        switch (validationPolicy) {
            case ALWAYS: {
                byte[] certBytes;
                if (certAttrList == null) {
                    if (validationPolicy != CertificateValidationPolicy.ALWAYS) break;
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID = 1245321;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(userEntry.getDN()));
                    bindOperation.setAuthFailureReason(msgID, message);
                    return;
                }
                try {
                    certBytes = clientCertChain[0].getEncoded();
                    AttributeValue v = new AttributeValue(certificateAttributeType, (ByteString)new ASN1OctetString(certBytes));
                    boolean found = false;
                    for (Attribute a : certAttrList) {
                        if (!a.hasValue(v)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID = 1245322;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(userEntry.getDN()));
                        bindOperation.setAuthFailureReason(msgID, message);
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID = 1245323;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(userEntry.getDN()), StaticUtils.getExceptionMessage(e));
                    bindOperation.setAuthFailureReason(msgID, message);
                    return;
                }
            }
            case IFPRESENT: {
                byte[] certBytes;
                if (certAttrList == null) break;
                try {
                    certBytes = clientCertChain[0].getEncoded();
                    AttributeValue v = new AttributeValue(certificateAttributeType, (ByteString)new ASN1OctetString(certBytes));
                    boolean found = false;
                    for (Attribute a : certAttrList) {
                        if (!a.hasValue(v)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int msgID = 1245322;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(userEntry.getDN()));
                        bindOperation.setAuthFailureReason(msgID, message);
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int msgID = 1245323;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(userEntry.getDN()), StaticUtils.getExceptionMessage(e));
                    bindOperation.setAuthFailureReason(msgID, message);
                    return;
                }
            }
        }
        AuthenticationInfo authInfo = new AuthenticationInfo(userEntry, "EXTERNAL", DirectoryServer.isRootDN(userEntry.getDN()));
        bindOperation.setAuthenticationInfo(authInfo);
        bindOperation.setResultCode(ResultCode.SUCCESS);
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return false;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        ExternalSASLMechanismHandlerCfg config = (ExternalSASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ExternalSASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        CertificateMapper certificateMapper;
        AttributeType newCertificateType;
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        String attrTypeName = configuration.getCertificateAttribute();
        if (attrTypeName != null) {
            attrTypeName = "usercertificate";
        }
        if ((newCertificateType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(attrTypeName), false)) == null) {
            int msgID = 1310856;
            unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(attrTypeName), String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        if ((certificateMapper = DirectoryServer.getCertificateMapper(configuration.getCertificateMapperDN())) == null) {
            int msgID = 1245592;
            unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(cfgEntryDN), String.valueOf(configuration.getCertificateMapperDN())));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ExternalSASLMechanismHandlerCfg configuration) {
        AttributeType newCertificateType;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        CertificateValidationPolicy newValidationPolicy = CertificateValidationPolicy.ALWAYS;
        switch (configuration.getCertificateValidationPolicy()) {
            case NEVER: {
                newValidationPolicy = CertificateValidationPolicy.NEVER;
                break;
            }
            case IFPRESENT: {
                newValidationPolicy = CertificateValidationPolicy.IFPRESENT;
                break;
            }
            case ALWAYS: {
                newValidationPolicy = CertificateValidationPolicy.ALWAYS;
            }
        }
        String attrTypeName = configuration.getCertificateAttribute();
        if (attrTypeName == null) {
            attrTypeName = "usercertificate";
        }
        if ((newCertificateType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(attrTypeName), false)) == null) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.NO_SUCH_ATTRIBUTE;
            }
            int msgID = 1310856;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(attrTypeName), String.valueOf(this.configEntryDN)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.validationPolicy = newValidationPolicy;
            this.certificateAttributeType = newCertificateType;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

