/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.FIFOEntryCacheCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.EntryCache;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.EntryCacheCommon;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.CacheEntry;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFOEntryCache
extends EntryCache<FIFOEntryCacheCfg>
implements ConfigurationChangeListener<FIFOEntryCacheCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final LinkedHashMap<String, Double> timeUnits = new LinkedHashMap();
    private static final Runtime runtime = Runtime.getRuntime();
    private DN configEntryDN;
    private HashMap<Backend, HashMap<Long, CacheEntry>> idMap;
    private int maxMemoryPercent;
    private LinkedHashMap<DN, CacheEntry> dnMap;
    private Lock cacheLock;
    private long maxAllowedMemory;
    private long maxEntries;

    @Override
    public void initializeEntryCache(FIFOEntryCacheCfg configuration) throws ConfigException, InitializationException {
        configuration.addFIFOChangeListener(this);
        this.configEntryDN = configuration.dn();
        this.idMap = new HashMap();
        this.dnMap = new LinkedHashMap();
        this.cacheLock = new ReentrantLock();
        boolean applyChanges = true;
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_INIT, null, null);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeEntryCache() {
        this.cacheLock.lock();
        try {
            this.idMap.clear();
            this.dnMap.clear();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public boolean containsEntry(DN entryDN) {
        return this.dnMap.containsKey(entryDN);
    }

    @Override
    public Entry getEntry(DN entryDN) {
        CacheEntry e = this.dnMap.get(entryDN);
        if (e == null) {
            return null;
        }
        return e.getEntry();
    }

    @Override
    public long getEntryID(DN entryDN) {
        CacheEntry e = this.dnMap.get(entryDN);
        if (e == null) {
            return -1L;
        }
        return e.getEntryID();
    }

    @Override
    protected DN getEntryDN(Backend backend, long entryID) {
        CacheEntry e;
        HashMap<Long, CacheEntry> backendMap = this.idMap.get(backend);
        if (backendMap != null && (e = backendMap.get(entryID)) != null) {
            return e.getDN();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEntry(Entry entry, Backend backend, long entryID) {
        if (!this.filtersAllowCaching(entry)) {
            return;
        }
        CacheEntry cacheEntry = new CacheEntry(entry, backend, entryID);
        try {
            if (!this.cacheLock.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return;
        }
        try {
            long usedMemory = runtime.totalMemory() - runtime.freeMemory();
            if (usedMemory > this.maxAllowedMemory) {
                Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                if (iterator.hasNext()) {
                    CacheEntry ce = iterator.next();
                    iterator.remove();
                    HashMap<Long, CacheEntry> m = this.idMap.get(ce.getBackend());
                    if (m != null) {
                        m.remove(ce.getEntryID());
                    }
                }
            } else {
                this.dnMap.put(entry.getDN(), cacheEntry);
                HashMap<Long, CacheEntry> map = this.idMap.get(backend);
                if (map == null) {
                    map = new HashMap();
                    map.put(entryID, cacheEntry);
                    this.idMap.put(backend, map);
                } else {
                    map.put(entryID, cacheEntry);
                }
                int entryCount = this.dnMap.size();
                if (this.maxEntries > 0L && (long)entryCount > this.maxEntries) {
                    Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                    while (iterator.hasNext() && (long)entryCount > this.maxEntries) {
                        CacheEntry ce = iterator.next();
                        iterator.remove();
                        HashMap<Long, CacheEntry> m = this.idMap.get(ce.getBackend());
                        if (m != null) {
                            m.remove(ce.getEntryID());
                        }
                        --entryCount;
                    }
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putEntryIfAbsent(Entry entry, Backend backend, long entryID) {
        if (!this.filtersAllowCaching(entry)) {
            return true;
        }
        CacheEntry cacheEntry = new CacheEntry(entry, backend, entryID);
        try {
            if (!this.cacheLock.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS)) {
                return false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
        try {
            block19: {
                block18: {
                    if (this.dnMap.containsKey(entry.getDN())) {
                        boolean e = false;
                        return e;
                    }
                    long usedMemory = runtime.totalMemory() - runtime.freeMemory();
                    if (usedMemory <= this.maxAllowedMemory) break block18;
                    Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                    if (!iterator.hasNext()) break block19;
                    CacheEntry ce = iterator.next();
                    iterator.remove();
                    HashMap<Long, CacheEntry> m = this.idMap.get(ce.getBackend());
                    if (m == null) break block19;
                    m.remove(ce.getEntryID());
                    break block19;
                }
                this.dnMap.put(entry.getDN(), cacheEntry);
                HashMap<Long, CacheEntry> map = this.idMap.get(backend);
                if (map == null) {
                    map = new HashMap();
                    map.put(entryID, cacheEntry);
                    this.idMap.put(backend, map);
                } else {
                    map.put(entryID, cacheEntry);
                }
                int entryCount = this.dnMap.size();
                if (this.maxEntries > 0L && (long)entryCount > this.maxEntries) {
                    Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                    while (iterator.hasNext() && (long)entryCount > this.maxEntries) {
                        CacheEntry ce = iterator.next();
                        iterator.remove();
                        HashMap<Long, CacheEntry> m = this.idMap.get(ce.getBackend());
                        if (m != null) {
                            m.remove(ce.getEntryID());
                        }
                        --entryCount;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(DN entryDN) {
        this.cacheLock.lock();
        try {
            CacheEntry entry = (CacheEntry)this.dnMap.remove(entryDN);
            if (entry == null) {
                return;
            }
            Map map = this.idMap.get(entry.getBackend());
            if (map == null) {
                return;
            }
            map.remove(entry.getEntryID());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.cacheLock.lock();
        try {
            this.dnMap.clear();
            this.idMap.clear();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBackend(Backend backend) {
        this.cacheLock.lock();
        try {
            HashMap<Long, CacheEntry> map = this.idMap.remove(backend);
            if (map == null) {
                return;
            }
            int entriesDeleted = 0;
            for (CacheEntry e : map.values()) {
                this.dnMap.remove(e.getEntry().getDN());
                if (++entriesDeleted % 1000 != 0) continue;
                this.cacheLock.unlock();
                Thread.currentThread();
                Thread.yield();
                this.cacheLock.lock();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSubtree(DN baseDN) {
        Backend backend = DirectoryServer.getBackend(baseDN);
        if (backend == null) {
            return;
        }
        this.cacheLock.lock();
        try {
            this.clearSubtree(baseDN, backend);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private void clearSubtree(DN baseDN, Backend backend) {
        HashMap<Long, CacheEntry> map = this.idMap.get(backend);
        if (map == null) {
            return;
        }
        int entriesExamined = 0;
        Iterator<CacheEntry> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            CacheEntry e = iterator.next();
            DN entryDN = e.getEntry().getDN();
            if (entryDN.isDescendantOf(baseDN)) {
                iterator.remove();
                this.dnMap.remove(entryDN);
            }
            if (++entriesExamined % 1000 != 0) continue;
            this.cacheLock.unlock();
            Thread.currentThread();
            Thread.yield();
            this.cacheLock.lock();
        }
        for (Backend subBackend : backend.getSubordinateBackends()) {
            boolean isAppropriate = false;
            for (DN subBase : subBackend.getBaseDNs()) {
                if (!subBase.isDescendantOf(baseDN)) continue;
                isAppropriate = true;
                break;
            }
            if (!isAppropriate) continue;
            this.clearSubtree(baseDN, subBackend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleLowMemory() {
        this.cacheLock.lock();
        try {
            int numEntries = this.dnMap.size();
            if (numEntries < 1000) {
                this.dnMap.clear();
                this.idMap.clear();
            } else {
                Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                for (int numToDrop = numEntries / 10; iterator.hasNext() && numToDrop > 0; --numToDrop) {
                    CacheEntry entry = iterator.next();
                    iterator.remove();
                    HashMap<Long, CacheEntry> m = this.idMap.get(entry.getBackend());
                    if (m == null) continue;
                    m.remove(entry.getEntryID());
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public boolean isConfigurationAcceptable(EntryCacheCfg configuration, List<String> unacceptableReasons) {
        FIFOEntryCacheCfg config = (FIFOEntryCacheCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FIFOEntryCacheCfg configuration, List<String> unacceptableReasons) {
        boolean applyChanges = false;
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_ACCEPTABLE, unacceptableReasons, null);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        return errorHandler.getIsAcceptable();
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FIFOEntryCacheCfg configuration) {
        boolean applyChanges = false;
        ArrayList<String> errorMessages = new ArrayList<String>();
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_APPLY, null, errorMessages);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        boolean adminActionRequired = false;
        ConfigChangeResult changeResult = new ConfigChangeResult(errorHandler.getResultCode(), adminActionRequired, errorHandler.getErrorMessages());
        return changeResult;
    }

    public ConfigChangeResult applyNewConfiguration(FIFOEntryCacheCfg configuration, boolean detailedResults) {
        boolean configIsAcceptable;
        long prevLockTimeout = this.lockTimeout;
        long prevMaxEntries = this.maxEntries;
        int prevMaxMemoryPercent = this.maxMemoryPercent;
        HashSet prevIncludeFilters = this.includeFilters;
        HashSet prevExcludeFilters = this.excludeFilters;
        ConfigChangeResult changeResult = this.applyConfigurationChange(configuration);
        ResultCode resultCode = changeResult.getResultCode();
        boolean bl = configIsAcceptable = resultCode == ResultCode.SUCCESS;
        if (detailedResults && configIsAcceptable) {
            if (this.maxMemoryPercent != prevMaxMemoryPercent) {
                changeResult.addMessage(MessageHandler.getMessage(0x10001B, this.maxMemoryPercent, this.maxAllowedMemory));
            }
            if (this.maxEntries != prevMaxEntries) {
                changeResult.addMessage(MessageHandler.getMessage(0x10001C, this.maxEntries));
            }
            if (this.lockTimeout != prevLockTimeout) {
                changeResult.addMessage(MessageHandler.getMessage(0x10001D, this.lockTimeout));
            }
            if (!this.includeFilters.equals(prevIncludeFilters)) {
                changeResult.addMessage(MessageHandler.getMessage(0x10001E));
            }
            if (!this.excludeFilters.equals(prevExcludeFilters)) {
                changeResult.addMessage(MessageHandler.getMessage(0x10001F));
            }
        }
        return changeResult;
    }

    public boolean processEntryCacheConfig(FIFOEntryCacheCfg configuration, boolean applyChanges, EntryCacheCommon.ConfigErrorHandler errorHandler) {
        HashSet<SearchFilter> newIncludeFilters = null;
        HashSet<SearchFilter> newExcludeFilters = null;
        DN newConfigEntryDN = configuration.dn();
        long newLockTimeout = configuration.getLockTimeout();
        long newMaxEntries = configuration.getMaxEntries();
        int newMaxMemoryPercent = configuration.getMaxMemoryPercent();
        long maxJvmHeapSize = Runtime.getRuntime().maxMemory();
        long newMaxAllowedMemory = maxJvmHeapSize / 100L * (long)newMaxMemoryPercent;
        switch (errorHandler.getConfigPhase()) {
            case PHASE_INIT: {
                newIncludeFilters = EntryCacheCommon.getFilters(configuration.getIncludeFilter(), 1310743, 1179662, errorHandler, newConfigEntryDN);
                newExcludeFilters = EntryCacheCommon.getFilters(configuration.getExcludeFilter(), 0x120011, 0x120012, errorHandler, newConfigEntryDN);
                break;
            }
            case PHASE_ACCEPTABLE: 
            case PHASE_APPLY: {
                newIncludeFilters = EntryCacheCommon.getFilters(configuration.getIncludeFilter(), 1310743, 0, errorHandler, newConfigEntryDN);
                newExcludeFilters = EntryCacheCommon.getFilters(configuration.getExcludeFilter(), 1310745, 0, errorHandler, newConfigEntryDN);
            }
        }
        if (applyChanges && errorHandler.getIsAcceptable()) {
            this.configEntryDN = newConfigEntryDN;
            this.lockTimeout = newLockTimeout;
            this.maxEntries = newMaxEntries;
            this.maxMemoryPercent = newMaxMemoryPercent;
            this.maxAllowedMemory = newMaxAllowedMemory;
            this.includeFilters = newIncludeFilters;
            this.excludeFilters = newExcludeFilters;
        }
        return errorHandler.getIsAcceptable();
    }

    static {
        timeUnits.put("ms", 1.0);
        timeUnits.put("milliseconds", 1.0);
        timeUnits.put("s", 1000.0);
        timeUnits.put("seconds", 1000.0);
    }
}

