/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.MemberList;
import org.opends.server.types.MembershipException;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredStaticGroupMemberList
extends MemberList {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN baseDN;
    private DN groupDN;
    private Entry nextMatchingEntry;
    private Iterator<DN> memberDNIterator;
    private LinkedList<DN> memberDNs;
    private MembershipException nextMembershipException;
    private SearchFilter filter;
    private SearchScope scope;

    public FilteredStaticGroupMemberList(DN groupDN, Set<DN> memberDNs, DN baseDN, SearchScope scope, SearchFilter filter) {
        Validator.ensureNotNull(groupDN, memberDNs);
        this.groupDN = groupDN;
        this.memberDNs = new LinkedList<DN>(memberDNs);
        this.memberDNIterator = memberDNs.iterator();
        this.baseDN = baseDN;
        this.filter = filter;
        this.scope = scope == null ? SearchScope.WHOLE_SUBTREE : scope;
        this.nextMatchingEntry = null;
        this.nextMembershipException = null;
        this.nextMemberInternal();
    }

    private void nextMemberInternal() {
        block7: while (this.memberDNIterator.hasNext()) {
            DN nextDN = this.memberDNIterator.next();
            if (this.baseDN != null) {
                switch (this.scope) {
                    case BASE_OBJECT: {
                        if (this.baseDN.equals(nextDN)) break;
                        continue block7;
                    }
                    case SINGLE_LEVEL: {
                        if (this.baseDN.equals(nextDN.getParent())) break;
                        continue block7;
                    }
                    case SUBORDINATE_SUBTREE: {
                        if (!this.baseDN.equals(nextDN) && this.baseDN.isAncestorOf(nextDN)) break;
                        continue block7;
                    }
                    default: {
                        if (!this.baseDN.isAncestorOf(nextDN)) continue block7;
                    }
                }
            }
            try {
                Entry memberEntry = DirectoryConfig.getEntry(nextDN);
                if (memberEntry == null) {
                    int msgID = 1245567;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(nextDN), String.valueOf(this.groupDN));
                    this.nextMembershipException = new MembershipException(msgID, message, true);
                    return;
                }
                if (this.filter == null) {
                    this.nextMatchingEntry = memberEntry;
                    return;
                }
                if (!this.filter.matchesEntry(memberEntry)) continue;
                this.nextMatchingEntry = memberEntry;
                return;
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                int msgID = 1245568;
                String message = MessageHandler.getMessage(msgID, String.valueOf(nextDN), String.valueOf(this.groupDN), String.valueOf(de.getErrorMessage()));
                this.nextMembershipException = new MembershipException(msgID, message, true, de);
                return;
            }
        }
        this.nextMatchingEntry = null;
        this.nextMembershipException = null;
    }

    @Override
    public boolean hasMoreMembers() {
        if (!this.memberDNIterator.hasNext()) {
            return false;
        }
        return this.nextMatchingEntry != null || this.nextMembershipException != null;
    }

    @Override
    public DN nextMemberDN() throws MembershipException {
        if (!this.memberDNIterator.hasNext()) {
            return null;
        }
        Entry e = this.nextMemberEntry();
        if (e == null) {
            return null;
        }
        return e.getDN();
    }

    @Override
    public Entry nextMemberEntry() throws MembershipException {
        if (!this.memberDNIterator.hasNext()) {
            return null;
        }
        if (this.nextMembershipException == null) {
            Entry e = this.nextMatchingEntry;
            this.nextMatchingEntry = null;
            this.nextMemberInternal();
            return e;
        }
        MembershipException me = this.nextMembershipException;
        this.nextMembershipException = null;
        this.nextMemberInternal();
        throw me;
    }

    @Override
    public void close() {
    }
}

