/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.List;
import java.util.Set;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.LengthBasedPasswordValidatorCfg;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthBasedPasswordValidator
extends PasswordValidator<LengthBasedPasswordValidatorCfg>
implements ConfigurationChangeListener<LengthBasedPasswordValidatorCfg> {
    private LengthBasedPasswordValidatorCfg currentConfig;

    @Override
    public void initializePasswordValidator(LengthBasedPasswordValidatorCfg configuration) throws ConfigException, InitializationException {
        configuration.addLengthBasedChangeListener(this);
        this.currentConfig = configuration;
        int maxLength = configuration.getMaximumPasswordLength();
        int minLength = configuration.getMinimumPasswordLength();
        if (maxLength > 0 && minLength > 0 && minLength > maxLength) {
            int msgID = 1245519;
            String message = MessageHandler.getMessage(msgID, minLength, maxLength);
            throw new ConfigException(msgID, message);
        }
    }

    @Override
    public void finalizePasswordValidator() {
        this.currentConfig.removeLengthBasedChangeListener(this);
    }

    @Override
    public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, StringBuilder invalidReason) {
        LengthBasedPasswordValidatorCfg config = this.currentConfig;
        int numChars = newPassword.stringValue().length();
        int minLength = config.getMinimumPasswordLength();
        if (minLength > 0 && numChars < minLength) {
            invalidReason.append(MessageHandler.getMessage(1245520, minLength));
            return false;
        }
        int maxLength = config.getMaximumPasswordLength();
        if (maxLength > 0 && numChars > maxLength) {
            invalidReason.append(MessageHandler.getMessage(1245521, minLength));
            return false;
        }
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordValidatorCfg configuration, List<String> unacceptableReasons) {
        LengthBasedPasswordValidatorCfg config = (LengthBasedPasswordValidatorCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LengthBasedPasswordValidatorCfg configuration, List<String> unacceptableReasons) {
        int maxLength = configuration.getMaximumPasswordLength();
        int minLength = configuration.getMinimumPasswordLength();
        if (maxLength > 0 && minLength > 0 && minLength > maxLength) {
            int msgID = 1245519;
            String message = MessageHandler.getMessage(msgID, minLength, maxLength);
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LengthBasedPasswordValidatorCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

