/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.KeyManagerCfg;
import org.opends.server.admin.std.server.PKCS11KeyManagerCfg;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKCS11KeyManagerProvider
extends KeyManagerProvider<PKCS11KeyManagerCfg>
implements ConfigurationChangeListener<PKCS11KeyManagerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String PKCS11_KEYSTORE_TYPE = "PKCS11";
    private DN configEntryDN;
    private char[] keyStorePIN;
    private PKCS11KeyManagerCfg currentConfig;

    @Override
    public void initializeKeyManagerProvider(PKCS11KeyManagerCfg configuration) throws ConfigException, InitializationException {
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        configuration.addPKCS11ChangeListener(this);
        this.keyStorePIN = null;
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                int msgID = 0x140044;
                String message = MessageHandler.getMessage(msgID, String.valueOf(propertyName), String.valueOf(this.configEntryDN));
                throw new InitializationException(msgID, message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                int msgID = 1310791;
                String message = MessageHandler.getMessage(msgID, String.valueOf(enVarName), String.valueOf(this.configEntryDN));
                throw new InitializationException(msgID, message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePinFile() != null) {
            String pinStr;
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                int msgID = 1310794;
                String message = MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(this.configEntryDN));
                throw new InitializationException(msgID, message);
            }
            try {
                BufferedReader br = new BufferedReader(new FileReader(pinFile));
                pinStr = br.readLine();
                br.close();
            }
            catch (IOException ioe) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
                }
                int msgID = 1310795;
                String message = MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe));
                throw new InitializationException(msgID, message, ioe);
            }
            if (pinStr == null) {
                int msgID = 1310796;
                String message = MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(this.configEntryDN));
                throw new InitializationException(msgID, message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePin() != null) {
            this.keyStorePIN = configuration.getKeyStorePin().toCharArray();
        } else {
            int msgID = 1310800;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN));
            throw new ConfigException(msgID, message);
        }
    }

    @Override
    public void finalizeKeyManagerProvider() {
        this.currentConfig.removePKCS11ChangeListener(this);
    }

    @Override
    public KeyManager[] getKeyManagers() throws DirectoryException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(PKCS11_KEYSTORE_TYPE);
            keyStore.load(null, this.keyStorePIN);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1310801;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        try {
            String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            keyManagerFactory.init(keyStore, this.keyStorePIN);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1310804;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
    }

    @Override
    public boolean isConfigurationAcceptable(KeyManagerCfg configuration, List<String> unacceptableReasons) {
        PKCS11KeyManagerCfg config = (PKCS11KeyManagerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfigurationChangeAcceptable(PKCS11KeyManagerCfg configuration, List<String> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                int msgID = 0x140044;
                unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(propertyName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                int msgID = 1310791;
                unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(enVarName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        } else if (configuration.getKeyStorePinFile() != null) {
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                int msgID = 1310794;
                unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            } else {
                String pinStr = null;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(pinFile));
                    pinStr = br.readLine();
                }
                catch (IOException ioe) {
                    int msgID = 1310795;
                    unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(ioe)));
                    configAcceptable = false;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
                if (pinStr == null) {
                    int msgID = 1310796;
                    unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(cfgEntryDN)));
                    configAcceptable = false;
                }
            }
        } else if (configuration.getKeyStorePin() != null) {
            configuration.getKeyStorePin().toCharArray();
        } else {
            int msgID = 1310800;
            unacceptableReasons.add(MessageHandler.getMessage(msgID, String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(PKCS11KeyManagerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        char[] newPIN = null;
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                int msgID = 0x140044;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(propertyName), String.valueOf(this.configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                int msgID = 1310791;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(enVarName), String.valueOf(this.configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        } else if (configuration.getKeyStorePinFile() != null) {
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                int msgID = 1310794;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(this.configEntryDN)));
            } else {
                String pinStr = null;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(pinFile));
                    pinStr = br.readLine();
                }
                catch (IOException ioe) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    int msgID = 1310795;
                    messages.add(MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe)));
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
                if (pinStr == null) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    int msgID = 1310796;
                    messages.add(MessageHandler.getMessage(msgID, String.valueOf(fileName), String.valueOf(this.configEntryDN)));
                } else {
                    newPIN = pinStr.toCharArray();
                }
            }
        } else if (configuration.getKeyStorePin() != null) {
            newPIN = configuration.getKeyStorePin().toCharArray();
        } else {
            resultCode = DirectoryServer.getServerErrorResultCode();
            int msgID = 1310800;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.currentConfig = configuration;
            this.keyStorePIN = newPIN;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

