/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ExtendedOperationHandlerCfg;
import org.opends.server.admin.std.server.PasswordModifyExtendedOperationHandlerCfg;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.IdentityMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordModifyExtendedOperation
extends ExtendedOperationHandler<PasswordModifyExtendedOperationHandlerCfg>
implements ConfigurationChangeListener<PasswordModifyExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private PasswordModifyExtendedOperationHandlerCfg currentConfig;
    private DN identityMapperDN;
    private IdentityMapper identityMapper;

    @Override
    public void initializeExtendedOperationHandler(PasswordModifyExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        try {
            this.identityMapperDN = config.getIdentityMapperDN();
            this.identityMapper = DirectoryServer.getIdentityMapper(this.identityMapperDN);
            if (this.identityMapper == null) {
                int msgID = 1245552;
                String message = MessageHandler.getMessage(msgID, String.valueOf(this.identityMapperDN), String.valueOf(config.dn()));
                throw new ConfigException(msgID, message);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245553;
            String message = MessageHandler.getMessage(msgID, String.valueOf(config.dn()), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(msgID, message, e);
        }
        this.supportedControlOIDs = new HashSet();
        this.supportedControlOIDs.add("1.3.6.1.4.1.4203.1.10.2");
        this.supportedControlOIDs.add("1.3.6.1.4.1.42.2.27.8.5.1");
        this.currentConfig = config;
        config.addPasswordModifyChangeListener(this);
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.4203.1.11.1", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        this.currentConfig.removePasswordModifyChangeListener(this);
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.4203.1.11.1");
        this.deregisterControlsAndFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        block171: {
            block172: {
                block173: {
                    block170: {
                        block168: {
                            block169: {
                                block166: {
                                    block167: {
                                        block163: {
                                            block164: {
                                                block165: {
                                                    block161: {
                                                        block162: {
                                                            block159: {
                                                                block160: {
                                                                    block157: {
                                                                        block158: {
                                                                            block155: {
                                                                                block156: {
                                                                                    block150: {
                                                                                        block154: {
                                                                                            block152: {
                                                                                                block153: {
                                                                                                    block149: {
                                                                                                        block151: {
                                                                                                            block147: {
                                                                                                                block148: {
                                                                                                                    block145: {
                                                                                                                        block146: {
                                                                                                                            block143: {
                                                                                                                                block144: {
                                                                                                                                    block136: {
                                                                                                                                        block142: {
                                                                                                                                            block139: {
                                                                                                                                                block140: {
                                                                                                                                                    block141: {
                                                                                                                                                        block137: {
                                                                                                                                                            block138: {
                                                                                                                                                                block134: {
                                                                                                                                                                    block135: {
                                                                                                                                                                        block132: {
                                                                                                                                                                            block133: {
                                                                                                                                                                                userIdentity = null;
                                                                                                                                                                                oldPassword = null;
                                                                                                                                                                                newPassword = null;
                                                                                                                                                                                noOpRequested = false;
                                                                                                                                                                                pwPolicyRequested = false;
                                                                                                                                                                                pwPolicyWarningValue = 0;
                                                                                                                                                                                pwPolicyErrorType = null;
                                                                                                                                                                                pwPolicyWarningType = null;
                                                                                                                                                                                controls = operation.getRequestControls();
                                                                                                                                                                                if (controls != null) {
                                                                                                                                                                                    for (Control c : controls) {
                                                                                                                                                                                        oid = c.getOID();
                                                                                                                                                                                        if (oid.equals("1.3.6.1.4.1.4203.1.10.2")) {
                                                                                                                                                                                            noOpRequested = true;
                                                                                                                                                                                            continue;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (!oid.equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
                                                                                                                                                                                        pwPolicyRequested = true;
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                                if ((requestValue = operation.getRequestValue()) != null) {
                                                                                                                                                                                    try {
                                                                                                                                                                                        requestSequence = ASN1Sequence.decodeAsSequence(requestValue.value());
                                                                                                                                                                                        block50: for (ASN1Element e : requestSequence.elements()) {
                                                                                                                                                                                            switch (e.getType()) {
                                                                                                                                                                                                case -128: {
                                                                                                                                                                                                    userIdentity = e.decodeAsOctetString();
                                                                                                                                                                                                    continue block50;
                                                                                                                                                                                                }
                                                                                                                                                                                                case -127: {
                                                                                                                                                                                                    oldPassword = e.decodeAsOctetString();
                                                                                                                                                                                                    continue block50;
                                                                                                                                                                                                }
                                                                                                                                                                                                case -126: {
                                                                                                                                                                                                    newPassword = e.decodeAsOctetString();
                                                                                                                                                                                                    continue block50;
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
                                                                                                                                                                                            msgID = 1245216;
                                                                                                                                                                                            operation.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{StaticUtils.byteToHex(e.getType())}));
                                                                                                                                                                                            return;
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                    catch (ASN1Exception ae) {
                                                                                                                                                                                        if (DebugLogger.debugEnabled()) {
                                                                                                                                                                                            PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                                                                                                                                                                                        }
                                                                                                                                                                                        operation.setResultCode(ResultCode.PROTOCOL_ERROR);
                                                                                                                                                                                        msgID = 1245217;
                                                                                                                                                                                        message = MessageHandler.getMessage(msgID, new Object[]{StaticUtils.getExceptionMessage(ae)});
                                                                                                                                                                                        operation.appendErrorMessage(message);
                                                                                                                                                                                        return;
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                                requestorEntry = operation.getAuthorizationEntry();
                                                                                                                                                                                userDN = null;
                                                                                                                                                                                userLock = null;
                                                                                                                                                                                if (userIdentity != null) ** GOTO lbl79
                                                                                                                                                                                clientConnection = operation.getClientConnection();
                                                                                                                                                                                authInfo = clientConnection.getAuthenticationInfo();
                                                                                                                                                                                if (authInfo.isAuthenticated() && requestorEntry != null) break block132;
                                                                                                                                                                                operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                                                                                                msgID = 1245218;
                                                                                                                                                                                operation.appendErrorMessage(MessageHandler.getMessage(msgID));
                                                                                                                                                                                if (userLock == null) break block133;
                                                                                                                                                                                LockManager.unlock(userDN, userLock);
                                                                                                                                                                            }
                                                                                                                                                                            return;
                                                                                                                                                                        }
                                                                                                                                                                        userDN = requestorEntry.getDN();
                                                                                                                                                                        for (i = 0; i < 3 && (userLock = LockManager.lockWrite(userDN)) == null; ++i) {
                                                                                                                                                                        }
                                                                                                                                                                        if (userLock != null) break block134;
                                                                                                                                                                        operation.setResultCode(DirectoryServer.getServerErrorResultCode());
                                                                                                                                                                        msgID = 1310755;
                                                                                                                                                                        message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(userDN)});
                                                                                                                                                                        operation.appendErrorMessage(message);
                                                                                                                                                                        if (userLock == null) break block135;
                                                                                                                                                                        LockManager.unlock(userDN, userLock);
                                                                                                                                                                    }
                                                                                                                                                                    return;
                                                                                                                                                                }
                                                                                                                                                                userEntry = requestorEntry;
                                                                                                                                                                break block136;
lbl79:
                                                                                                                                                                // 1 sources

                                                                                                                                                                authzIDStr = userIdentity.stringValue();
                                                                                                                                                                lowerAuthzIDStr = StaticUtils.toLowerCase(authzIDStr);
                                                                                                                                                                if (!lowerAuthzIDStr.startsWith("dn:")) ** GOTO lbl106
                                                                                                                                                                try {
                                                                                                                                                                    userDN = DN.decode(authzIDStr.substring(3));
                                                                                                                                                                }
                                                                                                                                                                catch (DirectoryException de) {
                                                                                                                                                                    if (DebugLogger.debugEnabled()) {
                                                                                                                                                                        PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                                                                                                                    }
                                                                                                                                                                    operation.setResultCode(ResultCode.INVALID_DN_SYNTAX);
                                                                                                                                                                    msgID = 1245220;
                                                                                                                                                                    operation.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{authzIDStr}));
                                                                                                                                                                    if (userLock != null) {
                                                                                                                                                                        LockManager.unlock(userDN, userLock);
                                                                                                                                                                    }
                                                                                                                                                                    return;
                                                                                                                                                                }
                                                                                                                                                                actualRootDN = DirectoryServer.getActualRootBindDN(userDN);
                                                                                                                                                                if (actualRootDN != null) {
                                                                                                                                                                    userDN = actualRootDN;
                                                                                                                                                                }
                                                                                                                                                                if ((userEntry = this.getEntryByDN(operation, userDN)) != null) break block137;
                                                                                                                                                                if (userLock == null) break block138;
                                                                                                                                                                LockManager.unlock(userDN, userLock);
                                                                                                                                                            }
                                                                                                                                                            return;
                                                                                                                                                        }
                                                                                                                                                        break block136;
lbl106:
                                                                                                                                                        // 1 sources

                                                                                                                                                        if (!lowerAuthzIDStr.startsWith("u:")) break block139;
                                                                                                                                                        userEntry = this.identityMapper.getEntryForID(authzIDStr.substring(2));
                                                                                                                                                        if (userEntry != null) break block140;
                                                                                                                                                        if (oldPassword == null) {
                                                                                                                                                            operation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                                                                                                                                                            msgID = 1245554;
                                                                                                                                                            operation.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{authzIDStr}));
                                                                                                                                                        } else {
                                                                                                                                                            operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                                                                                            msgID = 1245554;
                                                                                                                                                            operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID, new Object[]{authzIDStr}));
                                                                                                                                                        }
                                                                                                                                                        if (userLock == null) break block141;
                                                                                                                                                        LockManager.unlock(userDN, userLock);
                                                                                                                                                    }
                                                                                                                                                    return;
                                                                                                                                                }
                                                                                                                                                userDN = userEntry.getDN();
                                                                                                                                                break block136;
                                                                                                                                                {
                                                                                                                                                    catch (DirectoryException de) {
                                                                                                                                                        if (DebugLogger.debugEnabled()) {
                                                                                                                                                            PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                                                                                                        }
                                                                                                                                                        if (oldPassword == null) {
                                                                                                                                                            operation.setResultCode(de.getResultCode());
                                                                                                                                                            msgID = 1245555;
                                                                                                                                                            operation.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{authzIDStr, de.getErrorMessage()}));
                                                                                                                                                        } else {
                                                                                                                                                            operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                                                                                            msgID = 1245555;
                                                                                                                                                            operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID, new Object[]{authzIDStr, de.getErrorMessage()}));
                                                                                                                                                        }
                                                                                                                                                        if (userLock != null) {
                                                                                                                                                            LockManager.unlock(userDN, userLock);
                                                                                                                                                        }
                                                                                                                                                        return;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
                                                                                                                                            msgID = 1245221;
                                                                                                                                            operation.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{authzIDStr}));
                                                                                                                                            if (userLock == null) break block142;
                                                                                                                                            LockManager.unlock(userDN, userLock);
                                                                                                                                        }
                                                                                                                                        return;
                                                                                                                                    }
                                                                                                                                    try {
                                                                                                                                        pwPolicyState = new PasswordPolicyState(userEntry, false, false);
                                                                                                                                    }
                                                                                                                                    catch (DirectoryException de) {
                                                                                                                                        if (DebugLogger.debugEnabled()) {
                                                                                                                                            PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                                                                                        }
                                                                                                                                        operation.setResultCode(DirectoryServer.getServerErrorResultCode());
                                                                                                                                        msgID = 1245538;
                                                                                                                                        operation.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{String.valueOf(userDN), de.getErrorMessage()}));
                                                                                                                                        if (userLock != null) {
                                                                                                                                            LockManager.unlock(userDN, userLock);
                                                                                                                                        }
                                                                                                                                        return;
                                                                                                                                    }
                                                                                                                                    selfChange = userIdentity == null ? true : (requestorEntry == null ? oldPassword != null : userDN.equals(requestorEntry.getDN()));
                                                                                                                                    if (selfChange || (clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.PASSWORD_RESET, operation)) break block143;
                                                                                                                                    msgID = 1245576;
                                                                                                                                    operation.appendErrorMessage(MessageHandler.getMessage(msgID));
                                                                                                                                    operation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                                                                                                                                    if (userLock == null) break block144;
                                                                                                                                    LockManager.unlock(userDN, userLock);
                                                                                                                                }
                                                                                                                                return;
                                                                                                                            }
                                                                                                                            if (!pwPolicyState.isDisabled()) break block145;
                                                                                                                            if (pwPolicyRequested) {
                                                                                                                                pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                                                                                                                                operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                                                                            }
                                                                                                                            msgID = 1245565;
                                                                                                                            message = MessageHandler.getMessage(msgID);
                                                                                                                            if (oldPassword == null) {
                                                                                                                                operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                                                operation.appendErrorMessage(message);
                                                                                                                            } else {
                                                                                                                                operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                                                                operation.appendAdditionalLogMessage(message);
                                                                                                                            }
                                                                                                                            if (userLock == null) break block146;
                                                                                                                            LockManager.unlock(userDN, userLock);
                                                                                                                        }
                                                                                                                        return;
                                                                                                                    }
                                                                                                                    if (!selfChange || !pwPolicyState.lockedDueToFailures() && !pwPolicyState.lockedDueToIdleInterval() && !pwPolicyState.lockedDueToMaximumResetAge()) break block147;
                                                                                                                    if (pwPolicyRequested) {
                                                                                                                        pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                                                                                                                        operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                                                                    }
                                                                                                                    msgID = 1245566;
                                                                                                                    message = MessageHandler.getMessage(msgID);
                                                                                                                    if (oldPassword == null) {
                                                                                                                        operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                                        operation.appendErrorMessage(message);
                                                                                                                    } else {
                                                                                                                        operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                                                        operation.appendAdditionalLogMessage(message);
                                                                                                                    }
                                                                                                                    if (userLock == null) break block148;
                                                                                                                    LockManager.unlock(userDN, userLock);
                                                                                                                }
                                                                                                                return;
                                                                                                            }
                                                                                                            if (oldPassword != null) break block149;
                                                                                                            if (!selfChange || !pwPolicyState.getPolicy().requireCurrentPassword()) break block150;
                                                                                                            operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                            msgID = 1245539;
                                                                                                            operation.appendErrorMessage(MessageHandler.getMessage(msgID));
                                                                                                            if (pwPolicyRequested) {
                                                                                                                pwPolicyErrorType = PasswordPolicyErrorType.MUST_SUPPLY_OLD_PASSWORD;
                                                                                                                operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                                                            }
                                                                                                            if (userLock == null) break block151;
                                                                                                            LockManager.unlock(userDN, userLock);
                                                                                                        }
                                                                                                        return;
                                                                                                    }
                                                                                                    if (!pwPolicyState.getPolicy().requireSecureAuthentication() || operation.getClientConnection().isSecure()) break block152;
                                                                                                    operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                                    msgID = 1245540;
                                                                                                    operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID));
                                                                                                    if (userLock == null) break block153;
                                                                                                    LockManager.unlock(userDN, userLock);
                                                                                                }
                                                                                                return;
                                                                                            }
                                                                                            if (pwPolicyState.passwordMatches(oldPassword)) {
                                                                                                pwPolicyState.setLastLoginTime();
                                                                                                break block150;
                                                                                            }
                                                                                            operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                            msgID = 1245225;
                                                                                            operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID));
                                                                                            pwPolicyState.updateAuthFailureTimes();
                                                                                            mods = pwPolicyState.getModifications();
                                                                                            if (!mods.isEmpty()) {
                                                                                                conn = InternalClientConnection.getRootConnection();
                                                                                                conn.processModify(userDN, mods);
                                                                                            }
                                                                                            if (userLock == null) break block154;
                                                                                            LockManager.unlock(userDN, userLock);
                                                                                        }
                                                                                        return;
                                                                                    }
                                                                                    if (!selfChange || pwPolicyState.getPolicy().allowUserPasswordChanges()) break block155;
                                                                                    if (pwPolicyRequested) {
                                                                                        pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
                                                                                        operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                                    }
                                                                                    if (oldPassword == null) {
                                                                                        operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                        msgID = 1245541;
                                                                                        operation.appendErrorMessage(MessageHandler.getMessage(msgID));
                                                                                    } else {
                                                                                        operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                        msgID = 1245541;
                                                                                        operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID));
                                                                                    }
                                                                                    if (userLock == null) break block156;
                                                                                    LockManager.unlock(userDN, userLock);
                                                                                }
                                                                                return;
                                                                            }
                                                                            if (!pwPolicyState.getPolicy().requireSecurePasswordChanges() || operation.getClientConnection().isSecure()) break block157;
                                                                            if (oldPassword == null) {
                                                                                operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                msgID = 1245542;
                                                                                operation.appendErrorMessage(MessageHandler.getMessage(msgID));
                                                                            } else {
                                                                                operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                msgID = 1245542;
                                                                                operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID));
                                                                            }
                                                                            if (userLock == null) break block158;
                                                                            LockManager.unlock(userDN, userLock);
                                                                        }
                                                                        return;
                                                                    }
                                                                    if (!selfChange || !pwPolicyState.isWithinMinimumAge()) break block159;
                                                                    if (pwPolicyRequested) {
                                                                        pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_TOO_YOUNG;
                                                                        operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                    }
                                                                    if (oldPassword == null) {
                                                                        operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                        msgID = 1245543;
                                                                        operation.appendErrorMessage(MessageHandler.getMessage(msgID));
                                                                    } else {
                                                                        operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                        msgID = 1245543;
                                                                        operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID));
                                                                    }
                                                                    if (userLock == null) break block160;
                                                                    LockManager.unlock(userDN, userLock);
                                                                }
                                                                return;
                                                            }
                                                            if (!selfChange || !pwPolicyState.isPasswordExpired() || pwPolicyState.getPolicy().allowExpiredPasswordChanges()) break block161;
                                                            if (pwPolicyRequested) {
                                                                pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                                                                operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                            }
                                                            if (oldPassword == null) {
                                                                operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                msgID = 1245544;
                                                                operation.appendErrorMessage(MessageHandler.getMessage(msgID));
                                                            } else {
                                                                operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                msgID = 1245544;
                                                                operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID));
                                                            }
                                                            if (userLock == null) break block162;
                                                            LockManager.unlock(userDN, userLock);
                                                        }
                                                        return;
                                                    }
                                                    generatedPassword = false;
                                                    isPreEncoded = false;
                                                    if (newPassword != null) break block163;
                                                    newPassword = pwPolicyState.generatePassword();
                                                    if (newPassword != null) break block164;
                                                    if (oldPassword == null) {
                                                        operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                        msgID = 1245545;
                                                        operation.appendErrorMessage(MessageHandler.getMessage(msgID));
                                                    } else {
                                                        operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                        msgID = 1245545;
                                                        operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID));
                                                    }
                                                    if (userLock == null) break block165;
                                                    LockManager.unlock(userDN, userLock);
                                                }
                                                return;
                                            }
                                            generatedPassword = true;
                                            ** GOTO lbl422
                                            {
                                                catch (DirectoryException de) {
                                                    if (DebugLogger.debugEnabled()) {
                                                        PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                    }
                                                    if (oldPassword == null) {
                                                        operation.setResultCode(de.getResultCode());
                                                        msgID = 1245546;
                                                        operation.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{de.getErrorMessage()}));
                                                    } else {
                                                        operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                        msgID = 1245546;
                                                        operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID, new Object[]{de.getErrorMessage()}));
                                                    }
                                                    if (userLock != null) {
                                                        LockManager.unlock(userDN, userLock);
                                                    }
                                                    return;
                                                }
                                            }
                                        }
                                        if (!pwPolicyState.passwordIsPreEncoded(newPassword)) break block166;
                                        isPreEncoded = true;
                                        if (pwPolicyState.getPolicy().allowPreEncodedPasswords()) ** GOTO lbl422
                                        if (oldPassword == null) {
                                            operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                            msgID = 1245547;
                                            operation.appendErrorMessage(MessageHandler.getMessage(msgID));
                                        } else {
                                            operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                            msgID = 1245547;
                                            operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID));
                                        }
                                        if (userLock == null) break block167;
                                        LockManager.unlock(userDN, userLock);
                                    }
                                    return;
                                }
                                if (!selfChange && pwPolicyState.getPolicy().skipValidationForAdministrators()) break block168;
                                if (oldPassword == null) {
                                    clearPasswords = new HashSet<ByteString>(pwPolicyState.getClearPasswords());
                                } else {
                                    clearPasswords = new HashSet<ASN1OctetString>();
                                    clearPasswords.add(oldPassword);
                                    for (ByteString pw : pwPolicyState.getClearPasswords()) {
                                        if (Arrays.equals(pw.value(), oldPassword.value())) continue;
                                        clearPasswords.add(pw);
                                    }
                                }
                                invalidReason = new StringBuilder();
                                if (pwPolicyState.passwordIsAcceptable(operation, userEntry, newPassword, clearPasswords, invalidReason)) break block168;
                                if (pwPolicyRequested) {
                                    pwPolicyErrorType = PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY;
                                    operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                }
                                if (oldPassword == null) {
                                    operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                    msgID = 1245548;
                                    operation.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{String.valueOf(invalidReason)}));
                                } else {
                                    operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                    msgID = 1245548;
                                    operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID, new Object[]{String.valueOf(invalidReason)}));
                                }
                                if (userLock == null) break block169;
                                LockManager.unlock(userDN, userLock);
                            }
                            return;
                        }
                        if (pwPolicyState.maintainHistory()) {
                            if (pwPolicyState.isPasswordInHistory(newPassword)) {
                                if (oldPassword == null) {
                                    operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                    msgID = 1245714;
                                    operation.appendErrorMessage(MessageHandler.getMessage(msgID));
                                } else {
                                    operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                    msgID = 1245714;
                                    operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID));
                                }
                            } else {
                                pwPolicyState.updatePasswordHistory();
                            }
                        }
lbl422:
                        // 7 sources

                        if (isPreEncoded) {
                            encodedPasswords = new ArrayList<E>(1);
                            encodedPasswords.add(newPassword);
                            break block170;
                        }
                        try {
                            encodedPasswords = pwPolicyState.encodePassword(newPassword);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            if (oldPassword == null) {
                                operation.setResultCode(de.getResultCode());
                                msgID = 1245549;
                                operation.appendErrorMessage(MessageHandler.getMessage(msgID, new Object[]{de.getErrorMessage()}));
                            } else {
                                operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                msgID = 1245549;
                                operation.appendAdditionalLogMessage(MessageHandler.getMessage(msgID, new Object[]{de.getErrorMessage()}));
                            }
                            if (userLock != null) {
                                LockManager.unlock(userDN, userLock);
                            }
                            return;
                        }
                    }
                    try {
                        attrType = pwPolicyState.getPolicy().getPasswordAttribute();
                        modList = new ArrayList<Modification>();
                        if (oldPassword != null) {
                            existingValues = pwPolicyState.getPasswordValues();
                            deleteValues = new LinkedHashSet<AttributeValue>(existingValues.size());
                            if (pwPolicyState.getPolicy().usesAuthPasswordSyntax()) {
                                for (AttributeValue v : existingValues) {
                                    try {
                                        components = AuthPasswordSyntax.decodeAuthPassword(v.getStringValue());
                                        scheme = DirectoryServer.getAuthPasswordStorageScheme(components[0].toString());
                                        if (scheme == null) {
                                            deleteValues.add(v);
                                            continue;
                                        }
                                        if (!scheme.authPasswordMatches(oldPassword, components[1].toString(), components[2].toString())) continue;
                                        deleteValues.add(v);
                                    }
                                    catch (DirectoryException de) {
                                        if (DebugLogger.debugEnabled()) {
                                            PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                        }
                                        deleteValues.add(v);
                                    }
                                }
                            } else {
                                for (AttributeValue v : existingValues) {
                                    try {
                                        components = UserPasswordSyntax.decodeUserPassword(v.getStringValue());
                                        scheme = DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase((String)components[0]));
                                        if (scheme == null) {
                                            deleteValues.add(v);
                                            continue;
                                        }
                                        if (!scheme.passwordMatches(oldPassword, new ASN1OctetString((String)components[1]))) continue;
                                        deleteValues.add(v);
                                    }
                                    catch (DirectoryException de) {
                                        if (DebugLogger.debugEnabled()) {
                                            PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                        }
                                        deleteValues.add(v);
                                    }
                                }
                            }
                            deleteAttr = new Attribute(attrType, attrType.getNameOrOID(), deleteValues);
                            modList.add(new Modification(ModificationType.DELETE, deleteAttr));
                            addValues = new LinkedHashSet<AttributeValue>(encodedPasswords.size());
                            for (ByteString s : encodedPasswords) {
                                addValues.add(new AttributeValue(attrType, s));
                            }
                            addAttr = new Attribute(attrType, attrType.getNameOrOID(), addValues);
                            modList.add(new Modification(ModificationType.ADD, addAttr));
                        } else {
                            replaceValues = new LinkedHashSet<AttributeValue>(encodedPasswords.size());
                            for (ByteString s : encodedPasswords) {
                                replaceValues.add(new AttributeValue(attrType, s));
                            }
                            addAttr = new Attribute(attrType, attrType.getNameOrOID(), replaceValues);
                            modList.add(new Modification(ModificationType.REPLACE, addAttr));
                        }
                        pwPolicyState.setPasswordChangedTime();
                        if (selfChange) {
                            pwPolicyState.setMustChangePassword(false);
                        } else {
                            pwPolicyState.setMustChangePassword(pwPolicyState.getPolicy().forceChangeOnReset());
                        }
                        pwPolicyState.clearFailureLockout();
                        pwPolicyState.clearGraceLoginTimes();
                        pwPolicyState.clearWarnedTime();
                        if (noOpRequested) {
                            operation.appendErrorMessage(MessageHandler.getMessage(1114492));
                            operation.setResultCode(ResultCode.NO_OPERATION);
                            break block171;
                        }
                        if (selfChange && requestorEntry == null) {
                            requestorEntry = userEntry;
                        }
                        if ((resultCode = (modifyOperation = (internalConnection = new InternalClientConnection(authInfo = new AuthenticationInfo(requestorEntry, isRoot = DirectoryServer.isRootDN(requestorEntry.getDN())))).processModify(userDN, modList)).getResultCode()) == ResultCode.SUCCESS) break block172;
                        operation.setResultCode(resultCode);
                        operation.setErrorMessage(modifyOperation.getErrorMessage());
                        operation.setReferralURLs(modifyOperation.getReferralURLs());
                        if (userLock == null) break block173;
                    }
                    catch (Throwable var33_90) {
                        if (userLock != null) {
                            LockManager.unlock(userDN, userLock);
                        }
                        throw var33_90;
                    }
                    LockManager.unlock(userDN, userLock);
                }
                return;
            }
            pwPolicyMods = pwPolicyState.getModifications();
            if (!pwPolicyMods.isEmpty() && (modOp = (rootConnection = InternalClientConnection.getRootConnection()).processModify(userDN, pwPolicyMods)).getResultCode() != ResultCode.SUCCESS) {
                msgID = 0x110210;
                message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(userDN), modOp.getResultCode(), modOp.getErrorMessage()});
                ErrorLogger.logError(ErrorLogCategory.PASSWORD_POLICY, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
            }
            operation.setResultCode(ResultCode.SUCCESS);
            if (generatedPassword) {
                valueElements = new ArrayList<ASN1Element>(1);
                newPWString = new ASN1OctetString(-128, newPassword.value());
                valueElements.add(newPWString);
                valueSequence = new ASN1Sequence(valueElements);
                operation.setResponseValue(new ASN1OctetString(valueSequence.encode()));
            }
            if (selfChange && authInfo.getAuthenticationDN() != null && authInfo.getAuthenticationDN().equals(userDN)) {
                operation.getClientConnection().setMustChangePassword(false);
            }
            if (!pwPolicyRequested) break block171;
            operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
        }
        if (userLock != null) {
            LockManager.unlock(userDN, userLock);
        }
    }

    private Entry getEntryByDN(ExtendedOperation operation, DN entryDN) {
        try {
            Entry userEntry = DirectoryServer.getEntry(entryDN);
            if (userEntry == null) {
                operation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                int msgID = 1245222;
                operation.appendErrorMessage(MessageHandler.getMessage(msgID, String.valueOf(entryDN)));
                for (DN parentDN = entryDN.getParentDNInSuffix(); parentDN != null; parentDN = parentDN.getParentDNInSuffix()) {
                    try {
                        if (!DirectoryServer.entryExists(parentDN)) continue;
                        operation.setMatchedDN(parentDN);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    break;
                }
                return null;
            }
            return userEntry;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            operation.setResultCode(de.getResultCode());
            operation.appendErrorMessage(de.getErrorMessage());
            operation.setMatchedDN(de.getMatchedDN());
            operation.setReferralURLs(de.getReferralURLs());
            return null;
        }
    }

    @Override
    public boolean isConfigurationAcceptable(ExtendedOperationHandlerCfg configuration, List<String> unacceptableReasons) {
        PasswordModifyExtendedOperationHandlerCfg config = (PasswordModifyExtendedOperationHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PasswordModifyExtendedOperationHandlerCfg config, List<String> unacceptableReasons) {
        try {
            DN mapperDN = config.getIdentityMapperDN();
            IdentityMapper mapper = DirectoryServer.getIdentityMapper(mapperDN);
            if (mapper == null) {
                int msgID = 1245552;
                String message = MessageHandler.getMessage(msgID, String.valueOf(mapperDN), String.valueOf(config.dn()));
                unacceptableReasons.add(message);
                return false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245553;
            String message = MessageHandler.getMessage(msgID, String.valueOf(config.dn()), StaticUtils.getExceptionMessage(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PasswordModifyExtendedOperationHandlerCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        DN mapperDN = null;
        IdentityMapper mapper = null;
        try {
            mapperDN = config.getIdentityMapperDN();
            mapper = DirectoryServer.getIdentityMapper(mapperDN);
            if (mapper == null) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                int msgID = 1245552;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(mapperDN), String.valueOf(config.dn())));
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            resultCode = DirectoryServer.getServerErrorResultCode();
            int msgID = 1245553;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(config.dn()), StaticUtils.getExceptionMessage(e)));
        }
        if (resultCode == ResultCode.SUCCESS && !this.identityMapperDN.equals(mapperDN)) {
            this.identityMapper = mapper;
            this.identityMapperDN = mapperDN;
        }
        this.currentConfig = config;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

