/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaltedSHA512PasswordStorageScheme
extends PasswordStorageScheme<PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.SaltedSHA512PasswordStorageScheme";
    private static final int NUM_SALT_BYTES = 8;
    private MessageDigest messageDigest;
    private ReentrantLock digestLock;
    private SecureRandom random;

    @Override
    public void initializePasswordStorageScheme(PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-512");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 0x140001;
            String message = MessageHandler.getMessage(msgID, "SHA-512", String.valueOf(e));
            throw new InitializationException(msgID, message, e);
        }
        this.digestLock = new ReentrantLock();
        this.random = new SecureRandom();
    }

    @Override
    public String getStorageSchemeName() {
        return "SSHA512";
    }

    @Override
    public ByteString encodePassword(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        byte[] plainBytes = plaintext.value();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plainBytes.length + 8];
        System.arraycopy(plainBytes, 0, plainPlusSalt, 0, plainBytes.length);
        this.digestLock.lock();
        try {
            this.random.nextBytes(saltBytes);
            System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytes.length, 8);
            digestBytes = this.messageDigest.digest(plainPlusSalt);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245189;
            String message = MessageHandler.getMessage(msgID, CLASS_NAME, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        finally {
            this.digestLock.unlock();
        }
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        return ByteStringFactory.create(Base64.encode(hashPlusSalt));
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("SSHA512");
        buffer.append('}');
        byte[] plainBytes = plaintext.value();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plainBytes.length + 8];
        System.arraycopy(plainBytes, 0, plainPlusSalt, 0, plainBytes.length);
        this.digestLock.lock();
        try {
            this.random.nextBytes(saltBytes);
            System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytes.length, 8);
            digestBytes = this.messageDigest.digest(plainPlusSalt);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245189;
            String message = MessageHandler.getMessage(msgID, CLASS_NAME, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        finally {
            this.digestLock.unlock();
        }
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        buffer.append(Base64.encode(hashPlusSalt));
        return ByteStringFactory.create(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passwordMatches(ByteString plaintextPassword, ByteString storedPassword) {
        byte[] userDigestBytes;
        byte[] digestBytes;
        byte[] saltBytes = new byte[8];
        try {
            byte[] decodedBytes = Base64.decode(storedPassword.stringValue());
            int digestLength = decodedBytes.length - 8;
            digestBytes = new byte[digestLength];
            System.arraycopy(decodedBytes, 0, digestBytes, 0, digestLength);
            System.arraycopy(decodedBytes, digestLength, saltBytes, 0, 8);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245186;
            String message = MessageHandler.getMessage(msgID, storedPassword.stringValue(), String.valueOf(e));
            ErrorLogger.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.MILD_ERROR, message, msgID);
            return false;
        }
        byte[] plainBytes = plaintextPassword.value();
        byte[] plainPlusSalt = new byte[plainBytes.length + 8];
        System.arraycopy(plainBytes, 0, plainPlusSalt, 0, plainBytes.length);
        System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytes.length, 8);
        this.digestLock.lock();
        try {
            userDigestBytes = this.messageDigest.digest(plainPlusSalt);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.digestLock.unlock();
        }
        return Arrays.equals(digestBytes, userDigestBytes);
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return true;
    }

    @Override
    public String getAuthPasswordSchemeName() {
        return "SHA512";
    }

    @Override
    public ByteString encodeAuthPassword(ByteString plaintext) throws DirectoryException {
        byte[] digestBytes;
        byte[] plainBytes = plaintext.value();
        byte[] saltBytes = new byte[8];
        byte[] plainPlusSalt = new byte[plainBytes.length + 8];
        System.arraycopy(plainBytes, 0, plainPlusSalt, 0, plainBytes.length);
        this.digestLock.lock();
        try {
            this.random.nextBytes(saltBytes);
            System.arraycopy(saltBytes, 0, plainPlusSalt, plainBytes.length, 8);
            digestBytes = this.messageDigest.digest(plainPlusSalt);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245189;
            String message = MessageHandler.getMessage(msgID, CLASS_NAME, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        finally {
            this.digestLock.unlock();
        }
        StringBuilder authPWValue = new StringBuilder();
        authPWValue.append("SHA512");
        authPWValue.append('$');
        authPWValue.append(Base64.encode(saltBytes));
        authPWValue.append('$');
        authPWValue.append(Base64.encode(digestBytes));
        return ByteStringFactory.create(authPWValue.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authPasswordMatches(ByteString plaintextPassword, String authInfo, String authValue) {
        byte[] digestBytes;
        byte[] saltBytes;
        try {
            saltBytes = Base64.decode(authInfo);
            digestBytes = Base64.decode(authValue);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
        byte[] plainBytes = plaintextPassword.value();
        byte[] plainPlusSaltBytes = new byte[plainBytes.length + saltBytes.length];
        System.arraycopy(plainBytes, 0, plainPlusSaltBytes, 0, plainBytes.length);
        System.arraycopy(saltBytes, 0, plainPlusSaltBytes, plainBytes.length, saltBytes.length);
        this.digestLock.lock();
        try {
            boolean bl = Arrays.equals(digestBytes, this.messageDigest.digest(plainPlusSaltBytes));
            return bl;
        }
        finally {
            this.digestLock.unlock();
        }
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public ByteString getPlaintextValue(ByteString storedPassword) throws DirectoryException {
        int msgID = 0x130003;
        String message = MessageHandler.getMessage(msgID, "SSHA512");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        int msgID = 0x130003;
        String message = MessageHandler.getMessage(msgID, "SHA512");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return true;
    }

    public static String encodeOffline(byte[] passwordBytes) throws DirectoryException {
        MessageDigest messageDigest;
        byte[] saltBytes = new byte[8];
        new SecureRandom().nextBytes(saltBytes);
        byte[] passwordPlusSalt = new byte[passwordBytes.length + 8];
        System.arraycopy(passwordBytes, 0, passwordPlusSalt, 0, passwordBytes.length);
        System.arraycopy(saltBytes, 0, passwordPlusSalt, passwordBytes.length, 8);
        try {
            messageDigest = MessageDigest.getInstance("SHA-512");
        }
        catch (Exception e) {
            int msgID = 0x140001;
            String message = MessageHandler.getMessage(msgID, "SHA-512", String.valueOf(e));
            throw new DirectoryException(ResultCode.OTHER, message, msgID, e);
        }
        byte[] digestBytes = messageDigest.digest(passwordPlusSalt);
        byte[] digestPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, digestPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, digestPlusSalt, digestBytes.length, 8);
        return "{SSHA512}" + Base64.encode(digestPlusSalt);
    }
}

