/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.SoftReferenceEntryCacheCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.EntryCache;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.EntryCacheCommon;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.CacheEntry;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.SearchFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftReferenceEntryCache
extends EntryCache<SoftReferenceEntryCacheCfg>
implements ConfigurationChangeListener<SoftReferenceEntryCacheCfg>,
Runnable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final LinkedHashMap<String, Double> timeUnits = new LinkedHashMap();
    private ConcurrentHashMap<DN, SoftReference<CacheEntry>> dnMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Backend, ConcurrentHashMap<Long, SoftReference<CacheEntry>>> idMap = new ConcurrentHashMap();
    private DN configEntryDN;
    private ReferenceQueue<CacheEntry> referenceQueue;

    public SoftReferenceEntryCache() {
        this.excludeFilters = new HashSet();
        this.includeFilters = new HashSet();
        this.lockTimeout = 3000L;
        this.referenceQueue = new ReferenceQueue();
        Thread cleanerThread = new Thread((Runnable)this, "Soft Reference Entry Cache Cleaner");
        cleanerThread.setDaemon(true);
        cleanerThread.start();
    }

    @Override
    public void initializeEntryCache(SoftReferenceEntryCacheCfg configuration) throws ConfigException, InitializationException {
        configuration.addSoftReferenceChangeListener(this);
        this.configEntryDN = configuration.dn();
        this.dnMap.clear();
        this.idMap.clear();
        boolean applyChanges = true;
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_INIT, null, null);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
    }

    @Override
    public void finalizeEntryCache() {
        this.dnMap.clear();
        this.idMap.clear();
    }

    @Override
    public boolean containsEntry(DN entryDN) {
        return this.dnMap.containsKey(entryDN);
    }

    @Override
    public Entry getEntry(DN entryDN) {
        SoftReference<CacheEntry> ref = this.dnMap.get(entryDN);
        if (ref == null) {
            return null;
        }
        CacheEntry cacheEntry = ref.get();
        if (cacheEntry == null) {
            return null;
        }
        return cacheEntry.getEntry();
    }

    @Override
    public long getEntryID(DN entryDN) {
        SoftReference<CacheEntry> ref = this.dnMap.get(entryDN);
        if (ref == null) {
            return -1L;
        }
        CacheEntry cacheEntry = ref.get();
        if (cacheEntry == null) {
            return -1L;
        }
        return cacheEntry.getEntryID();
    }

    @Override
    protected DN getEntryDN(Backend backend, long entryID) {
        SoftReference<CacheEntry> ref;
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> backendMap = this.idMap.get(backend);
        if (backendMap != null && (ref = backendMap.get(entryID)) != null && ref.get() != null) {
            return ref.get().getDN();
        }
        return null;
    }

    @Override
    public void putEntry(Entry entry, Backend backend, long entryID) {
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> map;
        if (!this.filtersAllowCaching(entry)) {
            return;
        }
        CacheEntry cacheEntry = new CacheEntry(entry, backend, entryID);
        SoftReference<CacheEntry> ref = new SoftReference<CacheEntry>(cacheEntry, this.referenceQueue);
        SoftReference<CacheEntry> oldRef = this.dnMap.put(entry.getDN(), ref);
        if (oldRef != null) {
            oldRef.clear();
        }
        if ((map = this.idMap.get(backend)) == null) {
            map = new ConcurrentHashMap();
            map.put(entryID, ref);
        } else {
            oldRef = map.put(entryID, ref);
            if (oldRef != null) {
                oldRef.clear();
            }
        }
    }

    @Override
    public boolean putEntryIfAbsent(Entry entry, Backend backend, long entryID) {
        if (!this.filtersAllowCaching(entry)) {
            return true;
        }
        if (this.dnMap.containsKey(entry.getDN())) {
            return false;
        }
        CacheEntry cacheEntry = new CacheEntry(entry, backend, entryID);
        SoftReference<CacheEntry> ref = new SoftReference<CacheEntry>(cacheEntry, this.referenceQueue);
        this.dnMap.put(entry.getDN(), ref);
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> map = this.idMap.get(backend);
        if (map == null) {
            map = new ConcurrentHashMap();
            map.put(entryID, ref);
            this.idMap.put(backend, map);
        } else {
            map.put(entryID, ref);
        }
        return true;
    }

    @Override
    public void removeEntry(DN entryDN) {
        SoftReference<CacheEntry> ref = this.dnMap.remove(entryDN);
        if (ref != null) {
            Backend backend;
            ConcurrentHashMap<Long, SoftReference<CacheEntry>> map;
            ref.clear();
            CacheEntry cacheEntry = ref.get();
            if (cacheEntry != null && (map = this.idMap.get(backend = cacheEntry.getBackend())) != null && (ref = map.remove(cacheEntry.getEntryID())) != null) {
                ref.clear();
            }
        }
    }

    @Override
    public void clear() {
        this.dnMap.clear();
        this.idMap.clear();
    }

    @Override
    public void clearBackend(Backend backend) {
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> map = this.idMap.remove(backend);
        if (map != null) {
            for (SoftReference<CacheEntry> ref : map.values()) {
                CacheEntry cacheEntry = ref.get();
                if (cacheEntry != null) {
                    this.dnMap.remove(cacheEntry.getDN());
                }
                ref.clear();
            }
            map.clear();
        }
    }

    @Override
    public void clearSubtree(DN baseDN) {
        Backend backend = DirectoryServer.getBackend(baseDN);
        if (backend == null) {
            return;
        }
        this.clearBackend(backend);
    }

    @Override
    public void handleLowMemory() {
    }

    @Override
    public boolean isConfigurationAcceptable(EntryCacheCfg configuration, List<String> unacceptableReasons) {
        SoftReferenceEntryCacheCfg config = (SoftReferenceEntryCacheCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SoftReferenceEntryCacheCfg configuration, List<String> unacceptableReasons) {
        boolean applyChanges = false;
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_ACCEPTABLE, unacceptableReasons, null);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        return errorHandler.getIsAcceptable();
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SoftReferenceEntryCacheCfg configuration) {
        boolean applyChanges = false;
        ArrayList<String> errorMessages = new ArrayList<String>();
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_APPLY, null, errorMessages);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        boolean adminActionRequired = false;
        ConfigChangeResult changeResult = new ConfigChangeResult(errorHandler.getResultCode(), adminActionRequired, errorHandler.getErrorMessages());
        return changeResult;
    }

    public boolean processEntryCacheConfig(SoftReferenceEntryCacheCfg configuration, boolean applyChanges, EntryCacheCommon.ConfigErrorHandler errorHandler) {
        HashSet<SearchFilter> newIncludeFilters = null;
        HashSet<SearchFilter> newExcludeFilters = null;
        DN newConfigEntryDN = configuration.dn();
        long newLockTimeout = configuration.getLockTimeout();
        switch (errorHandler.getConfigPhase()) {
            case PHASE_INIT: {
                newIncludeFilters = EntryCacheCommon.getFilters(configuration.getIncludeFilter(), 1311009, 1179930, errorHandler, newConfigEntryDN);
                newExcludeFilters = EntryCacheCommon.getFilters(configuration.getExcludeFilter(), 1179933, 1179934, errorHandler, newConfigEntryDN);
                break;
            }
            case PHASE_ACCEPTABLE: 
            case PHASE_APPLY: {
                newIncludeFilters = EntryCacheCommon.getFilters(configuration.getIncludeFilter(), 1311009, 0, errorHandler, newConfigEntryDN);
                newExcludeFilters = EntryCacheCommon.getFilters(configuration.getExcludeFilter(), 1311011, 0, errorHandler, newConfigEntryDN);
            }
        }
        if (applyChanges && errorHandler.getIsAcceptable()) {
            this.configEntryDN = newConfigEntryDN;
            this.lockTimeout = newLockTimeout;
            this.includeFilters = newIncludeFilters;
            this.excludeFilters = newExcludeFilters;
        }
        return errorHandler.getIsAcceptable();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    SoftReference<CacheEntry> ref;
                    CacheEntry freedEntry;
                    if ((freedEntry = this.referenceQueue.remove().get()) == null || (ref = this.dnMap.remove(freedEntry.getDN())) == null) {
                        continue;
                    }
                    CacheEntry removedEntry = ref.get();
                    if (removedEntry != freedEntry) {
                        this.dnMap.putIfAbsent(freedEntry.getDN(), ref);
                        continue;
                    }
                    ref.clear();
                    ConcurrentHashMap<Long, SoftReference<CacheEntry>> map = this.idMap.get(freedEntry.getBackend());
                    if (map == null || (ref = map.remove(freedEntry.getEntryID())) == null) continue;
                    ref.clear();
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                continue;
            }
            break;
        }
    }

    static {
        timeUnits.put("ms", 1.0);
        timeUnits.put("milliseconds", 1.0);
        timeUnits.put("s", 1000.0);
        timeUnits.put("seconds", 1000.0);
    }
}

