/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.admin.std.server.GroupImplementationCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.Group;
import org.opends.server.config.ConfigException;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.extensions.FilteredStaticGroupMemberList;
import org.opends.server.extensions.SimpleStaticGroupMemberList;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.MemberList;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticGroup
extends Group<GroupImplementationCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType memberAttributeType;
    private DN groupEntryDN;
    private LinkedHashSet<DN> memberDNs;

    public StaticGroup() {
    }

    public StaticGroup(DN groupEntryDN, AttributeType memberAttributeType, LinkedHashSet<DN> memberDNs) {
        Validator.ensureNotNull(groupEntryDN, memberAttributeType, memberDNs);
        this.groupEntryDN = groupEntryDN;
        this.memberAttributeType = memberAttributeType;
        this.memberDNs = memberDNs;
    }

    @Override
    public void initializeGroupImplementation(GroupImplementationCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public StaticGroup newInstance(Entry groupEntry) throws DirectoryException {
        AttributeType memberAttributeType;
        Validator.ensureNotNull(groupEntry);
        ObjectClass groupOfNamesClass = DirectoryConfig.getObjectClass("groupofnames", true);
        ObjectClass groupOfUniqueNamesClass = DirectoryConfig.getObjectClass("groupofuniquenames", true);
        if (groupEntry.hasObjectClass(groupOfNamesClass)) {
            if (groupEntry.hasObjectClass(groupOfUniqueNamesClass)) {
                int msgID = 1245569;
                String message = MessageHandler.getMessage(msgID, String.valueOf(groupEntry.getDN()), "groupOfNames", "groupOfUniqueNames");
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message, msgID);
            }
            memberAttributeType = DirectoryConfig.getAttributeType("member", true);
        } else if (groupEntry.hasObjectClass(groupOfUniqueNamesClass)) {
            memberAttributeType = DirectoryConfig.getAttributeType("uniquemember", true);
        } else {
            int msgID = 1245570;
            String message = MessageHandler.getMessage(msgID, String.valueOf(groupEntry.getDN()), "groupOfNames", "groupOfUniqueNames");
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message, msgID);
        }
        LinkedHashSet<DN> memberDNs = new LinkedHashSet<DN>();
        List<Attribute> memberAttrList = groupEntry.getAttribute(memberAttributeType);
        if (memberAttrList != null) {
            for (Attribute a : memberAttrList) {
                for (AttributeValue v : a.getValues()) {
                    try {
                        DN memberDN = DN.decode(v.getValue());
                        memberDNs.add(memberDN);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        int msgID = 1245571;
                        String message = MessageHandler.getMessage(msgID, v.getStringValue(), memberAttributeType.getNameOrOID(), String.valueOf(groupEntry.getDN()), de.getErrorMessage());
                        ErrorLogger.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.MILD_ERROR, message, msgID);
                    }
                }
            }
        }
        return new StaticGroup(groupEntry.getDN(), memberAttributeType, memberDNs);
    }

    @Override
    public SearchFilter getGroupDefinitionFilter() throws DirectoryException {
        String filterString = "(&(|(objectClass=groupOfNames)(objectClass=groupOfUniqueNames))(!(objectClass=ds-virtual-static-group)))";
        return SearchFilter.createFilterFromString(filterString);
    }

    @Override
    public boolean isGroupDefinition(Entry entry) {
        Validator.ensureNotNull(entry);
        ObjectClass virtualStaticGroupClass = DirectoryConfig.getObjectClass("ds-virtual-static-group", true);
        if (entry.hasObjectClass(virtualStaticGroupClass)) {
            return false;
        }
        ObjectClass groupOfNamesClass = DirectoryConfig.getObjectClass("groupofnames", true);
        ObjectClass groupOfUniqueNamesClass = DirectoryConfig.getObjectClass("groupofuniquenames", true);
        if (entry.hasObjectClass(groupOfNamesClass)) {
            return !entry.hasObjectClass(groupOfUniqueNamesClass);
        }
        return entry.hasObjectClass(groupOfUniqueNamesClass);
    }

    @Override
    public DN getGroupDN() {
        return this.groupEntryDN;
    }

    @Override
    public boolean supportsNestedGroups() {
        return false;
    }

    @Override
    public List<DN> getNestedGroupDNs() {
        return Collections.emptyList();
    }

    @Override
    public void addNestedGroup(DN nestedGroupDN) throws UnsupportedOperationException, DirectoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNestedGroup(DN nestedGroupDN) throws UnsupportedOperationException, DirectoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMember(DN userDN) throws DirectoryException {
        return this.memberDNs.contains(userDN);
    }

    @Override
    public boolean isMember(Entry userEntry) throws DirectoryException {
        return this.memberDNs.contains(userEntry.getDN());
    }

    @Override
    public MemberList getMembers() throws DirectoryException {
        return new SimpleStaticGroupMemberList(this.groupEntryDN, this.memberDNs);
    }

    @Override
    public MemberList getMembers(DN baseDN, SearchScope scope, SearchFilter filter) throws DirectoryException {
        if (baseDN == null && filter == null) {
            return new SimpleStaticGroupMemberList(this.groupEntryDN, this.memberDNs);
        }
        return new FilteredStaticGroupMemberList(this.groupEntryDN, this.memberDNs, baseDN, scope, filter);
    }

    @Override
    public boolean mayAlterMemberList() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMember(Entry userEntry) throws UnsupportedOperationException, DirectoryException {
        Validator.ensureNotNull(userEntry);
        StaticGroup staticGroup = this;
        synchronized (staticGroup) {
            DN userDN = userEntry.getDN();
            if (this.memberDNs.contains(userDN)) {
                int msgID = 1245572;
                String message = MessageHandler.getMessage(msgID, String.valueOf(userDN), String.valueOf(this.groupEntryDN));
                throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, message, msgID);
            }
            LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
            values.add(new AttributeValue(this.memberAttributeType, userDN.toString()));
            Attribute attr = new Attribute(this.memberAttributeType, this.memberAttributeType.getNameOrOID(), values);
            LinkedList<Modification> mods = new LinkedList<Modification>();
            mods.add(new Modification(ModificationType.ADD, attr));
            LinkedList<Control> requestControls = new LinkedList<Control>();
            requestControls.add(new Control("1.3.6.1.4.1.26027.1.5.1", false));
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            ModifyOperationBasis modifyOperation = new ModifyOperationBasis((ClientConnection)conn, conn.nextOperationID(), conn.nextMessageID(), requestControls, this.groupEntryDN, mods);
            modifyOperation.run();
            if (modifyOperation.getResultCode() != ResultCode.SUCCESS) {
                int msgID = 1245574;
                String message = MessageHandler.getMessage(msgID, String.valueOf(userDN), String.valueOf(this.groupEntryDN), modifyOperation.getErrorMessage().toString());
                throw new DirectoryException(modifyOperation.getResultCode(), message, msgID);
            }
            LinkedHashSet<DN> newMemberDNs = new LinkedHashSet<DN>(this.memberDNs.size() + 1);
            newMemberDNs.addAll(this.memberDNs);
            newMemberDNs.add(userDN);
            this.memberDNs = newMemberDNs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMember(DN userDN) throws UnsupportedOperationException, DirectoryException {
        Validator.ensureNotNull(userDN);
        StaticGroup staticGroup = this;
        synchronized (staticGroup) {
            if (!this.memberDNs.contains(userDN)) {
                int msgID = 1245573;
                String message = MessageHandler.getMessage(msgID, String.valueOf(userDN), String.valueOf(this.groupEntryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, message, msgID);
            }
            LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
            values.add(new AttributeValue(this.memberAttributeType, userDN.toString()));
            Attribute attr = new Attribute(this.memberAttributeType, this.memberAttributeType.getNameOrOID(), values);
            LinkedList<Modification> mods = new LinkedList<Modification>();
            mods.add(new Modification(ModificationType.DELETE, attr));
            LinkedList<Control> requestControls = new LinkedList<Control>();
            requestControls.add(new Control("1.3.6.1.4.1.26027.1.5.1", false));
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            ModifyOperationBasis modifyOperation = new ModifyOperationBasis((ClientConnection)conn, conn.nextOperationID(), conn.nextMessageID(), requestControls, this.groupEntryDN, mods);
            modifyOperation.run();
            if (modifyOperation.getResultCode() != ResultCode.SUCCESS) {
                int msgID = 1245575;
                String message = MessageHandler.getMessage(msgID, String.valueOf(userDN), String.valueOf(this.groupEntryDN), modifyOperation.getErrorMessage().toString());
                throw new DirectoryException(modifyOperation.getResultCode(), message, msgID);
            }
            LinkedHashSet<DN> newMemberDNs = new LinkedHashSet<DN>(this.memberDNs);
            newMemberDNs.remove(userDN);
            this.memberDNs = newMemberDNs;
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("StaticGroup(");
        buffer.append(this.groupEntryDN);
        buffer.append(")");
    }
}

