/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CertificateMapperCfg;
import org.opends.server.admin.std.server.SubjectDNToUserAttributeCertificateMapperCfg;
import org.opends.server.api.CertificateMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectDNToUserAttributeCertificateMapper
extends CertificateMapper<SubjectDNToUserAttributeCertificateMapperCfg>
implements ConfigurationChangeListener<SubjectDNToUserAttributeCertificateMapperCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType subjectAttributeType;
    private DN configEntryDN;
    private SubjectDNToUserAttributeCertificateMapperCfg currentConfig;

    @Override
    public void initializeCertificateMapper(SubjectDNToUserAttributeCertificateMapperCfg configuration) throws ConfigException, InitializationException {
        configuration.addSubjectDNToUserAttributeChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        String attrName = configuration.getSubjectAttribute();
        this.subjectAttributeType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(attrName), false);
        if (this.subjectAttributeType == null) {
            int msgID = 1311133;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), attrName);
            throw new ConfigException(msgID, message);
        }
    }

    @Override
    public void finalizeCertificateMapper() {
        this.currentConfig.removeSubjectDNToUserAttributeChangeListener(this);
    }

    @Override
    public Entry mapCertificateToUser(Certificate[] certificateChain) throws DirectoryException {
        X509Certificate peerCertificate;
        SubjectDNToUserAttributeCertificateMapperCfg config = this.currentConfig;
        AttributeType subjectAttributeType = this.subjectAttributeType;
        if (certificateChain == null || certificateChain.length == 0) {
            int msgID = 1311137;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
        }
        try {
            peerCertificate = (X509Certificate)certificateChain[0];
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1311138;
            String message = MessageHandler.getMessage(msgID, String.valueOf(certificateChain[0].getType()));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
        }
        X500Principal peerPrincipal = peerCertificate.getSubjectX500Principal();
        String peerName = peerPrincipal.getName("RFC2253");
        AttributeValue value = new AttributeValue(subjectAttributeType, peerName);
        SearchFilter filter = SearchFilter.createEqualityFilter(subjectAttributeType, value);
        Set<DN> baseDNs = config.getUserBaseDN();
        if (baseDNs == null || baseDNs.isEmpty()) {
            baseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        SearchResultEntry userEntry = null;
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        for (DN baseDN : baseDNs) {
            InternalSearchOperation searchOperation = conn.processSearch(baseDN, SearchScope.WHOLE_SUBTREE, filter);
            for (SearchResultEntry entry : searchOperation.getSearchEntries()) {
                if (userEntry == null) {
                    userEntry = entry;
                    continue;
                }
                int msgID = 1311139;
                String message = MessageHandler.getMessage(msgID, peerName, String.valueOf(userEntry.getDN()), String.valueOf(entry.getDN()));
                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
            }
        }
        return userEntry;
    }

    @Override
    public boolean isConfigurationAcceptable(CertificateMapperCfg configuration, List<String> unacceptableReasons) {
        SubjectDNToUserAttributeCertificateMapperCfg config = (SubjectDNToUserAttributeCertificateMapperCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SubjectDNToUserAttributeCertificateMapperCfg configuration, List<String> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        String attrName = configuration.getSubjectAttribute();
        AttributeType newSubjectType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(attrName), false);
        if (newSubjectType == null) {
            unacceptableReasons.add(MessageHandler.getMessage(1311133, String.valueOf(cfgEntryDN), attrName));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SubjectDNToUserAttributeCertificateMapperCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        String attrName = configuration.getSubjectAttribute();
        AttributeType newSubjectType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(attrName), false);
        if (newSubjectType == null) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.NO_SUCH_ATTRIBUTE;
            }
            messages.add(MessageHandler.getMessage(1311133, String.valueOf(this.configEntryDN), attrName));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.subjectAttributeType = newSubjectType;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

