/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.locks.Lock;
import javax.security.auth.x500.X500Principal;
import org.opends.server.admin.std.server.CertificateMapperCfg;
import org.opends.server.api.CertificateMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectEqualsDNCertificateMapper
extends CertificateMapper<CertificateMapperCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeCertificateMapper(CertificateMapperCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public Entry mapCertificateToUser(Certificate[] certificateChain) throws DirectoryException {
        Entry userEntry;
        DN subjectDN;
        X509Certificate peerCertificate;
        if (certificateChain == null || certificateChain.length == 0) {
            int msgID = 1245302;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
        }
        try {
            peerCertificate = (X509Certificate)certificateChain[0];
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245303;
            String message = MessageHandler.getMessage(msgID, String.valueOf(certificateChain[0].getType()));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
        }
        X500Principal peerPrincipal = peerCertificate.getSubjectX500Principal();
        try {
            subjectDN = DN.decode(peerPrincipal.getName("RFC2253"));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245304;
            String message = MessageHandler.getMessage(msgID, String.valueOf(peerPrincipal), StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
        }
        Lock readLock = null;
        for (int i = 0; i < 3 && (readLock = LockManager.lockRead(subjectDN)) == null; ++i) {
        }
        if (readLock == null) {
            int msgID = 1245348;
            String message = MessageHandler.getMessage(msgID, String.valueOf(subjectDN));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
        }
        try {
            userEntry = DirectoryServer.getEntry(subjectDN);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            int msgID = 1245305;
            String message = MessageHandler.getMessage(msgID, String.valueOf(subjectDN), de.getErrorMessage());
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID, de);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 1245305;
            String message = MessageHandler.getMessage(msgID, String.valueOf(subjectDN), StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID, e);
        }
        finally {
            LockManager.unlock(subjectDN, readLock);
        }
        if (userEntry == null) {
            int msgID = 1245306;
            String message = MessageHandler.getMessage(msgID, String.valueOf(subjectDN));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, msgID);
        }
        return userEntry;
    }
}

