/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.admin.std.server.VirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubschemaSubentryVirtualAttributeProvider
extends VirtualAttributeProvider<VirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeVirtualAttributeProvider(VirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public LinkedHashSet<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
        values.add(new AttributeValue(rule.getAttributeType(), DirectoryServer.getSchemaDN().toString()));
        return values;
    }

    @Override
    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult lessThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
        int msgID = 1245643;
        String message = MessageHandler.getMessage(msgID, rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
    }
}

