/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.UniqueCharactersPasswordValidatorCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueCharactersPasswordValidator
extends PasswordValidator<UniqueCharactersPasswordValidatorCfg>
implements ConfigurationChangeListener<UniqueCharactersPasswordValidatorCfg> {
    private UniqueCharactersPasswordValidatorCfg currentConfig;

    @Override
    public void initializePasswordValidator(UniqueCharactersPasswordValidatorCfg configuration) {
        configuration.addUniqueCharactersChangeListener(this);
        this.currentConfig = configuration;
    }

    @Override
    public void finalizePasswordValidator() {
        this.currentConfig.removeUniqueCharactersChangeListener(this);
    }

    @Override
    public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, StringBuilder invalidReason) {
        UniqueCharactersPasswordValidatorCfg config = this.currentConfig;
        int minUniqueCharacters = config.getMinimumUniqueCharacters();
        if (minUniqueCharacters <= 0) {
            return true;
        }
        HashSet<Character> passwordCharacters = new HashSet<Character>();
        String passwordString = newPassword.stringValue();
        if (!config.isCaseSensitiveValidation()) {
            passwordString = passwordString.toLowerCase();
        }
        for (int i = 0; i < passwordString.length(); ++i) {
            passwordCharacters.add(Character.valueOf(passwordString.charAt(i)));
        }
        if (passwordCharacters.size() < minUniqueCharacters) {
            int msgID = 1245642;
            String message = MessageHandler.getMessage(msgID, minUniqueCharacters);
            invalidReason.append(message);
            return false;
        }
        return true;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(UniqueCharactersPasswordValidatorCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(UniqueCharactersPasswordValidatorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        this.currentConfig = configuration;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

