/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.UserDefinedVirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefinedVirtualAttributeProvider
extends VirtualAttributeProvider<UserDefinedVirtualAttributeCfg>
implements ConfigurationChangeListener<UserDefinedVirtualAttributeCfg> {
    private UserDefinedVirtualAttributeCfg currentConfig;

    @Override
    public void initializeVirtualAttributeProvider(UserDefinedVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
        this.currentConfig = configuration;
        configuration.addUserDefinedChangeListener(this);
    }

    @Override
    public void finalizeVirtualAttributeProvider() {
        this.currentConfig.removeUserDefinedChangeListener(this);
    }

    @Override
    public boolean isMultiValued() {
        if (this.currentConfig == null) {
            return true;
        }
        return this.currentConfig.getValue().size() > 1;
    }

    @Override
    public LinkedHashSet<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        AttributeType attributeType = rule.getAttributeType();
        SortedSet<String> userDefinedValues = this.currentConfig.getValue();
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(userDefinedValues.size());
        for (String valueString : userDefinedValues) {
            values.add(new AttributeValue(attributeType, valueString));
        }
        return values;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(UserDefinedVirtualAttributeCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(UserDefinedVirtualAttributeCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

