/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.interop;

import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.RDN;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

public class LazyDN
extends DN {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final long serialVersionUID = -7461952029886247893L;
    private DN decodedDN;
    private String dnString;

    public LazyDN(String dnString) {
        this.dnString = dnString;
        this.decodedDN = null;
    }

    public boolean isNullDN() throws RuntimeException {
        return this.getDecodedDN().isNullDN();
    }

    public int getNumComponents() throws RuntimeException {
        return this.getDecodedDN().getNumComponents();
    }

    public RDN getRDN() throws RuntimeException {
        return this.getDecodedDN().getRDN();
    }

    public RDN getRDN(int pos) throws RuntimeException {
        return this.getDecodedDN().getRDN(pos);
    }

    public DN getParent() throws RuntimeException {
        return this.getDecodedDN().getParent();
    }

    public DN getParentDNInSuffix() throws RuntimeException {
        return this.getDecodedDN().getParentDNInSuffix();
    }

    public DN concat(RDN rdn) throws RuntimeException {
        return this.getDecodedDN().concat(rdn);
    }

    public DN concat(RDN[] rdnComponents) throws RuntimeException {
        return this.getDecodedDN().concat(rdnComponents);
    }

    public DN concat(DN relativeBaseDN) throws RuntimeException {
        return this.getDecodedDN().concat(relativeBaseDN);
    }

    public boolean isDescendantOf(DN dn) throws RuntimeException {
        return this.getDecodedDN().isDescendantOf(dn);
    }

    public boolean isAncestorOf(DN dn) throws RuntimeException {
        return this.getDecodedDN().isAncestorOf(dn);
    }

    public boolean matchesBaseAndScope(DN baseDN, SearchScope scope) throws RuntimeException {
        return this.getDecodedDN().matchesBaseAndScope(baseDN, scope);
    }

    public boolean equals(Object o) throws RuntimeException {
        return this.getDecodedDN().equals(o);
    }

    public int hashCode() throws RuntimeException {
        return this.getDecodedDN().hashCode();
    }

    public String toString() {
        return this.dnString;
    }

    public void toString(StringBuilder buffer) {
        buffer.append(this.dnString);
    }

    public String toNormalizedString() throws RuntimeException {
        return this.getDecodedDN().toNormalizedString();
    }

    public void toNormalizedString(StringBuilder buffer) throws RuntimeException {
        this.getDecodedDN().toNormalizedString(buffer);
    }

    public int compareTo(DN dn) throws RuntimeException {
        return this.getDecodedDN().compareTo(dn);
    }

    private DN getDecodedDN() throws RuntimeException {
        if (this.decodedDN == null) {
            try {
                this.decodedDN = DN.decode(this.dnString);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                throw new RuntimeException(StaticUtils.stackTraceToSingleLineString(e));
            }
        }
        return this.decodedDN;
    }
}

