/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.SizeLimitLogRotationPolicyCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ActionType;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.FileNamingPolicy;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MeteredStream;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.SizeBasedRotationPolicy;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.FilePermission;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultifileTextWriter
implements ServerShutdownListener,
TextWriter,
ConfigurationChangeListener<SizeLimitLogRotationPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String UTF8_ENCODING = "UTF-8";
    private CopyOnWriteArrayList<RotationPolicy> rotationPolicies = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<RetentionPolicy> retentionPolicies = new CopyOnWriteArrayList();
    private FileNamingPolicy namingPolicy;
    private FilePermission filePermissions;
    private LogPublisherErrorHandler errorHandler;
    private ArrayList<ActionType> actions;
    private String name;
    private String encoding;
    private int bufferSize;
    private boolean autoFlush;
    private boolean append;
    private long interval;
    private boolean stopRequested;
    private long sizeLimit = 0L;
    private Thread rotaterThread;
    private long lastRotationTime = TimeThread.getTime();
    private long lastCleanTime = TimeThread.getTime();
    private long lastCleanCount = 0L;
    private long totalFilesRotated = 0L;
    private long totalFilesCleaned = 0L;
    private MeteredStream outputStream;
    private BufferedWriter writer;

    public MultifileTextWriter(String name, long interval, FileNamingPolicy namingPolicy, FilePermission filePermissions, LogPublisherErrorHandler errorHandler, String encoding, boolean autoFlush, boolean append, int bufferSize) throws IOException, DirectoryException {
        File file = namingPolicy.getInitialName();
        this.constructWriter(file, filePermissions, encoding, append, bufferSize);
        this.name = name;
        this.interval = interval;
        this.namingPolicy = namingPolicy;
        this.filePermissions = filePermissions;
        this.errorHandler = errorHandler;
        this.encoding = UTF8_ENCODING;
        this.autoFlush = autoFlush;
        this.append = append;
        this.bufferSize = bufferSize;
        this.stopRequested = false;
        this.rotaterThread = new RotaterThread(this);
        this.rotaterThread.start();
        DirectoryServer.registerShutdownListener(this);
    }

    private void constructWriter(File file, FilePermission filePermissions, String encoding, boolean append, int bufferSize) throws IOException, DirectoryException {
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream stream = new FileOutputStream(file, append);
        this.outputStream = new MeteredStream(stream, 0L);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)this.outputStream, encoding);
        Object bw = null;
        this.writer = bufferSize <= 0 ? new BufferedWriter(osw) : new BufferedWriter(osw, bufferSize);
        if (FilePermission.canSetPermissions()) {
            try {
                if (!FilePermission.setPermissions(file, filePermissions)) {
                    int msgID = 4259849;
                    String message = MessageHandler.getMessage(msgID, filePermissions.toString(), file.toString());
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_WARNING, message, msgID);
                }
            }
            catch (Exception e) {
                int msgID = 4325384;
                String message = MessageHandler.getMessage(msgID, file.toString(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
            }
        }
    }

    public void addRotationPolicy(RotationPolicy policy) {
        this.rotationPolicies.add(policy);
        if (policy instanceof SizeBasedRotationPolicy) {
            SizeBasedRotationPolicy sizePolicy = (SizeBasedRotationPolicy)policy;
            if (this.sizeLimit == 0L || this.sizeLimit > sizePolicy.currentConfig.getFileSizeLimit()) {
                this.sizeLimit = sizePolicy.currentConfig.getFileSizeLimit();
            }
            sizePolicy.currentConfig.addSizeLimitChangeListener(this);
        }
    }

    public void addRetentionPolicy(RetentionPolicy policy) {
        this.retentionPolicies.add(policy);
    }

    public void removeAllRotationPolicies() {
        for (RotationPolicy policy : this.rotationPolicies) {
            if (!(policy instanceof SizeBasedRotationPolicy)) continue;
            this.sizeLimit = 0L;
            SizeBasedRotationPolicy sizePolicy = (SizeBasedRotationPolicy)policy;
            sizePolicy.currentConfig.removeSizeLimitChangeListener(this);
        }
        this.rotationPolicies.clear();
    }

    public void removeAllRetentionPolicies() {
        this.retentionPolicies.clear();
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setFilePermissions(FilePermission filePermissions) {
        this.filePermissions = filePermissions;
    }

    public FileNamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }

    public void setNamingPolicy(FileNamingPolicy namingPolicy) {
        this.namingPolicy = namingPolicy;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SizeLimitLogRotationPolicyCfg config, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SizeLimitLogRotationPolicyCfg config) {
        if (this.sizeLimit == 0L || this.sizeLimit > config.getFileSizeLimit()) {
            this.sizeLimit = config.getFileSizeLimit();
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<String>());
    }

    @Override
    public String getShutdownListenerName() {
        return "MultifileTextWriter Thread " + this.name;
    }

    @Override
    public void processServerShutdown(String reason) {
        this.stopRequested = true;
        while (this.rotaterThread != null && this.rotaterThread.isAlive()) {
            try {
                this.rotaterThread.interrupt();
                this.rotaterThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        DirectoryServer.deregisterShutdownListener(this);
        this.removeAllRotationPolicies();
        this.removeAllRetentionPolicies();
    }

    private boolean isShuttingDown() {
        return this.stopRequested;
    }

    @Override
    public void shutdown() {
        this.processServerShutdown(null);
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            this.errorHandler.handleCloseError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecord(String record) {
        MultifileTextWriter multifileTextWriter = this;
        synchronized (multifileTextWriter) {
            try {
                this.writer.write(record);
                this.writer.newLine();
            }
            catch (Exception e) {
                this.errorHandler.handleWriteError(record, e);
            }
            if (this.autoFlush) {
                this.flush();
            }
        }
        if (this.sizeLimit > 0L && this.outputStream.written >= this.sizeLimit) {
            this.rotate();
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception e) {
            this.errorHandler.handleFlushError(e);
        }
    }

    public synchronized void rotate() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.errorHandler.handleCloseError(e);
        }
        File currentFile = this.namingPolicy.getInitialName();
        File newFile = this.namingPolicy.getNextName();
        currentFile.renameTo(newFile);
        try {
            this.constructWriter(currentFile, this.filePermissions, this.encoding, this.append, this.bufferSize);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.errorHandler.handleOpenError(currentFile, e);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Log file %s rotated and renamed to %s", currentFile, newFile);
        }
        ++this.totalFilesRotated;
        this.lastRotationTime = TimeThread.getTime();
    }

    public void setPostRotationActions(ArrayList<ActionType> actions) {
        this.actions = actions;
    }

    @Override
    public long getBytesWritten() {
        return this.outputStream.written;
    }

    public long getLastCleanTime() {
        return this.lastCleanTime;
    }

    public long getLastCleanCount() {
        return this.lastCleanCount;
    }

    public long getLastRotationTime() {
        return this.lastRotationTime;
    }

    public long getTotalFilesRotated() {
        return this.totalFilesRotated;
    }

    public long getTotalFilesCleaned() {
        return this.totalFilesCleaned;
    }

    private class RotaterThread
    extends DirectoryThread {
        MultifileTextWriter writer;

        public RotaterThread(MultifileTextWriter writer) {
            super(MultifileTextWriter.this.name);
            this.writer = writer;
        }

        public void run() {
            while (!MultifileTextWriter.this.isShuttingDown()) {
                block7: {
                    try {
                        RotaterThread.sleep(MultifileTextWriter.this.interval);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block7;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                for (RotationPolicy rotationPolicy : MultifileTextWriter.this.rotationPolicies) {
                    if (!rotationPolicy.rotateFile(this.writer)) continue;
                    MultifileTextWriter.this.rotate();
                }
                for (RetentionPolicy retentionPolicy : MultifileTextWriter.this.retentionPolicies) {
                    int numFilesDeleted = retentionPolicy.deleteFiles(this.writer);
                    if (numFilesDeleted > 0) {
                        MultifileTextWriter.this.lastCleanTime = TimeThread.getTime();
                        MultifileTextWriter.this.lastCleanCount = numFilesDeleted;
                        MultifileTextWriter.this.totalFilesCleaned++;
                    }
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugVerbose("%d files deleted by rentention policy", numFilesDeleted);
                }
            }
        }
    }
}

