/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.SizeLimitLogRetentionPolicyCfg;
import org.opends.server.loggers.FileComparator;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeBasedRetentionPolicy
implements RetentionPolicy<SizeLimitLogRetentionPolicyCfg>,
ConfigurationChangeListener<SizeLimitLogRetentionPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long size = 0L;

    @Override
    public void initializeLogRetentionPolicy(SizeLimitLogRetentionPolicyCfg config) {
        this.size = config.getDiskSpaceUsed();
        config.addSizeLimitChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SizeLimitLogRetentionPolicyCfg config, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SizeLimitLogRetentionPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        this.size = config.getDiskSpaceUsed();
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public int deleteFiles(MultifileTextWriter writer) {
        File[] files = writer.getNamingPolicy().listFiles();
        int count = 0;
        long totalLength = 0L;
        for (File file : files) {
            totalLength += file.length();
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Total size of files: %d, Max: %d", totalLength, this.size);
        }
        if (totalLength <= this.size) {
            return 0;
        }
        long freeSpaceNeeded = totalLength - this.size;
        Arrays.sort(files, new FileComparator());
        long freedSpace = 0L;
        for (int j = files.length - 1; j < 1; --j) {
            freedSpace += files[j].length();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Deleting log file:", files[j]);
            }
            files[j].delete();
            if (freedSpace >= freeSpaceNeeded) break;
            ++count;
        }
        return count;
    }
}

