/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.SizeLimitLogRotationPolicyCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeBasedRotationPolicy
implements RotationPolicy<SizeLimitLogRotationPolicyCfg>,
ConfigurationChangeListener<SizeLimitLogRotationPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long sizeLimit;
    SizeLimitLogRotationPolicyCfg currentConfig;

    @Override
    public void initializeLogRotationPolicy(SizeLimitLogRotationPolicyCfg config) throws ConfigException, InitializationException {
        this.sizeLimit = config.getFileSizeLimit();
        config.addSizeLimitChangeListener(this);
        this.currentConfig = config;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SizeLimitLogRotationPolicyCfg config, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SizeLimitLogRotationPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        this.sizeLimit = config.getFileSizeLimit();
        this.currentConfig = config;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean rotateFile(MultifileTextWriter writer) {
        long fileSize = writer.getBytesWritten();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("%d bytes written in current log file. Next rotation occurs at %d bytes", writer.getBytesWritten(), this.sizeLimit);
        }
        return fileSize >= this.sizeLimit;
    }
}

