/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import org.opends.server.admin.std.server.ErrorLogPublisherCfg;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.TextWriter;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadFilterTextErrorLogPublisher
extends ErrorLogPublisher<ErrorLogPublisherCfg> {
    private Thread thread;
    private TextWriter writer;

    public ThreadFilterTextErrorLogPublisher(Thread thread, TextWriter writer) {
        this.thread = thread;
        this.writer = writer;
    }

    @Override
    public void initializeErrorLogPublisher(ErrorLogPublisherCfg config) throws ConfigException, InitializationException {
    }

    @Override
    public void close() {
        this.writer.shutdown();
    }

    @Override
    public void logError(ErrorLogCategory category, ErrorLogSeverity severity, String message, int errorID) {
        Thread currentThread = Thread.currentThread();
        if (this.thread.equals(currentThread) || this.thread.getThreadGroup().equals(currentThread.getThreadGroup())) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(TimeThread.getLocalTime());
            sb.append("] category=").append(category.getCategoryName()).append(" severity=").append(severity.getSeverityName()).append(" msgID=").append(String.valueOf(errorID)).append(" msg=").append(message);
            this.writer.writeRecord(sb.toString());
        }
    }

    @Override
    public DN getDN() {
        return null;
    }
}

