/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers.debug;

import org.opends.server.util.ServerConstants;

public class DebugStackTraceFormatter {
    public static final int COMPLETE_STACK = Integer.MAX_VALUE;
    public static final FrameFilter SMART_FRAME_FILTER = new SmartFrameFilter();

    public static String formatStackTrace(Throwable t) {
        return DebugStackTraceFormatter.formatStackTrace(t, Integer.MAX_VALUE, true);
    }

    public static String formatStackTrace(Throwable t, int maxDepth, boolean includeCause) {
        StringBuffer buffer = new StringBuffer();
        while (t != null) {
            int frameLimit;
            StackTraceElement[] frames = t.getStackTrace();
            if (frames != null && (frameLimit = Math.min(maxDepth, frames.length)) > 0) {
                for (int i = 0; i < frameLimit; ++i) {
                    buffer.append("  ");
                    buffer.append(frames[i]);
                    buffer.append(ServerConstants.EOL);
                }
                if (frameLimit < frames.length) {
                    buffer.append("  ...(");
                    buffer.append(frames.length - frameLimit);
                    buffer.append(" more)");
                    buffer.append(ServerConstants.EOL);
                }
            }
            if (includeCause && t.getCause() != null) {
                t = t.getCause();
                buffer.append("  caused by ");
                continue;
            }
            t = null;
        }
        return buffer.toString();
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace, int maxDepth) {
        int frameLimit;
        StringBuffer buffer = new StringBuffer();
        if (stackTrace != null && (frameLimit = Math.min(maxDepth, stackTrace.length)) > 0) {
            for (int i = 0; i < frameLimit; ++i) {
                buffer.append("  ");
                buffer.append(stackTrace[i]);
                buffer.append(ServerConstants.EOL);
            }
            if (frameLimit < stackTrace.length) {
                buffer.append("  ...(");
                buffer.append(stackTrace.length - frameLimit);
                buffer.append(" more)");
                buffer.append(ServerConstants.EOL);
            }
        }
        return buffer.toString();
    }

    private static class SmartFrameFilter
    implements FrameFilter {
        private SmartFrameFilter() {
        }

        private boolean isFrameForPackage(StackTraceElement frame, String packageName) {
            boolean isContained = false;
            if (frame != null) {
                String className = frame.getClassName();
                isContained = className != null && className.startsWith(packageName);
            }
            return isContained;
        }

        public StackTraceElement[] getFilteredStackTrace(StackTraceElement[] frames) {
            StackTraceElement[] trimmedStack = null;
            if (frames != null && frames.length > 0) {
                int lastFrame;
                int firstFrame;
                for (firstFrame = 0; firstFrame < frames.length && this.isFrameForPackage(frames[firstFrame], "org.opends.server.loggers.debug"); ++firstFrame) {
                }
                for (lastFrame = frames.length - 1; lastFrame > firstFrame && !this.isFrameForPackage(frames[lastFrame], "org.opends"); --lastFrame) {
                }
                trimmedStack = new StackTraceElement[lastFrame - firstFrame + 1];
                for (int i = firstFrame; i <= lastFrame; ++i) {
                    trimmedStack[i - firstFrame] = frames[i];
                }
            }
            return trimmedStack;
        }
    }

    public static interface FrameFilter {
        public StackTraceElement[] getFilteredStackTrace(StackTraceElement[] var1);
    }
}

