/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers.debug;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.DebugTargetCfgDefn;
import org.opends.server.admin.std.server.DebugTargetCfg;
import org.opends.server.loggers.LogCategory;
import org.opends.server.loggers.LogLevel;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceSettings
implements ConfigurationChangeListener<DebugTargetCfg> {
    public static final TraceSettings DISABLED = new TraceSettings(DebugLogLevel.DISABLED);
    private static final String STACK_DUMP_KEYWORD = "stack";
    private static final String INCLUDE_CAUSE_KEYWORD = "cause";
    private static final String SUPPRESS_ARG_KEYWORD = "noargs";
    private static final String SUPPRESS_RETVAL_KEYWORD = "noretval";
    private static final String INCLUDE_CATEGORY_KEYWORD = "category";
    private static final String LEVEL_KEYWORD = "level";
    LogLevel level;
    Set<LogCategory> includeCategories;
    boolean noArgs;
    boolean noRetVal;
    int stackDepth;
    boolean includeCause;
    private DebugTargetCfg currentConfig;

    public TraceSettings(LogLevel level) {
        this(level, null, false, false, 0, false);
    }

    public TraceSettings(LogLevel level, Set<LogCategory> includeCategories) {
        this(level, includeCategories, false, false, 0, false);
    }

    public TraceSettings(LogLevel level, Set<LogCategory> includeCategories, boolean noArgs, boolean noRetVal) {
        this(level, includeCategories, noArgs, noRetVal, 0, false);
    }

    public TraceSettings(LogLevel level, Set<LogCategory> includeCategories, boolean noArgs, boolean noRetVal, int stackDepth, boolean includeCause) {
        this.level = level;
        this.includeCategories = includeCategories;
        this.noArgs = noArgs;
        this.noRetVal = noRetVal;
        this.stackDepth = stackDepth;
        this.includeCause = includeCause;
    }

    public TraceSettings(DebugTargetCfg config) {
        this.level = DebugLogLevel.parse(config.getDebugLevel().name());
        HashSet<LogCategory> logCategories = null;
        if (!config.getDebugCategory().isEmpty()) {
            logCategories = new HashSet<LogCategory>(config.getDebugCategory().size());
            for (DebugTargetCfgDefn.DebugCategory category : config.getDebugCategory()) {
                logCategories.add(DebugLogCategory.parse(category.name()));
            }
        }
        this.includeCategories = logCategories;
        this.noArgs = config.isOmitMethodEntryArguments();
        this.noRetVal = config.isOmitMethodReturnValue();
        this.stackDepth = config.getThrowableStackFrames();
        this.includeCause = config.isIncludeThrowableCause();
        this.currentConfig = config;
        config.addChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(DebugTargetCfg config, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(DebugTargetCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        this.level = DebugLogLevel.parse(config.getDebugLevel().name());
        HashSet<LogCategory> logCategories = null;
        if (!config.getDebugCategory().isEmpty()) {
            logCategories = new HashSet<LogCategory>(config.getDebugCategory().size());
            for (DebugTargetCfgDefn.DebugCategory category : config.getDebugCategory()) {
                logCategories.add(DebugLogCategory.parse(category.name()));
            }
        }
        this.includeCategories = logCategories;
        this.noArgs = config.isOmitMethodEntryArguments();
        this.noRetVal = config.isOmitMethodReturnValue();
        this.stackDepth = config.getThrowableStackFrames();
        this.includeCause = config.isIncludeThrowableCause();
        this.currentConfig = config;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    protected static TraceSettings parseTraceSettings(String value) {
        TraceSettings settings = null;
        if (value != null) {
            String[] keywords;
            LogLevel level = DebugLogLevel.ERROR;
            LogCategory categoryStub = DebugLogCategory.MESSAGE;
            HashSet<LogCategory> includeCategories = null;
            boolean noArgs = false;
            boolean noRetVal = false;
            int stackDepth = 0;
            boolean includeCause = false;
            for (String keyword : keywords = value.split(",")) {
                if (keyword.startsWith(STACK_DUMP_KEYWORD)) {
                    if (keyword.length() == STACK_DUMP_KEYWORD.length()) {
                        stackDepth = Integer.MAX_VALUE;
                        continue;
                    }
                    int depthStart = keyword.indexOf("=", STACK_DUMP_KEYWORD.length());
                    if (depthStart != STACK_DUMP_KEYWORD.length()) continue;
                    try {
                        stackDepth = Integer.valueOf(keyword.substring(depthStart + 1));
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("The keyword stack contains an invalid depth value. The complete stack will be included.");
                    }
                    continue;
                }
                if (keyword.equals(INCLUDE_CAUSE_KEYWORD)) {
                    includeCause = true;
                    continue;
                }
                if (keyword.equals(SUPPRESS_ARG_KEYWORD)) {
                    noArgs = true;
                    continue;
                }
                if (keyword.equals(SUPPRESS_RETVAL_KEYWORD)) {
                    noRetVal = true;
                    continue;
                }
                if (keyword.startsWith(INCLUDE_CATEGORY_KEYWORD)) {
                    int categoryStart = keyword.indexOf("=", INCLUDE_CATEGORY_KEYWORD.length());
                    if (keyword.length() == INCLUDE_CATEGORY_KEYWORD.length() || categoryStart != INCLUDE_CATEGORY_KEYWORD.length()) {
                        System.err.println("The keyword category does not contain an equal sign to define the set of categories to include. All categories will be included.");
                        continue;
                    }
                    String[] categories = keyword.substring(categoryStart + 1).split("[|]");
                    includeCategories = new HashSet<LogCategory>();
                    for (String category : categories) {
                        try {
                            includeCategories.add(DebugLogCategory.parse(category));
                        }
                        catch (IllegalArgumentException iae) {
                            System.err.println("The keyword category contains an invalid debug log category: " + iae.toString() + ". It will be ignored.");
                        }
                    }
                    continue;
                }
                if (!keyword.startsWith(LEVEL_KEYWORD)) continue;
                int levelStart = keyword.indexOf("=", LEVEL_KEYWORD.length());
                if (keyword.length() == LEVEL_KEYWORD.length() || levelStart != LEVEL_KEYWORD.length()) {
                    System.err.println("The keyword level does not contain an equal sign to specify the log level. Default level of " + level.toString() + " will be used.");
                    continue;
                }
                try {
                    level = LogLevel.parse(keyword.substring(levelStart + 1));
                }
                catch (IllegalArgumentException iae) {
                    System.err.println("The keyword level contains an invalid debug log level: " + iae.toString() + ". Default level of " + level.toString() + " will be used.");
                }
            }
            settings = new TraceSettings(level, includeCategories, noArgs, noRetVal, stackDepth, includeCause);
        }
        return settings;
    }
}

