/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins.profiler;

import java.util.Arrays;
import java.util.HashMap;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.plugins.profiler.ProfileStack;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileStackFrame
implements Comparable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private HashMap<Integer, Long> lineNumbers;
    private HashMap<ProfileStackFrame, ProfileStackFrame> subordinateFrames;
    private String className;
    private String methodName;

    public ProfileStackFrame(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
        this.lineNumbers = new HashMap();
        this.subordinateFrames = new HashMap();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getHTMLSafeMethodName() {
        int length = this.methodName.length();
        StringBuilder buffer = new StringBuilder(length + 6);
        for (int i = 0; i < length; ++i) {
            char c = this.methodName.charAt(i);
            if (c == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                buffer.append("&gt;");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public HashMap<Integer, Long> getLineNumbers() {
        return this.lineNumbers;
    }

    public void updateLineNumberCount(int lineNumber, long numOccurrences) {
        Long existingCount = this.lineNumbers.get(lineNumber);
        if (existingCount == null) {
            this.lineNumbers.put(lineNumber, numOccurrences);
        } else {
            this.lineNumbers.put(lineNumber, existingCount + numOccurrences);
        }
    }

    public long getTotalCount() {
        long totalCount = 0L;
        for (Long l : this.lineNumbers.values()) {
            totalCount += l.longValue();
        }
        return totalCount;
    }

    public ProfileStackFrame[] getSubordinateFrames() {
        Object[] subFrames = new ProfileStackFrame[]{};
        subFrames = this.subordinateFrames.values().toArray(subFrames);
        Arrays.sort(subFrames);
        return subFrames;
    }

    public boolean hasSubFrames() {
        return !this.subordinateFrames.isEmpty();
    }

    public void recurseSubFrames(ProfileStack stack, int depth, long count, HashMap<String, HashMap<ProfileStack, Long>> stacksByMethod) {
        if (depth < 0) {
            return;
        }
        String cName = stack.getClassName(depth);
        String mName = stack.getMethodName(depth);
        ProfileStackFrame f = new ProfileStackFrame(cName, mName);
        int lineNumber = stack.getLineNumber(depth);
        ProfileStackFrame subFrame = this.subordinateFrames.get(f);
        if (subFrame == null) {
            subFrame = f;
            this.subordinateFrames.put(subFrame, subFrame);
        }
        subFrame.updateLineNumberCount(lineNumber, count);
        String classAndMethod = cName + "." + mName;
        HashMap<ProfileStack, Long> stackMap = stacksByMethod.get(classAndMethod);
        if (stackMap == null) {
            stackMap = new HashMap();
            stacksByMethod.put(classAndMethod, stackMap);
        }
        stackMap.put(stack, count);
        subFrame.recurseSubFrames(stack, depth - 1, count, stacksByMethod);
    }

    public int hashCode() {
        return this.className.hashCode() + this.methodName.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        try {
            ProfileStackFrame f = (ProfileStackFrame)o;
            return this.className.equals(f.className) && this.methodName.equals(f.methodName);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    public int compareTo(Object o) throws ClassCastException {
        ProfileStackFrame f = (ProfileStackFrame)o;
        long thisCount = this.getTotalCount();
        long thatCount = f.getTotalCount();
        if (thisCount > thatCount) {
            return -1;
        }
        if (thisCount < thatCount) {
            return 1;
        }
        int value = this.className.compareTo(f.className);
        if (value == 0) {
            value = this.methodName.compareTo(f.methodName);
        }
        return value;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getTotalCount());
        buffer.append("    ");
        buffer.append(this.className);
        buffer.append('.');
        buffer.append(this.methodName);
        return buffer.toString();
    }
}

