/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class ASN1Boolean
extends ASN1Element {
    private static final long serialVersionUID = -3352160557662933000L;
    private boolean booleanValue;

    public ASN1Boolean(boolean booleanValue) {
        super((byte)1, ASN1Boolean.encodeValue(booleanValue));
        this.booleanValue = booleanValue;
    }

    public ASN1Boolean(byte type, boolean booleanValue) {
        super(type, ASN1Boolean.encodeValue(booleanValue));
        this.booleanValue = booleanValue;
    }

    private ASN1Boolean(byte type, byte[] value, boolean booleanValue) {
        super(type, value);
        this.booleanValue = booleanValue;
    }

    public boolean booleanValue() {
        return this.booleanValue;
    }

    public void setValue(boolean booleanValue) {
        this.booleanValue = booleanValue;
        this.setValueInternal(ASN1Boolean.encodeValue(booleanValue));
    }

    public void setValue(byte[] value) throws ASN1Exception {
        if (value == null) {
            int msgID = 2293771;
            String message = MessageHandler.getMessage(msgID);
            throw new ASN1Exception(msgID, message);
        }
        if (value.length != 1) {
            int msgID = 2293772;
            String message = MessageHandler.getMessage(msgID, value.length);
            throw new ASN1Exception(msgID, message);
        }
        this.booleanValue = value[0] != 0;
        this.setValueInternal(value);
    }

    public static ASN1Boolean decodeAsBoolean(ASN1Element element) throws ASN1Exception {
        if (element == null) {
            int msgID = 2293773;
            String message = MessageHandler.getMessage(msgID);
            throw new ASN1Exception(msgID, message);
        }
        byte[] value = element.value();
        if (value.length != 1) {
            int msgID = 2293774;
            String message = MessageHandler.getMessage(msgID, value.length);
            throw new ASN1Exception(msgID, message);
        }
        boolean booleanValue = value[0] != 0;
        return new ASN1Boolean(element.getType(), value, booleanValue);
    }

    public static ASN1Boolean decodeAsBoolean(byte[] encodedElement) throws ASN1Exception {
        int msgID;
        if (encodedElement == null) {
            int msgID2 = 2293775;
            String message = MessageHandler.getMessage(msgID2);
            throw new ASN1Exception(msgID2, message);
        }
        if (encodedElement.length < 3) {
            int msgID3 = 2293776;
            String message = MessageHandler.getMessage(msgID3, encodedElement.length);
            throw new ASN1Exception(msgID3, message);
        }
        byte type = encodedElement[0];
        int length = encodedElement[1] & 0x7F;
        int valueStartPos = 2;
        if (length != encodedElement[1]) {
            int numLengthBytes = length;
            if (numLengthBytes > 4) {
                int msgID4 = 0x230003;
                String message = MessageHandler.getMessage(msgID4, numLengthBytes);
                throw new ASN1Exception(msgID4, message);
            }
            if (encodedElement.length < 2 + numLengthBytes) {
                int msgID5 = 2293764;
                String message = MessageHandler.getMessage(msgID5, numLengthBytes);
                throw new ASN1Exception(msgID5, message);
            }
            length = 0;
            valueStartPos = 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                length = length << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (encodedElement.length - valueStartPos != length) {
            msgID = 2293765;
            String message = MessageHandler.getMessage(msgID, length, encodedElement.length - valueStartPos);
            throw new ASN1Exception(msgID, message);
        }
        if (length != 1) {
            msgID = 2293777;
            String message = MessageHandler.getMessage(msgID, length);
            throw new ASN1Exception(msgID, message);
        }
        byte[] value = new byte[]{encodedElement[valueStartPos]};
        boolean booleanValue = value[0] != 0;
        return new ASN1Boolean(type, value, booleanValue);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ASN1Boolean(type=");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(", value=");
        buffer.append(this.booleanValue);
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("ASN.1 Boolean");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  BER Type:  ");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Value:  ");
        buffer.append(this.booleanValue);
        buffer.append(" (");
        buffer.append(StaticUtils.byteToHex(this.value()[0]));
        buffer.append(")");
        buffer.append(ServerConstants.EOL);
    }
}

