/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class ASN1Long
extends ASN1Element {
    private static final long serialVersionUID = -6015600344725970947L;
    private long longValue;

    public ASN1Long(long longValue) {
        super((byte)2, ASN1Long.encodeLongValue(longValue));
        this.longValue = longValue;
    }

    public ASN1Long(byte type, long longValue) {
        super(type, ASN1Long.encodeLongValue(longValue));
        this.longValue = longValue;
    }

    private ASN1Long(byte type, byte[] value, long longValue) {
        super(type, value);
        this.longValue = longValue;
    }

    public long longValue() {
        return this.longValue;
    }

    public void setValue(long longValue) {
        this.longValue = longValue;
        this.setValueInternal(ASN1Long.encodeLongValue(longValue));
    }

    public void setValue(byte[] value) throws ASN1Exception {
        if (value == null) {
            int msgID = 2293785;
            String message = MessageHandler.getMessage(msgID);
            throw new ASN1Exception(msgID, message);
        }
        if (value.length < 1 || value.length > 8) {
            int msgID = 2294021;
            String message = MessageHandler.getMessage(msgID, value.length);
            throw new ASN1Exception(msgID, message);
        }
        this.longValue = 0L;
        for (byte b : value) {
            this.longValue = this.longValue << 8 | (long)(b & 0xFF);
        }
        this.setValueInternal(value);
    }

    public static ASN1Long decodeAsLong(ASN1Element element) throws ASN1Exception {
        if (element == null) {
            int msgID = 2293787;
            String message = MessageHandler.getMessage(msgID);
            throw new ASN1Exception(msgID, message);
        }
        byte[] value = element.value();
        if (value.length < 1 || value.length > 8) {
            int msgID = 2294022;
            String message = MessageHandler.getMessage(msgID, value.length);
            throw new ASN1Exception(msgID, message);
        }
        long longValue = 0L;
        for (byte b : value) {
            longValue = longValue << 8 | (long)(b & 0xFF);
        }
        return new ASN1Long(element.getType(), value, longValue);
    }

    public static ASN1Long decodeAsLong(byte[] encodedElement) throws ASN1Exception {
        int msgID;
        if (encodedElement == null) {
            int msgID2 = 2293789;
            String message = MessageHandler.getMessage(msgID2);
            throw new ASN1Exception(msgID2, message);
        }
        if (encodedElement.length < 3) {
            int msgID3 = 2293790;
            String message = MessageHandler.getMessage(msgID3, encodedElement.length);
            throw new ASN1Exception(msgID3, message);
        }
        byte type = encodedElement[0];
        int length = encodedElement[1] & 0x7F;
        int valueStartPos = 2;
        if (length != encodedElement[1]) {
            int numLengthBytes = length;
            if (numLengthBytes > 4) {
                int msgID4 = 0x230003;
                String message = MessageHandler.getMessage(msgID4, numLengthBytes);
                throw new ASN1Exception(msgID4, message);
            }
            if (encodedElement.length < 2 + numLengthBytes) {
                int msgID5 = 2293764;
                String message = MessageHandler.getMessage(msgID5, numLengthBytes);
                throw new ASN1Exception(msgID5, message);
            }
            length = 0;
            valueStartPos = 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                length = length << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (encodedElement.length - valueStartPos != length) {
            msgID = 2293765;
            String message = MessageHandler.getMessage(msgID, length, encodedElement.length - valueStartPos);
            throw new ASN1Exception(msgID, message);
        }
        if (length < 1 || length > 8) {
            msgID = 2294023;
            String message = MessageHandler.getMessage(msgID, length);
            throw new ASN1Exception(msgID, message);
        }
        byte[] value = new byte[length];
        System.arraycopy(encodedElement, valueStartPos, value, 0, length);
        long longValue = 0L;
        for (byte b : value) {
            longValue = longValue << 8 | (long)(b & 0xFF);
        }
        return new ASN1Long(type, value, longValue);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ASN1Long(type=");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(", value=");
        buffer.append(this.longValue);
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("ASN.1 Long");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  BER Type:  ");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Value:  ");
        buffer.append(this.longValue);
        buffer.append(" (");
        buffer.append(StaticUtils.bytesToHex(this.value()));
        buffer.append(")");
        buffer.append(ServerConstants.EOL);
    }
}

