/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.types.DebugLogLevel;

public class ASN1Reader {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private InputStream inputStream;
    private int maxElementSize;
    private Socket socket;

    public ASN1Reader(Socket socket) throws IOException {
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.maxElementSize = -1;
    }

    public ASN1Reader(InputStream inputStream) {
        this.inputStream = inputStream;
        this.socket = null;
        this.maxElementSize = -1;
    }

    public int getMaxElementSize() {
        return this.maxElementSize;
    }

    public void setMaxElementSize(int maxElementSize) {
        this.maxElementSize = maxElementSize;
    }

    public int getIOTimeout() throws IOException {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getSoTimeout();
    }

    public void setIOTimeout(int ioTimeout) throws IOException {
        if (this.socket == null) {
            return;
        }
        this.socket.setSoTimeout(Math.max(0, ioTimeout));
    }

    public ASN1Element readElement() throws IOException, ASN1Exception {
        int numLengthBytes;
        int typeValue = this.inputStream.read();
        if (typeValue < 0) {
            return null;
        }
        byte type = (byte)(typeValue & 0xFF);
        int length = this.inputStream.read();
        if (length != (numLengthBytes = length & 0x7F)) {
            if (numLengthBytes > 4) {
                int msgID = 2293768;
                String message = MessageHandler.getMessage(msgID, numLengthBytes);
                throw new ASN1Exception(msgID, message);
            }
            length = 0;
            for (int i = 0; i < numLengthBytes; ++i) {
                int lengthByte = this.inputStream.read();
                if (lengthByte < 0) {
                    int msgID = 2293769;
                    String message = MessageHandler.getMessage(msgID, numLengthBytes);
                    throw new IOException(message);
                }
                length = length << 8 | lengthByte;
            }
        }
        if (length == 0) {
            return new ASN1Element(type);
        }
        if (this.maxElementSize > 0 && length > this.maxElementSize) {
            int msgID = 2293951;
            String message = MessageHandler.getMessage(msgID, length, this.maxElementSize);
            throw new ASN1Exception(msgID, message);
        }
        byte[] value = new byte[length];
        int readPos = 0;
        int bytesNeeded = length;
        while (bytesNeeded > 0) {
            int bytesRead = this.inputStream.read(value, readPos, bytesNeeded);
            if (bytesRead < 0) {
                int msgID = 2293770;
                String message = MessageHandler.getMessage(msgID, length, bytesNeeded);
                throw new IOException(message);
            }
            bytesNeeded -= bytesRead;
            readPos += bytesRead;
        }
        return new ASN1Element(type, value);
    }

    public void close() {
        block6: {
            block5: {
                try {
                    this.inputStream.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block6;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

