/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.types.DebugLogLevel;

public class ASN1Writer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private OutputStream outputStream;
    private Socket socket;

    public ASN1Writer(Socket socket) throws IOException {
        this.socket = socket;
        this.outputStream = socket.getOutputStream();
    }

    public ASN1Writer(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.socket = null;
    }

    public int writeElement(ASN1Element element) throws IOException {
        byte[] elementBytes = element.encode();
        this.outputStream.write(elementBytes);
        this.outputStream.flush();
        return elementBytes.length;
    }

    public void close() {
        block6: {
            block5: {
                try {
                    this.outputStream.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block6;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

