/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.internal;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.SearchOperationBasis;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.RawFilter;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalSearchOperation
extends SearchOperationBasis {
    private InternalSearchListener searchListener;
    private LinkedList<SearchResultEntry> entryList;
    private LinkedList<SearchResultReference> referenceList;

    public InternalSearchOperation(ClientConnection internalConnection, long operationID, int messageID, List<Control> requestControls, ByteString rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, RawFilter rawFilter, LinkedHashSet<String> attributes, InternalSearchListener searchListener) {
        super(internalConnection, operationID, messageID, requestControls, rawBaseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, rawFilter, attributes);
        if (searchListener == null) {
            this.searchListener = null;
            this.entryList = new LinkedList();
            this.referenceList = new LinkedList();
        } else {
            this.searchListener = searchListener;
            this.entryList = null;
            this.referenceList = null;
        }
        this.setInternalOperation(true);
    }

    public InternalSearchOperation(ClientConnection internalConnection, long operationID, int messageID, List<Control> requestControls, DN baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, SearchFilter filter, LinkedHashSet<String> attributes, InternalSearchListener searchListener) {
        super(internalConnection, operationID, messageID, requestControls, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
        if (searchListener == null) {
            this.searchListener = null;
            this.entryList = new LinkedList();
            this.referenceList = new LinkedList();
        } else {
            this.searchListener = searchListener;
            this.entryList = null;
            this.referenceList = null;
        }
        this.setInternalOperation(true);
    }

    public LinkedList<SearchResultEntry> getSearchEntries() {
        return this.entryList;
    }

    public void addSearchEntry(SearchResultEntry searchEntry) throws DirectoryException {
        if (this.searchListener == null) {
            this.entryList.add(searchEntry);
        } else {
            this.searchListener.handleInternalSearchEntry(this, searchEntry);
        }
    }

    public LinkedList<SearchResultReference> getSearchReferences() {
        return this.referenceList;
    }

    public void addSearchReference(SearchResultReference searchReference) throws DirectoryException {
        if (this.searchListener == null) {
            this.referenceList.add(searchReference);
        } else {
            this.searchListener.handleInternalSearchReference(this, searchReference);
        }
    }

    @Override
    public void sendSearchEntry(SearchResultEntry searchEntry) throws DirectoryException {
        this.addSearchEntry(searchEntry);
    }

    @Override
    public boolean sendSearchReference(SearchResultReference searchReference) throws DirectoryException {
        this.addSearchReference(searchReference);
        return true;
    }
}

