/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

public class AbandonRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int idToAbandon;

    public AbandonRequestProtocolOp(int idToAbandon) {
        this.idToAbandon = idToAbandon;
    }

    public int getIDToAbandon() {
        return this.idToAbandon;
    }

    public void setIDToAbandon(int idToAbandon) {
        this.idToAbandon = idToAbandon;
    }

    public byte getType() {
        return 80;
    }

    public String getProtocolOpName() {
        return "Abandon Request";
    }

    public ASN1Element encode() {
        return new ASN1Integer(80, this.idToAbandon);
    }

    public static AbandonRequestProtocolOp decodeAbandonRequest(ASN1Element element) throws LDAPException {
        int idToAbandon;
        try {
            idToAbandon = element.decodeAsInteger().intValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293819;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new AbandonRequestProtocolOp(idToAbandon);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("AbandonRequest(idToAbandon=");
        buffer.append(this.idToAbandon);
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Abandon Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  ID to Abandon:  ");
        buffer.append(this.idToAbandon);
        buffer.append(ServerConstants.EOL);
    }
}

