/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedResponseProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString value;
    private DN matchedDN;
    private int resultCode;
    private List<String> referralURLs;
    private String errorMessage;
    private String oid;

    public ExtendedResponseProtocolOp(int resultCode) {
        this.resultCode = resultCode;
        this.errorMessage = null;
        this.matchedDN = null;
        this.referralURLs = null;
        this.oid = null;
        this.value = null;
    }

    public ExtendedResponseProtocolOp(int resultCode, String errorMessage) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = null;
        this.referralURLs = null;
        this.oid = null;
        this.value = null;
    }

    public ExtendedResponseProtocolOp(int resultCode, String errorMessage, DN matchedDN, List<String> referralURLs) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs;
        this.oid = null;
        this.value = null;
    }

    public ExtendedResponseProtocolOp(int resultCode, String errorMessage, DN matchedDN, List<String> referralURLs, String oid, ASN1OctetString value) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs;
        this.oid = oid;
        this.value = value;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public DN getMatchedDN() {
        return this.matchedDN;
    }

    public void setMatchedDN(DN matchedDN) {
        this.matchedDN = matchedDN;
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    public void setReferralURLs(List<String> referralURLs) {
        this.referralURLs = referralURLs;
    }

    public String getOID() {
        return this.oid;
    }

    public void setOID(String oid) {
        this.oid = oid;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    public void setValue(ASN1OctetString value) {
        this.value = value;
    }

    @Override
    public byte getType() {
        return 120;
    }

    @Override
    public String getProtocolOpName() {
        return "Extended Response";
    }

    @Override
    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(6);
        elements.add(new ASN1Enumerated(this.resultCode));
        if (this.matchedDN == null) {
            elements.add(new ASN1OctetString());
        } else {
            elements.add(new ASN1OctetString(this.matchedDN.toString()));
        }
        elements.add(new ASN1OctetString(this.errorMessage));
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            ArrayList<ASN1Element> referralElements = new ArrayList<ASN1Element>(this.referralURLs.size());
            for (String s : this.referralURLs) {
                referralElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-93, referralElements));
        }
        if (this.oid != null && this.oid.length() > 0) {
            elements.add(new ASN1OctetString(-118, this.oid));
        }
        if (this.value != null) {
            this.value.setType((byte)-117);
            elements.add(this.value);
        }
        return new ASN1Sequence(120, elements);
    }

    public static ExtendedResponseProtocolOp decodeExtendedResponse(ASN1Element element) throws LDAPException {
        String errorMessage;
        DN matchedDN;
        int resultCode;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293820;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        int numElements = elements.size();
        if (numElements < 3 || numElements > 6) {
            int msgID = 2293829;
            String message = MessageHandler.getMessage(msgID, numElements);
            throw new LDAPException(2, msgID, message);
        }
        try {
            resultCode = elements.get(0).decodeAsInteger().intValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293822;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            String dnString = elements.get(1).decodeAsOctetString().stringValue();
            matchedDN = dnString.length() == 0 ? null : DN.decode(dnString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293823;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            errorMessage = elements.get(2).decodeAsOctetString().stringValue();
            if (errorMessage.length() == 0) {
                errorMessage = null;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293824;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        ArrayList<String> referralURLs = null;
        String oid = null;
        ASN1OctetString value = null;
        block19: for (int i = 3; i < elements.size(); ++i) {
            element = elements.get(i);
            switch (element.getType()) {
                case -93: {
                    String message;
                    try {
                        ArrayList<ASN1Element> referralElements = element.decodeAsSequence().elements();
                        referralURLs = new ArrayList<String>(referralElements.size());
                        for (ASN1Element e : referralElements) {
                            referralURLs.add(e.decodeAsOctetString().stringValue());
                        }
                        continue block19;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        int msgID = 2293830;
                        message = MessageHandler.getMessage(msgID, String.valueOf(e));
                        throw new LDAPException(2, msgID, message, e);
                    }
                }
                case -118: {
                    String message;
                    try {
                        oid = element.decodeAsOctetString().stringValue();
                        continue block19;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        int msgID = 2293831;
                        message = MessageHandler.getMessage(msgID, String.valueOf(e));
                        throw new LDAPException(2, msgID, message, e);
                    }
                }
                case -117: {
                    String message;
                    try {
                        value = element.decodeAsOctetString();
                        continue block19;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        int msgID = 2293832;
                        message = MessageHandler.getMessage(msgID, String.valueOf(e));
                        throw new LDAPException(2, msgID, message, e);
                    }
                }
                default: {
                    int msgID = 2293833;
                    String message = MessageHandler.getMessage(msgID, element.getType());
                    throw new LDAPException(2, msgID, message);
                }
            }
        }
        return new ExtendedResponseProtocolOp(resultCode, errorMessage, matchedDN, referralURLs, oid, value);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ExtendedResponse(resultCode=");
        buffer.append(this.resultCode);
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            buffer.append(", errorMessage=");
            buffer.append(this.errorMessage);
        }
        if (this.matchedDN != null) {
            buffer.append(", matchedDN=");
            buffer.append(this.matchedDN.toString());
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            buffer.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            buffer.append("}");
        }
        if (this.oid != null && this.oid.length() > 0) {
            buffer.append(", oid=");
            buffer.append(this.oid);
        }
        if (this.value != null) {
            buffer.append(", value=");
            this.value.toString(buffer);
        }
        buffer.append(")");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Extended Response");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Result Code:  ");
        buffer.append(this.resultCode);
        buffer.append(ServerConstants.EOL);
        if (this.errorMessage != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Error Message:  ");
            buffer.append(this.errorMessage);
            buffer.append(ServerConstants.EOL);
        }
        if (this.matchedDN != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Matched DN:  ");
            this.matchedDN.toString(buffer);
            buffer.append(ServerConstants.EOL);
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Referral URLs:  ");
            buffer.append(ServerConstants.EOL);
            for (String s : this.referralURLs) {
                buffer.append((CharSequence)indentBuf);
                buffer.append("  ");
                buffer.append(s);
                buffer.append(ServerConstants.EOL);
            }
        }
        if (this.oid != null && this.oid.length() > 0) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Response OID:  ");
            buffer.append(this.oid);
            buffer.append(ServerConstants.EOL);
        }
        if (this.value != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Response Value:  ");
            this.value.toString(buffer);
            buffer.append(ServerConstants.EOL);
        }
    }
}

