/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class IntermediateResponseProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString value;
    private String oid;

    public IntermediateResponseProtocolOp(String oid) {
        this.oid = oid;
        this.value = null;
    }

    public IntermediateResponseProtocolOp(String oid, ASN1OctetString value) {
        this.oid = oid;
        this.value = value;
    }

    public String getOID() {
        return this.oid;
    }

    public void setOID(String oid) {
        this.oid = oid;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    public void setValue(ASN1OctetString value) {
        this.value = value;
    }

    public byte getType() {
        return 121;
    }

    public String getProtocolOpName() {
        return "Intermediate Response";
    }

    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        if (this.oid != null) {
            elements.add(new ASN1OctetString(-128, this.oid));
        }
        if (this.value != null) {
            this.value.setType((byte)-127);
            elements.add(this.value);
        }
        return new ASN1Sequence(121, elements);
    }

    public static IntermediateResponseProtocolOp decodeIntermediateResponse(ASN1Element element) throws LDAPException {
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2294074;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        int numElements = elements.size();
        if (numElements > 2) {
            int msgID = 2294075;
            String message = MessageHandler.getMessage(msgID, numElements);
            throw new LDAPException(2, msgID, message);
        }
        String oid = null;
        ASN1OctetString value = null;
        if (elements.size() == 1) {
            ASN1Element e = elements.get(0);
            switch (e.getType()) {
                case -128: {
                    try {
                        oid = e.decodeAsOctetString().stringValue();
                        break;
                    }
                    catch (ASN1Exception ae) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                        }
                        int msgID = 2294076;
                        String message = MessageHandler.getMessage(msgID, ae.getMessage());
                        throw new LDAPException(2, msgID, message);
                    }
                }
                case -127: {
                    try {
                        value = e.decodeAsOctetString();
                        break;
                    }
                    catch (ASN1Exception ae) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                        }
                        int msgID = 2294077;
                        String message = MessageHandler.getMessage(msgID, ae.getMessage());
                        throw new LDAPException(2, msgID, message);
                    }
                }
                default: {
                    int msgID = 2294078;
                    String message = MessageHandler.getMessage(msgID, StaticUtils.byteToHex(e.getType()));
                    throw new LDAPException(2, msgID, message);
                }
            }
        } else if (elements.size() == 2) {
            try {
                oid = elements.get(0).decodeAsOctetString().stringValue();
            }
            catch (ASN1Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                int msgID = 2294076;
                String message = MessageHandler.getMessage(msgID, ae.getMessage());
                throw new LDAPException(2, msgID, message);
            }
            try {
                value = elements.get(1).decodeAsOctetString();
            }
            catch (ASN1Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                int msgID = 2294076;
                String message = MessageHandler.getMessage(msgID, ae.getMessage());
                throw new LDAPException(2, msgID, message);
            }
        }
        return new IntermediateResponseProtocolOp(oid, value);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("IntermediateResponse(oid=");
        buffer.append(String.valueOf(this.oid));
        if (this.value != null) {
            buffer.append(", value=");
            this.value.toString(buffer);
        }
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Intermediate Response");
        buffer.append(ServerConstants.EOL);
        if (this.oid != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  OID:  ");
            buffer.append(this.oid);
            buffer.append(ServerConstants.EOL);
        }
        if (this.value != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Value:");
            buffer.append(ServerConstants.EOL);
            this.value.toString(buffer, indent + 4);
        }
    }
}

