/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.core.AbandonOperationBasis;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.BindOperationBasis;
import org.opends.server.core.CompareOperationBasis;
import org.opends.server.core.DeleteOperationBasis;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperationBasis;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.SearchOperationBasis;
import org.opends.server.core.UnbindOperationBasis;
import org.opends.server.extensions.NullConnectionSecurityProvider;
import org.opends.server.extensions.TLSCapableConnection;
import org.opends.server.extensions.TLSConnectionSecurityProvider;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.IntermediateResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPConnectionHandler;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPRequestHandler;
import org.opends.server.protocols.ldap.LDAPStatistics;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPClientConnection
extends ClientConnection
implements TLSCapableConnection {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AtomicLong lastCompletionTime;
    private AtomicLong nextOperationID;
    private boolean connectionValid;
    private boolean disconnectRequested;
    private boolean keepStats;
    private byte elementType;
    private byte[] elementValue;
    private ConcurrentHashMap<Integer, AbstractOperation> operationsInProgress;
    private ConnectionSecurityProvider clearSecurityProvider;
    private ConnectionSecurityProvider securityProvider;
    private int clientPort;
    private int elementLength;
    private int elementLengthBytesNeeded;
    private int elementReadState;
    private int elementValueBytesRead;
    private int elementValueBytesNeeded;
    private int ldapVersion;
    private int serverPort;
    private LDAPConnectionHandler connectionHandler;
    private LDAPRequestHandler requestHandler;
    private LDAPStatistics statTracker;
    private long connectionID;
    private ReentrantLock opsInProgressLock;
    private ReentrantLock transmitLock;
    private SocketChannel clientChannel;
    private String clientAddress;
    private String protocol;
    private String serverAddress;
    private TLSConnectionSecurityProvider tlsSecurityProvider;

    public LDAPClientConnection(LDAPConnectionHandler connectionHandler, SocketChannel clientChannel) {
        this.connectionHandler = connectionHandler;
        this.clientChannel = clientChannel;
        this.securityProvider = null;
        this.clearSecurityProvider = null;
        this.opsInProgressLock = new ReentrantLock();
        this.transmitLock = new ReentrantLock();
        this.elementReadState = 0;
        this.elementType = 0;
        this.elementLength = 0;
        this.elementLengthBytesNeeded = 0;
        this.elementValue = null;
        this.elementValueBytesRead = 0;
        this.elementValueBytesNeeded = 0;
        this.ldapVersion = 3;
        this.requestHandler = null;
        this.lastCompletionTime = new AtomicLong(TimeThread.getTime());
        this.nextOperationID = new AtomicLong(0L);
        this.connectionValid = true;
        this.disconnectRequested = false;
        this.operationsInProgress = new ConcurrentHashMap();
        this.keepStats = connectionHandler.keepStats();
        this.protocol = "LDAP";
        this.clientAddress = clientChannel.socket().getInetAddress().getHostAddress();
        this.clientPort = clientChannel.socket().getPort();
        this.serverAddress = clientChannel.socket().getLocalAddress().getHostAddress();
        this.serverPort = clientChannel.socket().getLocalPort();
        LDAPStatistics parentTracker = connectionHandler.getStatTracker();
        String instanceName = parentTracker.getMonitorInstanceName() + " for " + this.toString();
        this.statTracker = new LDAPStatistics(instanceName, parentTracker);
        if (this.keepStats) {
            this.statTracker.updateConnect();
        }
        this.connectionID = DirectoryServer.newConnectionAccepted(this);
        if (this.connectionID < 0L) {
            this.disconnect(DisconnectReason.ADMIN_LIMIT_EXCEEDED, true, 2293974, new Object[0]);
        }
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    @Override
    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public LDAPRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(LDAPRequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public SocketChannel getSocketChannel() {
        return this.clientChannel;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getClientAddress() {
        return this.clientAddress;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public String getClientHostPort() {
        return this.clientAddress + ":" + this.clientPort;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getServerHostPort() {
        return this.serverAddress + ":" + this.serverPort;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.clientChannel.socket().getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.clientChannel.socket().getLocalAddress();
    }

    @Override
    public boolean isSecure() {
        return this.securityProvider.isSecure();
    }

    @Override
    public ConnectionSecurityProvider getConnectionSecurityProvider() {
        return this.securityProvider;
    }

    @Override
    public void setConnectionSecurityProvider(ConnectionSecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
        this.protocol = securityProvider.isSecure() ? "LDAP+" + securityProvider.getSecurityMechanismName() : "LDAP";
    }

    @Override
    public String getSecurityMechanism() {
        return this.securityProvider.getSecurityMechanismName();
    }

    public long nextOperationID() {
        return this.nextOperationID.getAndIncrement();
    }

    @Override
    public void sendResponse(Operation operation) {
        this.removeOperationInProgress(operation.getMessageID());
        LDAPMessage message = this.operationToResponseLDAPMessage(operation);
        if (message != null) {
            this.sendLDAPMessage(this.securityProvider, message);
        }
    }

    private LDAPMessage operationToResponseLDAPMessage(Operation operation) {
        ArrayList<LDAPControl> controls;
        ProtocolOp protocolOp;
        List<String> referralURLs;
        ResultCode resultCode = operation.getResultCode();
        if (resultCode == null) {
            ErrorLogger.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_ERROR, 2293919, operation.getOperationType().toString(), operation.getConnectionID(), operation.getOperationID());
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        StringBuilder errorMessage = operation.getErrorMessage();
        DN matchedDN = operation.getMatchedDN();
        if (this.ldapVersion == 2) {
            List<String> opReferrals;
            referralURLs = null;
            if (resultCode == ResultCode.REFERRAL) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                errorMessage.append(MessageHandler.getMessage(2293968));
            }
            if ((opReferrals = operation.getReferralURLs()) != null && !opReferrals.isEmpty()) {
                StringBuilder referralsStr = new StringBuilder();
                Iterator<String> iterator = opReferrals.iterator();
                referralsStr.append(iterator.next());
                while (iterator.hasNext()) {
                    referralsStr.append(", ");
                    referralsStr.append(iterator.next());
                }
                errorMessage.append(MessageHandler.getMessage(2293969, String.valueOf(referralsStr)));
            }
        } else {
            referralURLs = operation.getReferralURLs();
        }
        switch (operation.getOperationType()) {
            case ADD: {
                protocolOp = new AddResponseProtocolOp(resultCode.getIntValue(), errorMessage.toString(), matchedDN, referralURLs);
                break;
            }
            case BIND: {
                ASN1OctetString serverSASLCredentials = ((BindOperationBasis)operation).getServerSASLCredentials();
                protocolOp = new BindResponseProtocolOp(resultCode.getIntValue(), errorMessage.toString(), matchedDN, referralURLs, serverSASLCredentials);
                break;
            }
            case COMPARE: {
                protocolOp = new CompareResponseProtocolOp(resultCode.getIntValue(), errorMessage.toString(), matchedDN, referralURLs);
                break;
            }
            case DELETE: {
                protocolOp = new DeleteResponseProtocolOp(resultCode.getIntValue(), errorMessage.toString(), matchedDN, referralURLs);
                break;
            }
            case EXTENDED: {
                if (this.ldapVersion == 2) {
                    ErrorLogger.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_WARNING, 2293966, this.getConnectionID(), String.valueOf(operation));
                    return null;
                }
                ExtendedOperationBasis extOp = (ExtendedOperationBasis)operation;
                protocolOp = new ExtendedResponseProtocolOp(resultCode.getIntValue(), errorMessage.toString(), matchedDN, referralURLs, extOp.getResponseOID(), extOp.getResponseValue());
                break;
            }
            case MODIFY: {
                protocolOp = new ModifyResponseProtocolOp(resultCode.getIntValue(), errorMessage.toString(), matchedDN, referralURLs);
                break;
            }
            case MODIFY_DN: {
                protocolOp = new ModifyDNResponseProtocolOp(resultCode.getIntValue(), errorMessage.toString(), matchedDN, referralURLs);
                break;
            }
            case SEARCH: {
                protocolOp = new SearchResultDoneProtocolOp(resultCode.getIntValue(), errorMessage.toString(), matchedDN, referralURLs);
                break;
            }
            default: {
                ErrorLogger.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_ERROR, 2293920, String.valueOf(operation));
                return null;
            }
        }
        if (this.ldapVersion == 2) {
            controls = null;
        } else {
            List<Control> responseControls = operation.getResponseControls();
            if (responseControls == null || responseControls.isEmpty()) {
                controls = null;
            } else {
                controls = new ArrayList<LDAPControl>(responseControls.size());
                for (Control c : responseControls) {
                    controls.add(new LDAPControl(c));
                }
            }
        }
        return new LDAPMessage(operation.getMessageID(), protocolOp, controls);
    }

    @Override
    public void sendSearchEntry(SearchOperation searchOperation, SearchResultEntry searchEntry) {
        ArrayList<LDAPControl> controls;
        SearchResultEntryProtocolOp protocolOp = new SearchResultEntryProtocolOp(searchEntry);
        List<Control> entryControls = searchEntry.getControls();
        if (entryControls == null || entryControls.isEmpty()) {
            controls = null;
        } else {
            controls = new ArrayList<LDAPControl>(entryControls.size());
            for (Control c : entryControls) {
                controls.add(new LDAPControl(c));
            }
        }
        this.sendLDAPMessage(this.securityProvider, new LDAPMessage(searchOperation.getMessageID(), protocolOp, controls));
    }

    @Override
    public boolean sendSearchReference(SearchOperation searchOperation, SearchResultReference searchReference) {
        ArrayList<LDAPControl> controls;
        if (this.ldapVersion == 2) {
            int msgID = 2293967;
            String message = MessageHandler.getMessage(msgID, this.getConnectionID(), searchOperation.getOperationID(), String.valueOf(searchReference));
            ErrorLogger.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_WARNING, message, msgID);
            return false;
        }
        SearchResultReferenceProtocolOp protocolOp = new SearchResultReferenceProtocolOp(searchReference);
        List<Control> referenceControls = searchReference.getControls();
        if (referenceControls == null || referenceControls.isEmpty()) {
            controls = null;
        } else {
            controls = new ArrayList<LDAPControl>(referenceControls.size());
            for (Control c : referenceControls) {
                controls.add(new LDAPControl(c));
            }
        }
        this.sendLDAPMessage(this.securityProvider, new LDAPMessage(searchOperation.getMessageID(), protocolOp, controls));
        return true;
    }

    @Override
    protected boolean sendIntermediateResponseMessage(IntermediateResponse intermediateResponse) {
        IntermediateResponseProtocolOp protocolOp = new IntermediateResponseProtocolOp(intermediateResponse.getOID(), intermediateResponse.getValue());
        Operation operation = intermediateResponse.getOperation();
        List<Control> controls = intermediateResponse.getControls();
        ArrayList<LDAPControl> ldapControls = new ArrayList<LDAPControl>(controls.size());
        for (Control c : controls) {
            ldapControls.add(new LDAPControl(c));
        }
        LDAPMessage message = new LDAPMessage(operation.getMessageID(), protocolOp, ldapControls);
        this.sendLDAPMessage(this.securityProvider, message);
        return this.connectionValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLDAPMessage(ConnectionSecurityProvider secProvider, LDAPMessage message) {
        ASN1Element messageElement = message.encode();
        ByteBuffer messageBuffer = ByteBuffer.wrap(messageElement.encode());
        this.transmitLock.lock();
        try {
            int bytesWritten = messageBuffer.limit() - messageBuffer.position();
            if (!secProvider.writeData(messageBuffer)) {
                return;
            }
            try {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, message);
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, messageElement);
                messageBuffer.rewind();
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugData(DebugLogLevel.VERBOSE, messageBuffer);
                }
                if (this.keepStats) {
                    this.statTracker.updateMessageWritten(message, bytesWritten);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.disconnect(DisconnectReason.SERVER_ERROR, true, -1, String.valueOf(e), StaticUtils.getBacktrace(e));
                return;
            }
        }
        finally {
            this.transmitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(DisconnectReason disconnectReason, boolean sendNotification, String message, int messageID) {
        block32: {
            block31: {
                block30: {
                    if (this.disconnectRequested) {
                        return;
                    }
                    if (this.keepStats) {
                        this.statTracker.updateDisconnect();
                    }
                    if (this.connectionID >= 0L) {
                        DirectoryServer.connectionClosed(this);
                    }
                    this.connectionValid = false;
                    this.opsInProgressLock.lock();
                    try {
                        this.disconnectRequested = true;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    finally {
                        this.opsInProgressLock.unlock();
                    }
                    this.cancelAllOperations(new CancelRequest(true, message));
                    this.finalizeConnectionInternal();
                    if (sendNotification && this.ldapVersion != 2) {
                        try {
                            int resultCode;
                            switch (disconnectReason) {
                                case PROTOCOL_ERROR: {
                                    resultCode = 2;
                                    break;
                                }
                                case SERVER_SHUTDOWN: {
                                    resultCode = 52;
                                    break;
                                }
                                case SERVER_ERROR: {
                                    resultCode = DirectoryServer.getServerErrorResultCode().getIntValue();
                                    break;
                                }
                                case ADMIN_LIMIT_EXCEEDED: 
                                case IDLE_TIME_LIMIT_EXCEEDED: 
                                case MAX_REQUEST_SIZE_EXCEEDED: 
                                case IO_TIMEOUT: {
                                    resultCode = 11;
                                    break;
                                }
                                case CONNECTION_REJECTED: {
                                    resultCode = 19;
                                    break;
                                }
                                default: {
                                    resultCode = 80;
                                }
                            }
                            String errMsg = message == null ? MessageHandler.getMessage(2097317) : message;
                            ExtendedResponseProtocolOp notificationOp = new ExtendedResponseProtocolOp(resultCode, errMsg, null, null, "1.3.6.1.4.1.1466.20036", null);
                            byte[] messageBytes = new LDAPMessage(0, notificationOp, null).encode().encode();
                            ByteBuffer buffer = ByteBuffer.wrap(messageBytes);
                            try {
                                this.securityProvider.writeData(buffer);
                            }
                            catch (Exception e) {}
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    try {
                        this.securityProvider.disconnect(sendNotification);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block30;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                try {
                    this.clientChannel.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block31;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (messageID == -1) {
                AccessLogger.logDisconnect(this, disconnectReason, null);
            } else {
                AccessLogger.logDisconnect(this, disconnectReason, message);
            }
            try {
                PluginConfigManager pluginManager = DirectoryServer.getPluginConfigManager();
                pluginManager.invokePostDisconnectPlugins(this, disconnectReason, messageID, message);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block32;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public Collection<AbstractOperation> getOperationsInProgress() {
        return this.operationsInProgress.values();
    }

    @Override
    public AbstractOperation getOperationInProgress(int messageID) {
        return this.operationsInProgress.get(messageID);
    }

    public void addOperationInProgress(AbstractOperation operation) throws DirectoryException {
        int messageID = operation.getMessageID();
        this.opsInProgressLock.lock();
        try {
            if (this.disconnectRequested) {
                int msgID = 2162854;
                String message = MessageHandler.getMessage(msgID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            AbstractOperation op = this.operationsInProgress.get(messageID);
            if (op != null) {
                int msgID = 2163033;
                String message = MessageHandler.getMessage(msgID, messageID);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
            }
            this.operationsInProgress.put(messageID, operation);
            DirectoryServer.enqueueRequest(operation);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.operationsInProgress.remove(messageID);
            this.lastCompletionTime.set(TimeThread.getTime());
            throw de;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2163034;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        finally {
            this.opsInProgressLock.unlock();
        }
    }

    @Override
    public boolean removeOperationInProgress(int messageID) {
        AbstractOperation operation = this.operationsInProgress.remove(messageID);
        if (operation == null) {
            return false;
        }
        this.lastCompletionTime.set(TimeThread.getTime());
        return true;
    }

    @Override
    public CancelResult cancelOperation(int messageID, CancelRequest cancelRequest) {
        AbstractOperation op = this.operationsInProgress.get(messageID);
        if (op == null) {
            for (PersistentSearch ps : this.getPersistentSearches()) {
                if (ps.getSearchOperation().getMessageID() != messageID) continue;
                CancelResult cancelResult = ps.getSearchOperation().cancel(cancelRequest);
                if (this.keepStats && cancelResult == CancelResult.CANCELED) {
                    this.statTracker.updateAbandonedOperation();
                }
                return cancelResult;
            }
            return CancelResult.NO_SUCH_OPERATION;
        }
        CancelResult cancelResult = op.cancel(cancelRequest);
        if (this.keepStats && cancelResult == CancelResult.CANCELED) {
            this.statTracker.updateAbandonedOperation();
        }
        return op.cancel(cancelRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllOperations(CancelRequest cancelRequest) {
        this.opsInProgressLock.lock();
        try {
            for (AbstractOperation o : this.operationsInProgress.values()) {
                try {
                    CancelResult cancelResult = o.cancel(cancelRequest);
                    if (!this.keepStats || cancelResult != CancelResult.CANCELED) continue;
                    this.statTracker.updateAbandonedOperation();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (!this.operationsInProgress.isEmpty() || !this.getPersistentSearches().isEmpty()) {
                this.lastCompletionTime.set(TimeThread.getTime());
            }
            this.operationsInProgress.clear();
            for (PersistentSearch persistentSearch : this.getPersistentSearches()) {
                DirectoryServer.deregisterPersistentSearch(persistentSearch);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.opsInProgressLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllOperationsExcept(CancelRequest cancelRequest, int messageID) {
        this.opsInProgressLock.lock();
        try {
            Iterator<Object> i$ = this.operationsInProgress.keySet().iterator();
            while (i$.hasNext()) {
                int msgID;
                block12: {
                    msgID = (Integer)i$.next();
                    if (msgID == messageID) continue;
                    AbstractOperation o = this.operationsInProgress.get(msgID);
                    if (o != null) {
                        try {
                            CancelResult cancelResult = o.cancel(cancelRequest);
                            if (this.keepStats && cancelResult == CancelResult.CANCELED) {
                                this.statTracker.updateAbandonedOperation();
                            }
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block12;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
                this.operationsInProgress.remove(msgID);
                this.lastCompletionTime.set(TimeThread.getTime());
            }
            for (PersistentSearch persistentSearch : this.getPersistentSearches()) {
                DirectoryServer.deregisterPersistentSearch(persistentSearch);
                this.lastCompletionTime.set(TimeThread.getTime());
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.opsInProgressLock.unlock();
        }
    }

    @Override
    public boolean processDataRead(ByteBuffer buffer) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugData(DebugLogLevel.VERBOSE, buffer);
        }
        int bytesAvailable = buffer.limit() - buffer.position();
        if (this.keepStats) {
            this.statTracker.updateBytesRead(bytesAvailable);
        }
        block10: while (bytesAvailable > 0) {
            switch (this.elementReadState) {
                case 0: {
                    this.elementType = buffer.get();
                    --bytesAvailable;
                    this.elementReadState = 1;
                    continue block10;
                }
                case 1: {
                    byte firstLengthByte = buffer.get();
                    --bytesAvailable;
                    this.elementLengthBytesNeeded = firstLengthByte & 0x7F;
                    if (this.elementLengthBytesNeeded == firstLengthByte) {
                        this.elementLength = firstLengthByte;
                        if (this.elementLength == 0) {
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293927, new Object[0]);
                            return false;
                        }
                        if (this.connectionHandler.getMaxRequestSize() > 0 && this.elementLength > this.connectionHandler.getMaxRequestSize()) {
                            this.disconnect(DisconnectReason.MAX_REQUEST_SIZE_EXCEEDED, true, 2293928, this.elementLength, this.connectionHandler.getMaxRequestSize());
                            return false;
                        }
                        this.elementValue = new byte[this.elementLength];
                        this.elementValueBytesRead = 0;
                        this.elementValueBytesNeeded = this.elementLength;
                        this.elementReadState = 3;
                        continue block10;
                    }
                    if (this.elementLengthBytesNeeded > 4) {
                        this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293929, this.elementLengthBytesNeeded);
                        return false;
                    }
                    this.elementLength = 0;
                    if (this.elementLengthBytesNeeded <= bytesAvailable) {
                        while (this.elementLengthBytesNeeded > 0) {
                            this.elementLength = this.elementLength << 8 | buffer.get() & 0xFF;
                            --bytesAvailable;
                            --this.elementLengthBytesNeeded;
                        }
                        if (this.elementLength == 0) {
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293927, new Object[0]);
                            return false;
                        }
                        if (this.connectionHandler.getMaxRequestSize() > 0 && this.elementLength > this.connectionHandler.getMaxRequestSize()) {
                            this.disconnect(DisconnectReason.MAX_REQUEST_SIZE_EXCEEDED, true, 2293928, this.elementLength, this.connectionHandler.getMaxRequestSize());
                            return false;
                        }
                        this.elementValue = new byte[this.elementLength];
                        this.elementValueBytesRead = 0;
                        this.elementValueBytesNeeded = this.elementLength;
                        this.elementReadState = 3;
                        continue block10;
                    }
                    while (bytesAvailable > 0) {
                        this.elementLength = this.elementLength << 8 | buffer.get() & 0xFF;
                        --bytesAvailable;
                        --this.elementLengthBytesNeeded;
                    }
                    return true;
                }
                case 2: {
                    if (bytesAvailable >= this.elementLengthBytesNeeded) {
                        while (this.elementLengthBytesNeeded > 0) {
                            this.elementLength = this.elementLength << 8 | buffer.get() & 0xFF;
                            --bytesAvailable;
                            --this.elementLengthBytesNeeded;
                        }
                        if (this.elementLength == 0) {
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293927, new Object[0]);
                            return false;
                        }
                        if (this.connectionHandler.getMaxRequestSize() > 0 && this.elementLength > this.connectionHandler.getMaxRequestSize()) {
                            this.disconnect(DisconnectReason.MAX_REQUEST_SIZE_EXCEEDED, true, 2293928, this.elementLength, this.connectionHandler.getMaxRequestSize());
                            return false;
                        }
                        this.elementValue = new byte[this.elementLength];
                        this.elementValueBytesRead = 0;
                        this.elementValueBytesNeeded = this.elementLength;
                        this.elementReadState = 3;
                        continue block10;
                    }
                    while (bytesAvailable > 0) {
                        this.elementLength = this.elementLength << 8 | buffer.get() & 0xFF;
                        --bytesAvailable;
                        --this.elementLengthBytesNeeded;
                    }
                    return true;
                }
                case 3: {
                    if (bytesAvailable >= this.elementValueBytesNeeded) {
                        LDAPMessage requestMessage;
                        ASN1Sequence requestSequence;
                        buffer.get(this.elementValue, this.elementValueBytesRead, this.elementValueBytesNeeded);
                        this.elementValueBytesRead += this.elementValueBytesNeeded;
                        bytesAvailable -= this.elementValueBytesNeeded;
                        this.elementReadState = 0;
                        try {
                            requestSequence = ASN1Sequence.decodeAsSequence(this.elementType, this.elementValue);
                            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, requestSequence);
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293930, String.valueOf(e));
                            return false;
                        }
                        try {
                            requestMessage = LDAPMessage.decode(requestSequence);
                            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, requestMessage);
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293931, String.valueOf(e));
                            return false;
                        }
                        if (this.processLDAPMessage(requestMessage)) continue block10;
                        return false;
                    }
                    buffer.get(this.elementValue, this.elementValueBytesRead, bytesAvailable);
                    this.elementValueBytesRead += bytesAvailable;
                    this.elementValueBytesNeeded -= bytesAvailable;
                    return true;
                }
            }
            int msgID = 2359468;
            String message = MessageHandler.getMessage(msgID, this.elementReadState);
            ErrorLogger.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            this.disconnect(DisconnectReason.SERVER_ERROR, true, message, msgID);
            return false;
        }
        return true;
    }

    private boolean processLDAPMessage(LDAPMessage message) {
        ArrayList<Control> opControls;
        ArrayList<LDAPControl> ldapControls;
        if (this.keepStats) {
            this.statTracker.updateMessageRead(message);
        }
        if ((ldapControls = message.getControls()) == null || ldapControls.isEmpty()) {
            opControls = null;
        } else {
            opControls = new ArrayList<Control>(ldapControls.size());
            for (LDAPControl c : ldapControls) {
                opControls.add(c.getControl());
            }
        }
        try {
            switch (message.getProtocolOpType()) {
                case 80: {
                    return this.processAbandonRequest(message, opControls);
                }
                case 104: {
                    return this.processAddRequest(message, opControls);
                }
                case 96: {
                    return this.processBindRequest(message, opControls);
                }
                case 110: {
                    return this.processCompareRequest(message, opControls);
                }
                case 74: {
                    return this.processDeleteRequest(message, opControls);
                }
                case 119: {
                    return this.processExtendedRequest(message, opControls);
                }
                case 102: {
                    return this.processModifyRequest(message, opControls);
                }
                case 108: {
                    return this.processModifyDNRequest(message, opControls);
                }
                case 99: {
                    return this.processSearchRequest(message, opControls);
                }
                case 66: {
                    return this.processUnbindRequest(message, opControls);
                }
            }
            int msgID = 2293962;
            String msg = MessageHandler.getMessage(msgID, message.getProtocolOpName(), message.getMessageID());
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, msg, msgID);
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2359499;
            String msg = MessageHandler.getMessage(msgID, message.getProtocolOpName(), message.getMessageID(), String.valueOf(e));
            this.disconnect(DisconnectReason.SERVER_ERROR, true, msg, msgID);
            return false;
        }
    }

    private boolean processAbandonRequest(LDAPMessage message, ArrayList<Control> controls) {
        AbandonRequestProtocolOp protocolOp = message.getAbandonRequestProtocolOp();
        AbandonOperationBasis abandonOp = new AbandonOperationBasis(this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getIDToAbandon());
        abandonOp.run();
        if (this.keepStats && abandonOp.getResultCode() == ResultCode.CANCELED) {
            this.statTracker.updateAbandonedOperation();
        }
        return this.connectionValid;
    }

    private boolean processAddRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            AddResponseProtocolOp responseOp = new AddResponseProtocolOp(2, MessageHandler.getMessage(2294191));
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, 2294191, new Object[0]);
            return false;
        }
        AddRequestProtocolOp protocolOp = message.getAddRequestProtocolOp();
        AddOperationBasis addOp = new AddOperationBasis(this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN(), protocolOp.getAttributes());
        try {
            this.addOperationInProgress(addOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            AddResponseProtocolOp responseOp = new AddResponseProtocolOp(de.getResultCode().getIntValue(), de.getErrorMessage(), de.getMatchedDN(), de.getReferralURLs());
            List responseControls = addOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processBindRequest(LDAPMessage message, ArrayList<Control> controls) {
        block13: {
            BindOperationBasis bindOp;
            String versionString;
            BindRequestProtocolOp protocolOp = message.getBindRequestProtocolOp();
            this.ldapVersion = protocolOp.getProtocolVersion();
            switch (this.ldapVersion) {
                case 2: {
                    versionString = "2";
                    if (!this.connectionHandler.allowLDAPv2()) {
                        BindResponseProtocolOp responseOp = new BindResponseProtocolOp(48, MessageHandler.getMessage(2293970));
                        this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
                        this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, 2293970, new Object[0]);
                        return false;
                    }
                    if (controls == null || controls.isEmpty()) break;
                    BindResponseProtocolOp responseOp = new BindResponseProtocolOp(2, MessageHandler.getMessage(2294191));
                    this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
                    this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, 2294191, new Object[0]);
                    return false;
                }
                case 3: {
                    versionString = "3";
                    break;
                }
                default: {
                    versionString = String.valueOf(this.ldapVersion);
                }
            }
            ASN1OctetString bindDN = protocolOp.getDN();
            switch (protocolOp.getAuthenticationType()) {
                case SIMPLE: {
                    bindOp = new BindOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, versionString, bindDN, (ByteString)protocolOp.getSimplePassword());
                    break;
                }
                case SASL: {
                    bindOp = new BindOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, versionString, bindDN, protocolOp.getSASLMechanism(), protocolOp.getSASLCredentials());
                    break;
                }
                default: {
                    int msgID = 2293964;
                    String msg = MessageHandler.getMessage(msgID, message.getMessageID(), String.valueOf((Object)protocolOp.getAuthenticationType()));
                    this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, msg, msgID);
                    return false;
                }
            }
            try {
                this.addOperationInProgress(bindOp);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                BindResponseProtocolOp responseOp = new BindResponseProtocolOp(de.getResultCode().getIntValue(), de.getErrorMessage(), de.getMatchedDN(), de.getReferralURLs());
                List<Control> responseControls = bindOp.getResponseControls();
                ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
                for (Control c : responseControls) {
                    responseLDAPControls.add(new LDAPControl(c));
                }
                this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
                if (de.getResultCode() != ResultCode.PROTOCOL_ERROR) break block13;
                int msgID = 2293965;
                String msg = MessageHandler.getMessage(msgID, message.getMessageID(), de.getErrorMessage());
                this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, msg, msgID);
            }
        }
        return this.connectionValid;
    }

    private boolean processCompareRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            CompareResponseProtocolOp responseOp = new CompareResponseProtocolOp(2, MessageHandler.getMessage(2294191));
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, 2294191, new Object[0]);
            return false;
        }
        CompareRequestProtocolOp protocolOp = message.getCompareRequestProtocolOp();
        CompareOperationBasis compareOp = new CompareOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN(), protocolOp.getAttributeType(), (ByteString)protocolOp.getAssertionValue());
        try {
            this.addOperationInProgress(compareOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            CompareResponseProtocolOp responseOp = new CompareResponseProtocolOp(de.getResultCode().getIntValue(), de.getErrorMessage(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = compareOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processDeleteRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            DeleteResponseProtocolOp responseOp = new DeleteResponseProtocolOp(2, MessageHandler.getMessage(2294191));
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, 2294191, new Object[0]);
            return false;
        }
        DeleteRequestProtocolOp protocolOp = message.getDeleteRequestProtocolOp();
        DeleteOperationBasis deleteOp = new DeleteOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN());
        try {
            this.addOperationInProgress(deleteOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            DeleteResponseProtocolOp responseOp = new DeleteResponseProtocolOp(de.getResultCode().getIntValue(), de.getErrorMessage(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = deleteOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processExtendedRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2) {
            int msgID = 2293971;
            String msg = MessageHandler.getMessage(msgID, this.getConnectionID(), message.getMessageID());
            ErrorLogger.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_ERROR, msg, msgID);
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, msg, msgID);
            return false;
        }
        ExtendedRequestProtocolOp protocolOp = message.getExtendedRequestProtocolOp();
        ExtendedOperationBasis extendedOp = new ExtendedOperationBasis(this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getOID(), protocolOp.getValue());
        try {
            this.addOperationInProgress(extendedOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            ExtendedResponseProtocolOp responseOp = new ExtendedResponseProtocolOp(de.getResultCode().getIntValue(), de.getErrorMessage(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = extendedOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processModifyRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            ModifyResponseProtocolOp responseOp = new ModifyResponseProtocolOp(2, MessageHandler.getMessage(2294191));
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, 2294191, new Object[0]);
            return false;
        }
        ModifyRequestProtocolOp protocolOp = message.getModifyRequestProtocolOp();
        ModifyOperationBasis modifyOp = new ModifyOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN(), protocolOp.getModifications());
        try {
            this.addOperationInProgress(modifyOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            ModifyResponseProtocolOp responseOp = new ModifyResponseProtocolOp(de.getResultCode().getIntValue(), de.getErrorMessage(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = modifyOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processModifyDNRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            ModifyDNResponseProtocolOp responseOp = new ModifyDNResponseProtocolOp(2, MessageHandler.getMessage(2294191));
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, 2294191, new Object[0]);
            return false;
        }
        ModifyDNRequestProtocolOp protocolOp = message.getModifyDNRequestProtocolOp();
        ModifyDNOperationBasis modifyDNOp = new ModifyDNOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getEntryDN(), protocolOp.getNewRDN(), protocolOp.deleteOldRDN(), protocolOp.getNewSuperior());
        try {
            this.addOperationInProgress(modifyDNOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            ModifyDNResponseProtocolOp responseOp = new ModifyDNResponseProtocolOp(de.getResultCode().getIntValue(), de.getErrorMessage(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = modifyDNOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processSearchRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            SearchResultDoneProtocolOp responseOp = new SearchResultDoneProtocolOp(2, MessageHandler.getMessage(2294191));
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, 2294191, new Object[0]);
            return false;
        }
        SearchRequestProtocolOp protocolOp = message.getSearchRequestProtocolOp();
        SearchOperationBasis searchOp = new SearchOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getBaseDN(), protocolOp.getScope(), protocolOp.getDereferencePolicy(), protocolOp.getSizeLimit(), protocolOp.getTimeLimit(), protocolOp.getTypesOnly(), protocolOp.getFilter(), protocolOp.getAttributes());
        try {
            this.addOperationInProgress(searchOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            SearchResultDoneProtocolOp responseOp = new SearchResultDoneProtocolOp(de.getResultCode().getIntValue(), de.getErrorMessage(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = searchOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processUnbindRequest(LDAPMessage message, ArrayList<Control> controls) {
        UnbindOperationBasis unbindOp = new UnbindOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls);
        unbindOp.run();
        return false;
    }

    @Override
    public String getMonitorSummary() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("connID=\"");
        buffer.append(this.connectionID);
        buffer.append("\" connectTime=\"");
        buffer.append(this.getConnectTimeString());
        buffer.append("\" source=\"");
        buffer.append(this.clientAddress);
        buffer.append(":");
        buffer.append(this.clientPort);
        buffer.append("\" destination=\"");
        buffer.append(this.serverAddress);
        buffer.append(":");
        buffer.append(this.connectionHandler.getListenPort());
        buffer.append("\" ldapVersion=\"");
        buffer.append(this.ldapVersion);
        buffer.append("\" authDN=\"");
        DN authDN = this.getAuthenticationInfo().getAuthenticationDN();
        if (authDN != null) {
            authDN.toString(buffer);
        }
        buffer.append("\" security=\"");
        if (this.securityProvider.isSecure()) {
            buffer.append(this.securityProvider.getSecurityMechanismName());
        } else {
            buffer.append("none");
        }
        buffer.append("\" opsInProgress=\"");
        buffer.append(this.operationsInProgress.size());
        buffer.append("\"");
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAP client connection from ");
        buffer.append(this.clientAddress);
        buffer.append(":");
        buffer.append(this.clientPort);
        buffer.append(" to ");
        buffer.append(this.serverAddress);
        buffer.append(":");
        buffer.append(this.serverPort);
    }

    @Override
    public boolean tlsProtectionAvailable(StringBuilder unavailableReason) {
        if (!(this.securityProvider instanceof NullConnectionSecurityProvider)) {
            int msgID = 2294031;
            unavailableReason.append(MessageHandler.getMessage(msgID, this.securityProvider.getSecurityMechanismName()));
            return false;
        }
        if (!this.connectionHandler.allowStartTLS()) {
            int msgID = 2294032;
            unavailableReason.append(MessageHandler.getMessage(msgID));
            return false;
        }
        if (this.tlsSecurityProvider == null) {
            try {
                TLSConnectionSecurityProvider tlsProvider = new TLSConnectionSecurityProvider();
                tlsProvider.initializeConnectionSecurityProvider(null);
                tlsProvider.setSSLClientAuthPolicy(this.connectionHandler.getSSLClientAuthPolicy());
                tlsProvider.setEnabledProtocols(this.connectionHandler.getEnabledSSLProtocols());
                tlsProvider.setEnabledCipherSuites(this.connectionHandler.getEnabledSSLCipherSuites());
                this.tlsSecurityProvider = (TLSConnectionSecurityProvider)tlsProvider.newInstance(this, this.clientChannel);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.tlsSecurityProvider = null;
                int msgID = 2294033;
                unavailableReason.append(MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e)));
                return false;
            }
        }
        return true;
    }

    @Override
    public void enableTLSConnectionSecurityProvider() throws DirectoryException {
        if (this.tlsSecurityProvider == null) {
            int msgID = 2294034;
            String message = MessageHandler.getMessage(msgID);
            this.disconnect(DisconnectReason.OTHER, false, message, msgID);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        this.clearSecurityProvider = this.securityProvider;
        this.setConnectionSecurityProvider(this.tlsSecurityProvider);
    }

    @Override
    public void disableTLSConnectionSecurityProvider() throws DirectoryException {
        int msgID = 2294035;
        String message = MessageHandler.getMessage(msgID);
        this.disconnect(DisconnectReason.OTHER, false, message, msgID);
        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
    }

    @Override
    public void sendClearResponse(Operation operation) throws DirectoryException {
        if (this.clearSecurityProvider == null) {
            int msgID = 2294143;
            String message = MessageHandler.getMessage(msgID, this.toString());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        this.sendLDAPMessage(this.clearSecurityProvider, this.operationToResponseLDAPMessage(operation));
    }

    @Override
    public DN getKeyManagerProviderDN() {
        return this.connectionHandler.getKeyManagerProviderDN();
    }

    @Override
    public DN getTrustManagerProviderDN() {
        return this.connectionHandler.getTrustManagerProviderDN();
    }

    @Override
    public String getCertificateAlias() {
        return this.connectionHandler.getSSLServerCertNickname();
    }

    @Override
    public long getIdleTime() {
        if (this.operationsInProgress.isEmpty() && this.getPersistentSearches().isEmpty()) {
            return TimeThread.getTime() - this.lastCompletionTime.get();
        }
        return 0L;
    }
}

