/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPControl {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Control control;

    public LDAPControl(Control control) {
        this.control = control;
    }

    public LDAPControl(String oid) {
        this.control = new Control(oid, false);
    }

    public LDAPControl(String oid, boolean isCritical) {
        this.control = new Control(oid, isCritical);
    }

    public LDAPControl(String oid, boolean isCritical, ASN1OctetString value) {
        this.control = new Control(oid, isCritical, value);
    }

    public Control getControl() {
        return this.control;
    }

    public ASN1Element encode() {
        ASN1OctetString value;
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(new ASN1OctetString(this.control.getOID()));
        if (this.control.isCritical()) {
            elements.add(new ASN1Boolean(this.control.isCritical()));
        }
        if ((value = this.control.getValue()) != null) {
            elements.add(value);
        }
        return new ASN1Sequence(elements);
    }

    public static ASN1Element encodeControls(ArrayList<LDAPControl> controls) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(controls.size());
        for (LDAPControl c : controls) {
            elements.add(c.encode());
        }
        return new ASN1Sequence(-96, elements);
    }

    public static LDAPControl decode(ASN1Element element) throws LDAPException {
        ASN1OctetString value;
        boolean isCritical;
        String oid;
        ArrayList<ASN1Element> elements;
        if (element == null) {
            int msgID = 0x230032;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 0x230033;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        int numElements = elements.size();
        if (numElements < 1 || numElements > 3) {
            int msgID = 2293812;
            String message = MessageHandler.getMessage(msgID, numElements);
            throw new LDAPException(2, msgID, message);
        }
        try {
            oid = elements.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293813;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        if (numElements == 1) {
            return new LDAPControl(oid);
        }
        if (numElements == 2) {
            boolean isCritical2;
            ASN1OctetString value2;
            ASN1Element e = elements.get(1);
            switch (e.getType()) {
                case 1: {
                    value2 = null;
                    try {
                        isCritical2 = e.decodeAsBoolean().booleanValue();
                        break;
                    }
                    catch (Exception e2) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                        }
                        int msgID = 2293814;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(e));
                        throw new LDAPException(2, msgID, message, e2);
                    }
                }
                case 4: {
                    isCritical2 = false;
                    try {
                        value2 = e.decodeAsOctetString();
                        break;
                    }
                    catch (Exception e2) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                        }
                        int msgID = 2293815;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(e));
                        throw new LDAPException(2, msgID, message, e2);
                    }
                }
                default: {
                    int msgID = 2293816;
                    String message = MessageHandler.getMessage(msgID, e.getType());
                    throw new LDAPException(2, msgID, message);
                }
            }
            return new LDAPControl(oid, isCritical2, value2);
        }
        try {
            isCritical = elements.get(1).decodeAsBoolean().booleanValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293814;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            value = elements.get(2).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293815;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new LDAPControl(oid, isCritical, value);
    }

    public static ArrayList<LDAPControl> decodeControls(ASN1Element element) throws LDAPException {
        ArrayList<ASN1Element> elements;
        if (element == null) {
            int msgID = 2293817;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            int msgID = 2293818;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        ArrayList<LDAPControl> controls = new ArrayList<LDAPControl>(elements.size());
        for (ASN1Element e : elements) {
            controls.add(LDAPControl.decode(e));
        }
        return controls;
    }

    public String getOID() {
        return this.control.getOID();
    }

    public boolean isCritical() {
        return this.control.isCritical();
    }

    public ASN1OctetString getValue() {
        return this.control.getValue();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPControl(oid=");
        buffer.append(this.control.getOID());
        buffer.append(", criticality=");
        buffer.append(this.control.isCritical());
        ASN1OctetString value = this.control.getValue();
        if (value != null) {
            buffer.append(", value=");
            buffer.append(String.valueOf(value));
        }
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("LDAP Control");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  OID:  ");
        buffer.append(this.control.getOID());
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Criticality:  ");
        buffer.append(this.control.isCritical());
        buffer.append(ServerConstants.EOL);
        ASN1OctetString value = this.control.getValue();
        if (value != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Value:");
            value.toString(buffer, indent + 4);
        }
    }
}

