/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import org.opends.server.api.ProtocolElement;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPMessage
implements ProtocolElement {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ArrayList<LDAPControl> controls;
    private int messageID;
    private ProtocolOp protocolOp;

    public LDAPMessage(int messageID, ProtocolOp protocolOp) {
        this.messageID = messageID;
        this.protocolOp = protocolOp;
        this.controls = new ArrayList(0);
    }

    public LDAPMessage(int messageID, ProtocolOp protocolOp, ArrayList<LDAPControl> controls) {
        this.messageID = messageID;
        this.protocolOp = protocolOp;
        this.controls = controls == null ? new ArrayList(0) : controls;
    }

    public int getMessageID() {
        return this.messageID;
    }

    public void setMessageID(int messageID) {
        this.messageID = messageID;
    }

    public ProtocolOp getProtocolOp() {
        return this.protocolOp;
    }

    public byte getProtocolOpType() {
        return this.protocolOp.getType();
    }

    public String getProtocolOpName() {
        return this.protocolOp.getProtocolOpName();
    }

    public AbandonRequestProtocolOp getAbandonRequestProtocolOp() throws ClassCastException {
        return (AbandonRequestProtocolOp)this.protocolOp;
    }

    public AddRequestProtocolOp getAddRequestProtocolOp() throws ClassCastException {
        return (AddRequestProtocolOp)this.protocolOp;
    }

    public AddResponseProtocolOp getAddResponseProtocolOp() throws ClassCastException {
        return (AddResponseProtocolOp)this.protocolOp;
    }

    public BindRequestProtocolOp getBindRequestProtocolOp() throws ClassCastException {
        return (BindRequestProtocolOp)this.protocolOp;
    }

    public BindResponseProtocolOp getBindResponseProtocolOp() throws ClassCastException {
        return (BindResponseProtocolOp)this.protocolOp;
    }

    public CompareRequestProtocolOp getCompareRequestProtocolOp() throws ClassCastException {
        return (CompareRequestProtocolOp)this.protocolOp;
    }

    public CompareResponseProtocolOp getCompareResponseProtocolOp() throws ClassCastException {
        return (CompareResponseProtocolOp)this.protocolOp;
    }

    public DeleteRequestProtocolOp getDeleteRequestProtocolOp() throws ClassCastException {
        return (DeleteRequestProtocolOp)this.protocolOp;
    }

    public DeleteResponseProtocolOp getDeleteResponseProtocolOp() throws ClassCastException {
        return (DeleteResponseProtocolOp)this.protocolOp;
    }

    public ExtendedRequestProtocolOp getExtendedRequestProtocolOp() throws ClassCastException {
        return (ExtendedRequestProtocolOp)this.protocolOp;
    }

    public ExtendedResponseProtocolOp getExtendedResponseProtocolOp() throws ClassCastException {
        return (ExtendedResponseProtocolOp)this.protocolOp;
    }

    public ModifyRequestProtocolOp getModifyRequestProtocolOp() throws ClassCastException {
        return (ModifyRequestProtocolOp)this.protocolOp;
    }

    public ModifyResponseProtocolOp getModifyResponseProtocolOp() throws ClassCastException {
        return (ModifyResponseProtocolOp)this.protocolOp;
    }

    public ModifyDNRequestProtocolOp getModifyDNRequestProtocolOp() throws ClassCastException {
        return (ModifyDNRequestProtocolOp)this.protocolOp;
    }

    public ModifyDNResponseProtocolOp getModifyDNResponseProtocolOp() throws ClassCastException {
        return (ModifyDNResponseProtocolOp)this.protocolOp;
    }

    public SearchRequestProtocolOp getSearchRequestProtocolOp() throws ClassCastException {
        return (SearchRequestProtocolOp)this.protocolOp;
    }

    public SearchResultDoneProtocolOp getSearchResultDoneProtocolOp() throws ClassCastException {
        return (SearchResultDoneProtocolOp)this.protocolOp;
    }

    public SearchResultEntryProtocolOp getSearchResultEntryProtocolOp() throws ClassCastException {
        return (SearchResultEntryProtocolOp)this.protocolOp;
    }

    public SearchResultReferenceProtocolOp getSearchResultReferenceProtocolOp() throws ClassCastException {
        return (SearchResultReferenceProtocolOp)this.protocolOp;
    }

    public UnbindRequestProtocolOp getUnbindRequestProtocolOp() throws ClassCastException {
        return (UnbindRequestProtocolOp)this.protocolOp;
    }

    public void setProtocolOp(ProtocolOp protocolOp) {
        this.protocolOp = protocolOp;
    }

    public ArrayList<LDAPControl> getControls() {
        return this.controls;
    }

    public ASN1Element encode() {
        ArrayList<ASN1Element> messageElements = new ArrayList<ASN1Element>(3);
        messageElements.add(new ASN1Integer(this.messageID));
        messageElements.add(this.protocolOp.encode());
        if (!this.controls.isEmpty()) {
            messageElements.add(LDAPControl.encodeControls(this.controls));
        }
        return new ASN1Sequence(messageElements);
    }

    public static LDAPMessage decode(ASN1Sequence messageSequence) throws LDAPException {
        ArrayList<LDAPControl> controls;
        ProtocolOp protocolOp;
        int messageID;
        if (messageSequence == null) {
            int msgID = 2293805;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        ArrayList<ASN1Element> elements = messageSequence.elements();
        int numElements = elements.size();
        if (numElements < 2 || numElements > 3) {
            int msgID = 2293806;
            String message = MessageHandler.getMessage(msgID, numElements);
            throw new LDAPException(2, msgID, message);
        }
        try {
            messageID = elements.get(0).decodeAsInteger().intValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293807;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            protocolOp = ProtocolOp.decode(elements.get(1));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 0x230030;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        if (numElements == 3) {
            try {
                controls = LDAPControl.decodeControls(elements.get(2));
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 2293809;
                String message = MessageHandler.getMessage(msgID, String.valueOf(e));
                throw new LDAPException(2, msgID, message, e);
            }
        } else {
            controls = new ArrayList(0);
        }
        return new LDAPMessage(messageID, protocolOp, controls);
    }

    @Override
    public String getProtocolElementName() {
        return "LDAP";
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPMessage(msgID=");
        buffer.append(this.messageID);
        buffer.append(", protocolOp=");
        this.protocolOp.toString(buffer);
        if (!this.controls.isEmpty()) {
            buffer.append(", controls={ ");
            Iterator<LDAPControl> iterator = this.controls.iterator();
            iterator.next().toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(", ");
                iterator.next().toString(buffer);
            }
            buffer.append(" }");
        }
        buffer.append(")");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("LDAP Message");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Message ID:  ");
        buffer.append(this.messageID);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Protocol Op:");
        buffer.append(ServerConstants.EOL);
        this.protocolOp.toString(buffer, indent + 4);
        if (!this.controls.isEmpty()) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Controls:");
            for (LDAPControl c : this.controls) {
                c.toString(buffer, indent + 4);
            }
        }
    }
}

