/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.IntermediateResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;
import org.opends.server.types.LDAPException;

public abstract class ProtocolOp {
    public abstract byte getType();

    public abstract String getProtocolOpName();

    public abstract ASN1Element encode();

    public static ProtocolOp decode(ASN1Element element) throws LDAPException {
        if (element == null) {
            int msgID = 2293896;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        switch (element.getType()) {
            case 66: {
                return UnbindRequestProtocolOp.decodeUnbindRequest(element);
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                int msgID = 2293897;
                String message = MessageHandler.getMessage(msgID, element.getType());
                throw new LDAPException(2, msgID, message);
            }
            case 74: {
                return DeleteRequestProtocolOp.decodeDeleteRequest(element);
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                int msgID = 2293897;
                String message = MessageHandler.getMessage(msgID, element.getType());
                throw new LDAPException(2, msgID, message);
            }
            case 80: {
                return AbandonRequestProtocolOp.decodeAbandonRequest(element);
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                int msgID = 2293897;
                String message = MessageHandler.getMessage(msgID, element.getType());
                throw new LDAPException(2, msgID, message);
            }
            case 96: {
                return BindRequestProtocolOp.decodeBindRequest(element);
            }
            case 97: {
                return BindResponseProtocolOp.decodeBindResponse(element);
            }
            case 98: {
                int msgID = 2293897;
                String message = MessageHandler.getMessage(msgID, element.getType());
                throw new LDAPException(2, msgID, message);
            }
            case 99: {
                return SearchRequestProtocolOp.decodeSearchRequest(element);
            }
            case 100: {
                return SearchResultEntryProtocolOp.decodeSearchEntry(element);
            }
            case 101: {
                return SearchResultDoneProtocolOp.decodeSearchDone(element);
            }
            case 102: {
                return ModifyRequestProtocolOp.decodeModifyRequest(element);
            }
            case 103: {
                return ModifyResponseProtocolOp.decodeModifyResponse(element);
            }
            case 104: {
                return AddRequestProtocolOp.decodeAddRequest(element);
            }
            case 105: {
                return AddResponseProtocolOp.decodeAddResponse(element);
            }
            case 106: {
                int msgID = 2293897;
                String message = MessageHandler.getMessage(msgID, element.getType());
                throw new LDAPException(2, msgID, message);
            }
            case 107: {
                return DeleteResponseProtocolOp.decodeDeleteResponse(element);
            }
            case 108: {
                return ModifyDNRequestProtocolOp.decodeModifyDNRequest(element);
            }
            case 109: {
                return ModifyDNResponseProtocolOp.decodeModifyDNResponse(element);
            }
            case 110: {
                return CompareRequestProtocolOp.decodeCompareRequest(element);
            }
            case 111: {
                return CompareResponseProtocolOp.decodeCompareResponse(element);
            }
            case 112: 
            case 113: 
            case 114: {
                int msgID = 2293897;
                String message = MessageHandler.getMessage(msgID, element.getType());
                throw new LDAPException(2, msgID, message);
            }
            case 115: {
                return SearchResultReferenceProtocolOp.decodeSearchReference(element);
            }
            case 116: 
            case 117: 
            case 118: {
                int msgID = 2293897;
                String message = MessageHandler.getMessage(msgID, element.getType());
                throw new LDAPException(2, msgID, message);
            }
            case 119: {
                return ExtendedRequestProtocolOp.decodeExtendedRequest(element);
            }
            case 120: {
                return ExtendedResponseProtocolOp.decodeExtendedResponse(element);
            }
            case 121: {
                return IntermediateResponseProtocolOp.decodeIntermediateResponse(element);
            }
        }
        int msgID = 2293897;
        String message = MessageHandler.getMessage(msgID, element.getType());
        throw new LDAPException(2, msgID, message);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    public abstract void toString(StringBuilder var1, int var2);
}

