/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultReferenceProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private List<String> referralURLs;

    public SearchResultReferenceProtocolOp(List<String> referralURLs) {
        this.referralURLs = referralURLs == null ? new ArrayList<String>() : referralURLs;
    }

    public SearchResultReferenceProtocolOp(SearchResultReference searchReference) {
        this.referralURLs = searchReference.getReferralURLs();
        if (this.referralURLs == null) {
            this.referralURLs = new ArrayList<String>();
        }
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public byte getType() {
        return 115;
    }

    @Override
    public String getProtocolOpName() {
        return "Search Result Reference";
    }

    @Override
    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(this.referralURLs.size());
        for (String url : this.referralURLs) {
            elements.add(new ASN1OctetString(url));
        }
        return new ASN1Sequence(115, elements);
    }

    public static SearchResultReferenceProtocolOp decodeSearchReference(ASN1Element element) throws LDAPException {
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293882;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        ArrayList<String> referralURLs = new ArrayList<String>(elements.size());
        try {
            for (ASN1Element e : elements) {
                referralURLs.add(e.decodeAsOctetString().stringValue());
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293883;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new SearchResultReferenceProtocolOp(referralURLs);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SearchReference(referralURLs={");
        if (!this.referralURLs.isEmpty()) {
            Iterator<String> iterator = this.referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Search Result Reference");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Referral URLs:");
        buffer.append(ServerConstants.EOL);
        for (String url : this.referralURLs) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("    ");
            buffer.append(url);
            buffer.append(ServerConstants.EOL);
        }
    }
}

