/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.AttrInfoWithOptions;
import org.opends.server.replication.plugin.AttributeInfo;
import org.opends.server.replication.plugin.FakeOperation;
import org.opends.server.replication.plugin.HistKey;
import org.opends.server.replication.plugin.HistVal;
import org.opends.server.replication.plugin.ModifyFakeOperation;
import org.opends.server.replication.plugin.ValueInfo;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Historical {
    public static final String HISTORICALATTRIBUTENAME = "ds-sync-hist";
    public static final AttributeType historicalAttrType = DirectoryServer.getSchema().getAttributeType("ds-sync-hist");
    static final String ENTRYUIDNAME = "entryuuid";
    static final AttributeType entryuuidAttrType = DirectoryServer.getSchema().getAttributeType("entryuuid");
    private HashMap<AttributeType, AttrInfoWithOptions> attributesInfo = new HashMap();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.encode());
        return builder.toString();
    }

    public boolean replayOperation(PreOperationModifyOperation modifyOperation, Entry modifiedEntry) {
        boolean bConflict = false;
        List<Modification> mods = modifyOperation.getModifications();
        ChangeNumber changeNumber = OperationContext.getChangeNumber(modifyOperation);
        Iterator<Modification> modsIterator = mods.iterator();
        while (modsIterator.hasNext()) {
            Modification m = modsIterator.next();
            AttributeInfo attrInfo = this.getAttrInfo(m);
            if (!attrInfo.replayOperation(modsIterator, changeNumber, modifiedEntry, m)) continue;
            bConflict = true;
        }
        return bConflict;
    }

    public void generateState(PreOperationModifyOperation modifyOperation) {
        Modification mod2;
        List<Modification> mods = modifyOperation.getModifications();
        Entry modifiedEntry = modifyOperation.getModifiedEntry();
        ChangeNumber changeNumber = OperationContext.getChangeNumber(modifyOperation);
        if (!modifyOperation.isSynchronizationOperation()) {
            for (Modification mod2 : mods) {
                AttributeInfo attrInfo = this.getAttrInfo(mod2);
                if (attrInfo == null) continue;
                attrInfo.processLocalOrNonConflictModification(changeNumber, mod2);
            }
        }
        Attribute attr = this.encode();
        mod2 = new Modification(ModificationType.REPLACE, attr);
        mods.add(mod2);
        modifiedEntry.removeAttribute(historicalAttrType);
        modifiedEntry.addAttribute(attr, null);
    }

    private AttributeInfo getAttrInfo(Modification mod) {
        AttributeInfo attrInfo;
        Attribute modAttr = mod.getAttribute();
        if (modAttr.getAttributeType().equals(historicalAttrType)) {
            return null;
        }
        LinkedHashSet<String> options = modAttr.getOptions();
        AttributeType type = modAttr.getAttributeType();
        AttrInfoWithOptions attrInfoWithOptions = this.attributesInfo.get(type);
        if (attrInfoWithOptions != null) {
            attrInfo = attrInfoWithOptions.get(options);
        } else {
            attrInfoWithOptions = new AttrInfoWithOptions();
            this.attributesInfo.put(type, attrInfoWithOptions);
            attrInfo = null;
        }
        if (attrInfo == null) {
            attrInfo = AttributeInfo.createAttributeInfo(type);
            attrInfoWithOptions.put(options, attrInfo);
        }
        return attrInfo;
    }

    public Attribute encode() {
        LinkedHashSet<AttributeValue> hist = new LinkedHashSet<AttributeValue>();
        for (Map.Entry<AttributeType, AttrInfoWithOptions> entryWithOptions : this.attributesInfo.entrySet()) {
            AttributeType type = entryWithOptions.getKey();
            HashMap<Set<String>, AttributeInfo> attrwithoptions = entryWithOptions.getValue().getAttributesInfo();
            for (Map.Entry<Set<String>, AttributeInfo> entry : attrwithoptions.entrySet()) {
                ChangeNumber deleteTime;
                boolean delAttr = false;
                Set<String> options = entry.getKey();
                String optionsString = "";
                AttributeInfo info = entry.getValue();
                if (options != null) {
                    StringBuilder optionsBuilder = new StringBuilder();
                    for (String s : options) {
                        optionsBuilder.append(';');
                        optionsBuilder.append(s);
                    }
                    optionsString = optionsBuilder.toString();
                }
                if ((deleteTime = info.getDeleteTime()) != null) {
                    delAttr = true;
                }
                for (ValueInfo valInfo : info.getValuesInfo()) {
                    AttributeValue val;
                    String strValue;
                    if (valInfo.getValueDeleteTime() != null) {
                        strValue = type.getNormalizedPrimaryName() + optionsString + ":" + valInfo.getValueDeleteTime().toString() + ":del:" + valInfo.getValue().toString();
                        val = new AttributeValue(historicalAttrType, strValue);
                        hist.add(val);
                        continue;
                    }
                    if (valInfo.getValueUpdateTime() == null) continue;
                    if (delAttr && valInfo.getValueUpdateTime() == deleteTime) {
                        strValue = type.getNormalizedPrimaryName() + optionsString + ":" + valInfo.getValueUpdateTime().toString() + ":repl:" + valInfo.getValue().toString();
                        delAttr = false;
                    } else {
                        strValue = valInfo.getValue() == null ? type.getNormalizedPrimaryName() + optionsString + ":" + valInfo.getValueUpdateTime().toString() + ":add" : type.getNormalizedPrimaryName() + optionsString + ":" + valInfo.getValueUpdateTime().toString() + ":add:" + valInfo.getValue().toString();
                    }
                    val = new AttributeValue(historicalAttrType, strValue);
                    hist.add(val);
                }
                if (!delAttr) continue;
                String strValue = type.getNormalizedPrimaryName() + optionsString + ":" + deleteTime.toString() + ":attrDel";
                AttributeValue val = new AttributeValue(historicalAttrType, strValue);
                hist.add(val);
            }
        }
        Attribute attr = hist.isEmpty() ? new Attribute(historicalAttrType, HISTORICALATTRIBUTENAME, null) : new Attribute(historicalAttrType, HISTORICALATTRIBUTENAME, hist);
        return attr;
    }

    public static Historical load(Entry entry) {
        List<Attribute> hist = entry.getAttribute(historicalAttrType);
        Historical histObj = new Historical();
        AttributeType lastAttrType = null;
        Set<Object> lastOptions = new HashSet();
        AttributeInfo attrInfo = null;
        AttrInfoWithOptions attrInfoWithOptions = null;
        if (hist == null) {
            return histObj;
        }
        try {
            for (Attribute attr : hist) {
                for (AttributeValue val : attr.getValues()) {
                    HistVal histVal = new HistVal(val.getStringValue());
                    AttributeType attrType = histVal.getAttrType();
                    Set<String> options = histVal.getOptions();
                    ChangeNumber cn = histVal.getCn();
                    AttributeValue value = histVal.getAttributeValue();
                    HistKey histKey = histVal.getHistKey();
                    if (attrType == null) continue;
                    if (attrType != lastAttrType) {
                        attrInfo = AttributeInfo.createAttributeInfo(attrType);
                        attrInfoWithOptions = new AttrInfoWithOptions();
                        attrInfoWithOptions.put(options, attrInfo);
                        histObj.attributesInfo.put(attrType, attrInfoWithOptions);
                        lastAttrType = attrType;
                        lastOptions = options;
                    } else if (!((Object)options).equals(lastOptions)) {
                        attrInfo = AttributeInfo.createAttributeInfo(attrType);
                        attrInfoWithOptions.put(options, attrInfo);
                        lastOptions = options;
                    }
                    attrInfo.load(histKey, value, cn);
                }
            }
        }
        catch (Exception e) {
            int msgID = 14942264;
            String message = MessageHandler.getMessage(msgID, entry.getDN().toString());
            ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
        }
        return histObj;
    }

    public static Iterable<FakeOperation> generateFakeOperations(Entry entry) {
        TreeMap<ChangeNumber, ModifyFakeOperation> operations = new TreeMap<ChangeNumber, ModifyFakeOperation>();
        List<Attribute> attrs = entry.getOperationalAttribute(historicalAttrType);
        if (attrs != null) {
            for (Attribute attr : attrs) {
                for (AttributeValue val : attr.getValues()) {
                    HistVal histVal = new HistVal(val.getStringValue());
                    ChangeNumber cn = histVal.getCn();
                    Modification mod = histVal.generateMod();
                    FakeOperation fakeOperation = (FakeOperation)operations.get(cn);
                    if (fakeOperation != null) {
                        try {
                            fakeOperation.addModification(mod);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    String uuidString = Historical.getEntryUuid(entry);
                    if (uuidString == null) continue;
                    ModifyFakeOperation modifyFakeOperation = new ModifyFakeOperation(entry.getDN(), cn, uuidString);
                    modifyFakeOperation.addModification(mod);
                    operations.put(histVal.getCn(), modifyFakeOperation);
                }
            }
        }
        return operations.values();
    }

    public static String getEntryUuid(Entry entry) {
        Attribute uuid;
        String uuidString = null;
        List<Attribute> uuidAttrs = entry.getOperationalAttribute(entryuuidAttrType);
        if (uuidAttrs != null && (uuid = uuidAttrs.get(0)).hasValue()) {
            AttributeValue uuidVal = (AttributeValue)uuid.getValues().iterator().next();
            uuidString = uuidVal.getStringValue();
        }
        return uuidString;
    }

    public static String getEntryUuid(PreOperationAddOperation op) {
        Attribute uuid;
        String uuidString = null;
        Map<AttributeType, List<Attribute>> attrs = op.getOperationalAttributes();
        List<Attribute> uuidAttrs = attrs.get(entryuuidAttrType);
        if (uuidAttrs != null && (uuid = uuidAttrs.get(0)).hasValue()) {
            AttributeValue uuidVal = (AttributeValue)uuid.getValues().iterator().next();
            uuidString = uuidVal.getStringValue();
        }
        return uuidString;
    }
}

