/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.replication.plugin.ReplicationDomain;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

public class ListenerThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ReplicationDomain listener;
    private boolean shutdown = false;

    public ListenerThread(ReplicationDomain listener) {
        super("Replication Listener thread");
        this.listener = listener;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void run() {
        boolean done = false;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication Listener thread starting.");
        }
        while (!done) {
            try {
                UpdateMessage msg;
                while ((msg = this.listener.receive()) != null && !this.shutdown) {
                    this.listener.replay(msg);
                }
                done = true;
            }
            catch (Exception e) {
                int msgID = 14942242;
                String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication Listener thread stopping.");
        }
    }
}

