/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.server.ReplicationDB;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbHandler
implements Runnable {
    private LinkedList<UpdateMessage> msgQueue = new LinkedList();
    private ReplicationDB db;
    private ChangeNumber firstChange = null;
    private ChangeNumber lastChange = null;
    private short serverId;
    private DN baseDn;
    private DbMonitorProvider dbMonitor = new DbMonitorProvider();
    private boolean shutdown = false;
    private boolean done = false;
    private DirectoryThread thread = null;
    private Object flushLock = new Object();
    static final int MSG_QUEUE_HIMARK = 5000;
    static final int MSG_QUEUE_LOWMARK = 4000;
    private long trimage;

    public DbHandler(short id, DN baseDn, ReplicationServer replicationServer, ReplicationDbEnv dbenv) throws DatabaseException {
        this.serverId = id;
        this.baseDn = baseDn;
        this.trimage = replicationServer.getTrimage();
        this.db = new ReplicationDB(id, baseDn, replicationServer, dbenv);
        this.firstChange = this.db.readFirstChange();
        this.lastChange = this.db.readLastChange();
        this.thread = new DirectoryThread(this, "Replication Server db " + id + " " + baseDn);
        this.thread.start();
        DirectoryServer.deregisterMonitorProvider(this.dbMonitor.getMonitorInstanceName());
        DirectoryServer.registerMonitorProvider(this.dbMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(UpdateMessage update) {
        LinkedList<UpdateMessage> linkedList = this.msgQueue;
        synchronized (linkedList) {
            int size = this.msgQueue.size();
            while (size > 5000) {
                try {
                    this.msgQueue.wait(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                size = this.msgQueue.size();
            }
            this.msgQueue.add(update);
            if (this.lastChange == null || this.lastChange.older(update.getChangeNumber()).booleanValue()) {
                this.lastChange = update.getChangeNumber();
            }
            if (this.firstChange == null) {
                this.firstChange = update.getChangeNumber();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UpdateMessage> getChanges(int number) {
        LinkedList<UpdateMessage> changes = new LinkedList<UpdateMessage>();
        LinkedList<UpdateMessage> linkedList = this.msgQueue;
        synchronized (linkedList) {
            int size = this.msgQueue.size();
            for (int current = 0; current < number && current < size; ++current) {
                UpdateMessage msg = this.msgQueue.get(current);
                changes.add(msg);
            }
        }
        return changes;
    }

    public ChangeNumber getFirstChange() {
        return this.firstChange;
    }

    public ChangeNumber getLastChange() {
        return this.lastChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationIterator generateIterator(ChangeNumber changeNumber) throws DatabaseException, Exception {
        ChangeNumber recentChangeNumber = null;
        if (changeNumber == null) {
            this.flush();
        }
        LinkedList<UpdateMessage> linkedList = this.msgQueue;
        synchronized (linkedList) {
            try {
                UpdateMessage msg = this.msgQueue.getFirst();
                recentChangeNumber = msg.getChangeNumber();
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        if (recentChangeNumber != null && changeNumber != null && (recentChangeNumber.getTimeSec() - changeNumber.getTimeSec() < 2L || recentChangeNumber.getSeqnum() - changeNumber.getSeqnum() < 20)) {
            this.flush();
        }
        return new ReplicationIterator(this.serverId, this.db, changeNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(int number) {
        LinkedList<UpdateMessage> linkedList = this.msgQueue;
        synchronized (linkedList) {
            for (int current = 0; current < number && !this.msgQueue.isEmpty(); ++current) {
                this.msgQueue.remove();
            }
            if (this.msgQueue.size() < 4000) {
                this.msgQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        DbHandler dbHandler = this;
        synchronized (dbHandler) {
            this.notifyAll();
        }
        dbHandler = this;
        synchronized (dbHandler) {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
        }
        while (this.msgQueue.size() != 0) {
            this.flush();
        }
        this.db.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DbHandler dbHandler;
        while (!this.shutdown) {
            try {
                this.flush();
                this.trim();
                dbHandler = this;
                synchronized (dbHandler) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            catch (Exception end) {
                int msgID = 14942237;
                String message = MessageHandler.getMessage(msgID) + StaticUtils.stackTraceToSingleLineString(end);
                ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            }
        }
        this.flush();
        dbHandler = this;
        synchronized (dbHandler) {
            this.done = true;
            this.notifyAll();
        }
    }

    private void trim() throws DatabaseException, Exception {
        if (this.trimage == 0L) {
            return;
        }
        int size = 0;
        boolean finished = false;
        ChangeNumber trimDate = new ChangeNumber(TimeThread.getTime() - this.trimage, 0, 0);
        ReplicationDB.ReplServerDBCursor cursor = this.db.openDeleteCursor();
        try {
            while (size < 5000 && !finished) {
                ChangeNumber changeNumber = cursor.nextChangeNumber();
                if (changeNumber != null) {
                    if (!changeNumber.equals(this.lastChange) && changeNumber.older(trimDate).booleanValue()) {
                        ++size;
                        cursor.delete();
                        continue;
                    }
                    this.firstChange = changeNumber;
                    finished = true;
                    continue;
                }
                finished = true;
            }
            cursor.close();
        }
        catch (DatabaseException e) {
            cursor.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        int size;
        do {
            Object object = this.flushLock;
            synchronized (object) {
                List<UpdateMessage> changes = this.getChanges(500);
                if (changes == null || (size = changes.size()) == 0) {
                    return;
                }
                this.db.addEntries(changes);
                this.clear(changes.size());
            }
        } while (size >= 500);
    }

    public String toString() {
        return this.baseDn + " " + this.serverId + " " + this.firstChange + " " + this.lastChange;
    }

    public void setPurgeDelay(long delay) {
        this.trimage = delay;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DbMonitorProvider
    extends MonitorProvider<MonitorProviderCfg> {
        private DbMonitorProvider() {
            super("ReplicationServer Database");
        }

        public ArrayList<Attribute> getMonitorData() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(new Attribute("replicationServer-database", String.valueOf(DbHandler.this.serverId)));
            attributes.add(new Attribute("base-dn", DbHandler.this.baseDn.toString()));
            if (DbHandler.this.firstChange != null) {
                Date firstTime = new Date(DbHandler.this.firstChange.getTime());
                attributes.add(new Attribute("first-change", DbHandler.this.firstChange.toString() + " " + firstTime.toString()));
            }
            if (DbHandler.this.lastChange != null) {
                Date lastTime = new Date(DbHandler.this.lastChange.getTime());
                attributes.add(new Attribute("last-change", DbHandler.this.lastChange.toString() + " " + lastTime.toString()));
            }
            return attributes;
        }

        @Override
        public String getMonitorInstanceName() {
            return "ReplicationServer database " + DbHandler.this.baseDn.toString() + " " + String.valueOf(DbHandler.this.serverId);
        }

        @Override
        public long getUpdateInterval() {
            return 0L;
        }

        @Override
        public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        }

        @Override
        public void updateMonitorData() {
        }
    }
}

