/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.server.ReplicationData;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationKey;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationDB {
    private Database db = null;
    private ReplicationDbEnv dbenv = null;
    private ReplicationServer replicationServer;
    private Short serverId;
    private DN baseDn;

    public ReplicationDB(Short serverId, DN baseDn, ReplicationServer replicationServer, ReplicationDbEnv dbenv) throws DatabaseException {
        this.serverId = serverId;
        this.baseDn = baseDn;
        this.dbenv = dbenv;
        this.replicationServer = replicationServer;
        this.db = dbenv.getOrAddDb(serverId, baseDn);
    }

    public void addEntries(List<UpdateMessage> changes) {
        Transaction txn = null;
        try {
            txn = this.dbenv.beginTransaction();
            for (UpdateMessage change : changes) {
                ReplicationKey key = new ReplicationKey(change.getChangeNumber());
                ReplicationData data = new ReplicationData(change);
                try {
                    this.db.put(txn, (DatabaseEntry)key, (DatabaseEntry)data);
                }
                catch (DatabaseException e) {
                    int msgID = 15007770;
                    String message = MessageHandler.getMessage(msgID) + StaticUtils.stackTraceToSingleLineString(e);
                    ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    this.replicationServer.shutdown();
                }
            }
            txn.commitWriteNoSync();
            txn = null;
        }
        catch (DatabaseException e) {
            int msgID = 15007770;
            String message = MessageHandler.getMessage(msgID) + StaticUtils.stackTraceToSingleLineString(e);
            ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            if (txn != null) {
                try {
                    txn.abort();
                }
                catch (DatabaseException e1) {
                    // empty catch block
                }
            }
            this.replicationServer.shutdown();
        }
        catch (UnsupportedEncodingException e) {
            int msgID = 14942268;
            String message = MessageHandler.getMessage(msgID) + StaticUtils.stackTraceToSingleLineString(e);
            ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            this.replicationServer.shutdown();
            if (txn != null) {
                try {
                    txn.abort();
                }
                catch (DatabaseException e1) {
                    // empty catch block
                }
            }
            this.replicationServer.shutdown();
        }
    }

    public void shutdown() {
        try {
            this.db.close();
        }
        catch (DatabaseException e) {
            int msgID = 15138840;
            String message = MessageHandler.getMessage(msgID, this.toString()) + StaticUtils.stackTraceToSingleLineString(e);
            ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, message, msgID);
        }
    }

    public ReplServerDBCursor openReadCursor(ChangeNumber changeNumber) throws DatabaseException, Exception {
        return new ReplServerDBCursor(changeNumber);
    }

    public ReplServerDBCursor openDeleteCursor() throws DatabaseException, Exception {
        return new ReplServerDBCursor();
    }

    public ChangeNumber readFirstChange() {
        Cursor cursor;
        String str = null;
        try {
            cursor = this.db.openCursor(null, null);
        }
        catch (DatabaseException e1) {
            return null;
        }
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = cursor.getFirst(key, data, LockMode.DEFAULT);
            cursor.close();
            if (status != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                str = new String(key.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            return new ChangeNumber(str);
        }
        catch (DatabaseException e) {
            try {
                cursor.close();
            }
            catch (DatabaseException dbe) {
                // empty catch block
            }
            int msgID = 15007770;
            String message = MessageHandler.getMessage(msgID) + StaticUtils.stackTraceToSingleLineString(e);
            ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            this.replicationServer.shutdown();
            return null;
        }
    }

    public ChangeNumber readLastChange() {
        String str = null;
        try {
            Cursor cursor = this.db.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = cursor.getLast(key, data, LockMode.DEFAULT);
            cursor.close();
            if (status != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                str = new String(key.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            return new ChangeNumber(str);
        }
        catch (DatabaseException e) {
            int msgID = 15007770;
            String message = MessageHandler.getMessage(msgID) + StaticUtils.stackTraceToSingleLineString(e);
            ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            this.replicationServer.shutdown();
            return null;
        }
    }

    public String toString() {
        return this.serverId.toString() + this.baseDn.toString();
    }

    public class ReplServerDBCursor {
        private Cursor cursor = null;
        private Transaction txn = null;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();

        private ReplServerDBCursor(ChangeNumber startingChangeNumber) throws Exception {
            this.cursor = ReplicationDB.this.db.openCursor(this.txn, null);
            if (startingChangeNumber != null) {
                this.key = new ReplicationKey(startingChangeNumber);
                this.data = new DatabaseEntry();
                if (this.cursor.getSearchKey(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                    if (this.cursor.getSearchKeyRange(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                        throw new Exception("ChangeNumber not available");
                    }
                    DatabaseEntry key = new DatabaseEntry();
                    DatabaseEntry data = new DatabaseEntry();
                    if (this.cursor.getPrev(key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                        this.cursor = ReplicationDB.this.db.openCursor(this.txn, null);
                    }
                }
            }
        }

        private ReplServerDBCursor() throws DatabaseException {
            this.txn = ReplicationDB.this.dbenv.beginTransaction();
            this.cursor = ReplicationDB.this.db.openCursor(this.txn, null);
        }

        public void close() {
            String message;
            int msgID;
            if (this.cursor == null) {
                return;
            }
            try {
                this.cursor.close();
                this.cursor = null;
            }
            catch (DatabaseException e) {
                msgID = 15007770;
                message = MessageHandler.getMessage(msgID) + StaticUtils.stackTraceToSingleLineString(e);
                ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                ReplicationDB.this.replicationServer.shutdown();
            }
            if (this.txn != null) {
                try {
                    this.txn.commit();
                }
                catch (DatabaseException e) {
                    msgID = 15007770;
                    message = MessageHandler.getMessage(msgID) + StaticUtils.stackTraceToSingleLineString(e);
                    ErrorLogger.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    ReplicationDB.this.replicationServer.shutdown();
                }
            }
        }

        public ChangeNumber nextChangeNumber() throws DatabaseException {
            OperationStatus status = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
            if (status != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                String csnString = new String(this.key.getData(), "UTF-8");
                return new ChangeNumber(csnString);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }

        public UpdateMessage next() {
            UpdateMessage currentChange = null;
            while (currentChange == null) {
                try {
                    OperationStatus status = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
                    if (status != OperationStatus.SUCCESS) {
                        return null;
                    }
                }
                catch (DatabaseException e) {
                    return null;
                }
                try {
                    currentChange = ReplicationData.generateChange(this.data.getData());
                }
                catch (Exception exception) {}
            }
            return currentChange;
        }

        public void delete() throws DatabaseException {
            this.cursor.delete();
        }
    }
}

