/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.AttributeTypeDescriptionAttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTypeSyntax
extends AttributeSyntax<AttributeTypeDescriptionAttributeSyntaxCfg>
implements ConfigurationChangeListener<AttributeTypeDescriptionAttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeTypeDescriptionAttributeSyntaxCfg currentConfig;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;
    private static boolean stripMinimumUpperBound = false;

    @Override
    public void initializeSyntax(AttributeTypeDescriptionAttributeSyntaxCfg configuration) throws ConfigException, InitializationException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            int msgID = 6553602;
            String message = MessageHandler.getMessage(msgID, "2.5.13.2", "AttributeTypeDescription");
            throw new InitializationException(msgID, message);
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            int msgID = 6553603;
            String message = MessageHandler.getMessage(msgID, "2.5.13.3", "AttributeTypeDescription");
            throw new InitializationException(msgID, message);
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            int msgID = 0x640004;
            String message = MessageHandler.getMessage(msgID, "2.5.13.4", "AttributeTypeDescription");
            throw new InitializationException(msgID, message);
        }
        if (configuration == null) {
            return;
        }
        this.currentConfig = configuration;
        this.currentConfig.addAttributeTypeDescriptionChangeListener(this);
        stripMinimumUpperBound = configuration.isStripSyntaxMinimumUpperBound();
    }

    @Override
    public String getSyntaxName() {
        return "AttributeTypeDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.3";
    }

    @Override
    public String getDescription() {
        return "Attribute Type Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        try {
            AttributeTypeSyntax.decodeAttributeType(value, DirectoryServer.getSchema(), true);
            return true;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            invalidReason.append(de.getErrorMessage());
            return false;
        }
    }

    public static AttributeType decodeAttributeType(ByteString value, Schema schema, boolean allowUnknownElements) throws DirectoryException {
        String message;
        String message2;
        char c;
        int pos;
        String valueStr = value.stringValue();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            int msgID = 6488116;
            String message3 = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message3, msgID);
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            int msgID = 6488117;
            String message4 = MessageHandler.getMessage(msgID, valueStr, pos - 1, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message4, msgID);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            int msgID = 0x630036;
            String message5 = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message5, msgID);
        }
        int oidStartPos = pos;
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        int msgID = 6488119;
                        String message6 = MessageHandler.getMessage(msgID, valueStr, pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message6, msgID);
                    }
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int msgID = 6488120;
                    String message7 = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message7, msgID);
                }
                lastWasPeriod = false;
            }
        } else {
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int msgID = 6488121;
                String message8 = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message8, msgID);
            }
        }
        if (pos >= length) {
            int msgID = 0x630036;
            String message9 = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message9, msgID);
        }
        String oid = lowerStr.substring(oidStartPos, pos - 1);
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            int msgID = 0x630036;
            String message10 = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message10, msgID);
        }
        String primaryName = oid;
        LinkedList<String> typeNames = new LinkedList<String>();
        String description = null;
        AttributeType superiorType = null;
        AttributeSyntax syntax = DirectoryServer.getDefaultAttributeSyntax();
        ApproximateMatchingRule approximateMatchingRule = null;
        EqualityMatchingRule equalityMatchingRule = null;
        OrderingMatchingRule orderingMatchingRule = null;
        SubstringMatchingRule substringMatchingRule = null;
        AttributeUsage attributeUsage = AttributeUsage.USER_APPLICATIONS;
        boolean isCollective = false;
        boolean isNoUserModification = false;
        boolean isObsolete = false;
        boolean isSingleValue = false;
        LinkedHashMap<String, List<String>> extraProperties = new LinkedHashMap<String, List<String>>();
        block5: while (true) {
            StringBuilder tokenNameBuffer = new StringBuilder();
            pos = AttributeTypeSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
            String tokenName = tokenNameBuffer.toString();
            String lowerTokenName = StaticUtils.toLowerCase(tokenName);
            if (tokenName.equals(")")) {
                if (pos >= length) break;
                int msgID = 6488123;
                String message11 = MessageHandler.getMessage(msgID, valueStr, pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message11, msgID);
            }
            if (lowerTokenName.equals("name")) {
                if ((c = valueStr.charAt(pos++)) == '\'') {
                    StringBuilder userBuffer = new StringBuilder();
                    StringBuilder lowerBuffer = new StringBuilder();
                    pos = AttributeTypeSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos - 1);
                    primaryName = userBuffer.toString();
                    typeNames.add(primaryName);
                    continue;
                }
                if (c == '(') {
                    StringBuilder userBuffer = new StringBuilder();
                    StringBuilder lowerBuffer = new StringBuilder();
                    pos = AttributeTypeSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                    primaryName = userBuffer.toString();
                    typeNames.add(primaryName);
                    while (true) {
                        if (valueStr.charAt(pos) == ')') {
                            ++pos;
                            while (true) {
                                if (pos >= length || (c = valueStr.charAt(pos)) != ' ') continue block5;
                                ++pos;
                            }
                        }
                        userBuffer = new StringBuilder();
                        lowerBuffer = new StringBuilder();
                        pos = AttributeTypeSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                        typeNames.add(userBuffer.toString());
                    }
                }
                int msgID = 6488122;
                String message12 = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message12, msgID);
            }
            if (lowerTokenName.equals("desc")) {
                StringBuilder descriptionBuffer = new StringBuilder();
                pos = AttributeTypeSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
                description = descriptionBuffer.toString();
                continue;
            }
            if (lowerTokenName.equals("obsolete")) {
                isObsolete = true;
                continue;
            }
            if (lowerTokenName.equals("sup")) {
                StringBuilder woidBuffer = new StringBuilder();
                pos = AttributeTypeSyntax.readWOID(lowerStr, woidBuffer, pos);
                superiorType = schema.getAttributeType(woidBuffer.toString());
                if (superiorType == null) {
                    if (allowUnknownElements) {
                        superiorType = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                    } else {
                        int msgID = 6422589;
                        message2 = MessageHandler.getMessage(msgID, String.valueOf(oid), String.valueOf(woidBuffer));
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message2, msgID);
                    }
                }
                approximateMatchingRule = superiorType.getApproximateMatchingRule();
                equalityMatchingRule = superiorType.getEqualityMatchingRule();
                orderingMatchingRule = superiorType.getOrderingMatchingRule();
                substringMatchingRule = superiorType.getSubstringMatchingRule();
                syntax = superiorType.getSyntax();
                isSingleValue = superiorType.isSingleValue();
                isCollective = superiorType.isCollective();
                isNoUserModification = superiorType.isNoUserModification();
                attributeUsage = superiorType.getUsage();
                continue;
            }
            if (lowerTokenName.equals("equality")) {
                StringBuilder woidBuffer = new StringBuilder();
                pos = AttributeTypeSyntax.readWOID(lowerStr, woidBuffer, pos);
                EqualityMatchingRule emr = schema.getEqualityMatchingRule(woidBuffer.toString());
                if (emr == null) {
                    int msgID = 6422591;
                    String message13 = MessageHandler.getMessage(msgID, String.valueOf(oid), String.valueOf(woidBuffer));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message13, msgID);
                }
                equalityMatchingRule = emr;
                continue;
            }
            if (lowerTokenName.equals("ordering")) {
                StringBuilder woidBuffer = new StringBuilder();
                pos = AttributeTypeSyntax.readWOID(lowerStr, woidBuffer, pos);
                OrderingMatchingRule omr = schema.getOrderingMatchingRule(woidBuffer.toString());
                if (omr == null) {
                    int msgID = 6422592;
                    String message14 = MessageHandler.getMessage(msgID, String.valueOf(oid), String.valueOf(woidBuffer));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message14, msgID);
                }
                orderingMatchingRule = omr;
                continue;
            }
            if (lowerTokenName.equals("substr")) {
                StringBuilder woidBuffer = new StringBuilder();
                pos = AttributeTypeSyntax.readWOID(lowerStr, woidBuffer, pos);
                SubstringMatchingRule smr = schema.getSubstringMatchingRule(woidBuffer.toString());
                if (smr == null) {
                    int msgID = 6422593;
                    String message15 = MessageHandler.getMessage(msgID, String.valueOf(oid), String.valueOf(woidBuffer));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message15, msgID);
                }
                substringMatchingRule = smr;
                continue;
            }
            if (lowerTokenName.equals("syntax")) {
                boolean inBrace = false;
                boolean lastWasPeriod = false;
                StringBuilder oidBuffer = new StringBuilder();
                while (pos < length) {
                    c = lowerStr.charAt(pos++);
                    if (inBrace) {
                        if (c == '}') {
                            c = lowerStr.charAt(pos);
                            if (c == ' ') break;
                            int msgID = 6488120;
                            String message16 = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message16, msgID);
                        }
                        if (StaticUtils.isDigit(c)) continue;
                        int msgID = 6488120;
                        String message17 = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message17, msgID);
                    }
                    if (StaticUtils.isDigit(c)) {
                        oidBuffer.append(c);
                        lastWasPeriod = false;
                        continue;
                    }
                    if (c == '.') {
                        if (lastWasPeriod) {
                            int msgID = 6488119;
                            String message18 = MessageHandler.getMessage(msgID, valueStr, pos - 1);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message18, msgID);
                        }
                        oidBuffer.append(c);
                        lastWasPeriod = true;
                        continue;
                    }
                    if (c == '{') {
                        inBrace = true;
                        continue;
                    }
                    if (c == ' ') break;
                    int msgID = 6488120;
                    String message19 = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message19, msgID);
                }
                if ((syntax = schema.getSyntax(oidBuffer.toString())) == null) {
                    int msgID = 6422594;
                    String message20 = MessageHandler.getMessage(msgID, String.valueOf(oid), String.valueOf(oidBuffer));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message20, msgID);
                }
                if (approximateMatchingRule == null) {
                    approximateMatchingRule = syntax.getApproximateMatchingRule();
                }
                if (equalityMatchingRule == null) {
                    equalityMatchingRule = syntax.getEqualityMatchingRule();
                }
                if (orderingMatchingRule == null) {
                    orderingMatchingRule = syntax.getOrderingMatchingRule();
                }
                if (substringMatchingRule != null) continue;
                substringMatchingRule = syntax.getSubstringMatchingRule();
                continue;
            }
            if (lowerTokenName.equals("single-value")) {
                isSingleValue = true;
                continue;
            }
            if (lowerTokenName.equals("collective")) {
                isCollective = true;
                continue;
            }
            if (lowerTokenName.equals("no-user-modification")) {
                isNoUserModification = true;
                continue;
            }
            if (lowerTokenName.equals("usage")) {
                StringBuilder usageBuffer = new StringBuilder();
                while (pos < length && (c = lowerStr.charAt(pos++)) != ' ') {
                    usageBuffer.append(c);
                }
                String usageStr = usageBuffer.toString();
                if (usageStr.equals("userapplications")) {
                    attributeUsage = AttributeUsage.USER_APPLICATIONS;
                    continue;
                }
                if (usageStr.equals("directoryoperation")) {
                    attributeUsage = AttributeUsage.DIRECTORY_OPERATION;
                    continue;
                }
                if (usageStr.equals("distributedoperation")) {
                    attributeUsage = AttributeUsage.DISTRIBUTED_OPERATION;
                    continue;
                }
                if (usageStr.equals("dsaoperation")) {
                    attributeUsage = AttributeUsage.DSA_OPERATION;
                    continue;
                }
                attributeUsage = AttributeUsage.USER_APPLICATIONS;
                int msgID = 6422595;
                String message21 = MessageHandler.getMessage(msgID, String.valueOf(oid), String.valueOf(usageBuffer), String.valueOf((Object)attributeUsage));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message21, msgID);
            }
            ArrayList<String> valueList = new ArrayList<String>();
            pos = AttributeTypeSyntax.readExtraParameterValues(valueStr, valueList, pos);
            extraProperties.put(tokenName, valueList);
        }
        List approxRules = (List)((HashMap)extraProperties).get("X-APPROX");
        if (approxRules != null && !approxRules.isEmpty()) {
            String ruleName = (String)approxRules.get(0);
            String lowerName = StaticUtils.toLowerCase(ruleName);
            ApproximateMatchingRule amr = schema.getApproximateMatchingRule(lowerName);
            if (amr == null) {
                int msgID = 6422590;
                message2 = MessageHandler.getMessage(msgID, String.valueOf(oid), String.valueOf(ruleName));
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message2, msgID);
            }
            approximateMatchingRule = amr;
        }
        if (superiorType != null) {
            if (superiorType.getUsage() != attributeUsage) {
                int msgID = 6422796;
                message = MessageHandler.getMessage(msgID, oid, String.valueOf((Object)attributeUsage), superiorType.getNameOrOID());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
            }
            if (superiorType.isCollective() != isCollective) {
                int msgID = isCollective ? 6422797 : 6422798;
                message = MessageHandler.getMessage(msgID, oid, superiorType.getNameOrOID());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
            }
        }
        if (isCollective && attributeUsage != AttributeUsage.USER_APPLICATIONS) {
            int msgID = 6422801;
            message = MessageHandler.getMessage(msgID, oid);
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        if (isNoUserModification && attributeUsage == AttributeUsage.USER_APPLICATIONS) {
            int msgID = 6422802;
            message = MessageHandler.getMessage(msgID, oid);
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        return new AttributeType(value.stringValue(), primaryName, typeNames, oid, description, superiorType, syntax, approximateMatchingRule, equalityMatchingRule, orderingMatchingRule, substringMatchingRule, attributeUsage, isCollective, isNoUserModification, isObsolete, isSingleValue, extraProperties);
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 0x630036;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 0x630036;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c != '\'') {
            int msgID = 6422596;
            String message = MessageHandler.getMessage(msgID, valueStr, startPos, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 0x630036;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, String lowerStr, StringBuilder userBuffer, StringBuilder lowerBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 0x630036;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c != '\'') {
            int msgID = 6422596;
            String message = MessageHandler.getMessage(msgID, valueStr, startPos, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) != '\'') {
            lowerBuffer.append(c);
            userBuffer.append(valueStr.charAt(startPos));
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 0x630036;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readWOID(String lowerStr, StringBuilder woidBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 0x630036;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        int msgID = 6488119;
                        String message = MessageHandler.getMessage(msgID, lowerStr, startPos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    woidBuffer.append(c);
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return startPos - 1;
                    }
                    int msgID = 6488120;
                    String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                woidBuffer.append(c);
                lastWasPeriod = false;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    woidBuffer.append(c);
                    continue;
                }
                if (c == ')') {
                    return startPos - 1;
                }
                int msgID = 6488121;
                String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
        } else {
            int msgID = 6488122;
            String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 0x630036;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readExtraParameterValues(String valueStr, List<String> valueList, int startPos) throws DirectoryException {
        StringBuilder valueBuffer;
        int length = valueStr.length();
        char c = valueStr.charAt(startPos++);
        while (startPos < length && c == ' ') {
            c = valueStr.charAt(startPos++);
        }
        if (startPos >= length) {
            int msgID = 0x630036;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c == '\'') {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != '\'') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        } else if (c == '(') {
            while (true) {
                ++startPos;
                while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
                    ++startPos;
                }
                if (startPos >= length) {
                    int msgID = 0x630036;
                    String message = MessageHandler.getMessage(msgID, valueStr);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                if (c != ')') {
                    if (c == '(') {
                        int msgID = 6488122;
                        String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), startPos);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    startPos = AttributeTypeSyntax.readExtraParameterValues(valueStr, valueList, startPos);
                    continue;
                }
                break;
            }
        } else {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        }
        while (startPos < length && valueStr.charAt(startPos) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 0x630036;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AttributeTypeDescriptionAttributeSyntaxCfg configuration) {
        this.currentConfig = configuration;
        stripMinimumUpperBound = configuration.isStripSyntaxMinimumUpperBound();
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AttributeTypeDescriptionAttributeSyntaxCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    public static boolean isStripSyntaxMinimumUpperBound() {
        return stripMinimumUpperBound;
    }
}

