/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    public static final AttributeValueDecoder<Boolean> DECODER = new AttributeValueDecoder<Boolean>(){

        @Override
        public Boolean decode(AttributeValue value) throws DirectoryException {
            ByteString octetString = value.getNormalizedValue();
            return BooleanSyntax.decodeBooleanValue(octetString);
        }
    };

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.13");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.13", "Boolean");
        }
    }

    @Override
    public String getSyntaxName() {
        return "Boolean";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.7";
    }

    @Override
    public String getDescription() {
        return "Boolean";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return null;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        boolean returnValue;
        String valueString = value.stringValue().toUpperCase();
        boolean bl = returnValue = valueString.equals("TRUE") || valueString.equals("YES") || valueString.equals("ON") || valueString.equals("1") || valueString.equals("FALSE") || valueString.equals("NO") || valueString.equals("OFF") || valueString.equals("0");
        if (!returnValue) {
            invalidReason.append(MessageHandler.getMessage(6422533, value.stringValue()));
        }
        return returnValue;
    }

    public static AttributeValue createBooleanValue(boolean b) {
        if (b) {
            return new AttributeValue(new ASN1OctetString("TRUE"), (ByteString)new ASN1OctetString("TRUE"));
        }
        return new AttributeValue(new ASN1OctetString("FALSE"), (ByteString)new ASN1OctetString("FALSE"));
    }

    public static boolean decodeBooleanValue(ByteString normalizedValue) throws DirectoryException {
        String valueString = normalizedValue.stringValue();
        if (valueString.equals("TRUE")) {
            return true;
        }
        if (valueString.equals("FALSE")) {
            return false;
        }
        int msgID = 6422533;
        String message = MessageHandler.getMessage(msgID, valueString);
        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
    }
}

